/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.tileentity;

import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.container.AutomationSensitiveItemStackHandler;
import com.resourcefulbees.resourcefulbees.container.HoneyCongealerContainer;
import com.resourcefulbees.resourcefulbees.network.NetPacketHandler;
import com.resourcefulbees.resourcefulbees.network.packets.SyncGUIMessage;
import com.resourcefulbees.resourcefulbees.registry.ModTileEntityTypes;
import com.resourcefulbees.resourcefulbees.tileentity.AbstractHoneyTank;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HoneyCongealerTileEntity
extends AbstractHoneyTank
implements ITickableTileEntity,
INamedContainerProvider {
    public static final int BOTTLE_OUTPUT = 0;
    private final AutomationSensitiveItemStackHandler tileStackHandler = new TileStackHandler(2, this.getAcceptor(), this.getRemover());
    private final LazyOptional<IItemHandler> lazyOptional = LazyOptional.of(this::getTileStackHandler);
    private boolean dirty;
    private int processingFill;

    public HoneyCongealerTileEntity() {
        super((TileEntityType)ModTileEntityTypes.HONEY_CONGEALER_TILE_ENTITY.get(), 16000);
    }

    public float getProcessPercent() {
        if (!this.canProcessFill()) {
            return 0.0f;
        }
        if (this.processingFill == (Integer)Config.HONEY_PROCEESS_TIME.get() * (Integer)Config.CONGEALER_TIME_MODIFIER.get()) {
            return 1.0f;
        }
        return (float)this.processingFill / ((float)((Integer)Config.HONEY_PROCEESS_TIME.get()).intValue() * (float)((Integer)Config.CONGEALER_TIME_MODIFIER.get()).intValue());
    }

    @NotNull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("gui.resourcefulbees.honey_congealer");
    }

    @Nullable
    public Container createMenu(int id, @NotNull PlayerInventory inventory, @NotNull PlayerEntity playerEntity) {
        if (this.field_145850_b == null) {
            return null;
        }
        return new HoneyCongealerContainer(id, this.field_145850_b, this.field_174879_c, inventory);
    }

    public boolean canProcessFill() {
        FluidStack fluidStack = this.getFluidTank().getFluid();
        ItemStack outputStack = this.getTileStackHandler().getStackInSlot(0);
        Item outputHoney = BeeInfoUtils.getHoneyBlock(fluidStack.getFluid());
        boolean isTankReady = !fluidStack.isEmpty() && this.getFluidTank().getFluidAmount() >= 1000;
        boolean hasHoneyBlock = outputHoney != Items.field_190931_a;
        boolean canOutput = outputStack.func_190926_b() || outputStack.func_77973_b() == outputHoney && outputStack.func_190916_E() < outputStack.func_77976_d();
        return isTankReady && hasHoneyBlock && canOutput;
    }

    public void processFill() {
        FluidStack fluidStack = new FluidStack(this.getFluidTank().getFluid(), 1000);
        ItemStack outputStack = this.getTileStackHandler().getStackInSlot(0);
        if (outputStack.func_190926_b()) {
            outputStack = new ItemStack((IItemProvider)BeeInfoUtils.getHoneyBlock(fluidStack.getFluid()));
        } else {
            outputStack.func_190917_f(1);
        }
        this.getTileStackHandler().setStackInSlot(0, outputStack);
        this.getFluidTank().drain(fluidStack, IFluidHandler.FluidAction.EXECUTE);
    }

    @NotNull
    public AutomationSensitiveItemStackHandler getTileStackHandler() {
        return this.tileStackHandler;
    }

    public AutomationSensitiveItemStackHandler.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> false;
    }

    public AutomationSensitiveItemStackHandler.IRemover getRemover() {
        return (slot, automation) -> !automation || slot == 0;
    }

    public void sendGUINetworkPacket(IContainerListener player) {
        if (player instanceof ServerPlayerEntity && !(player instanceof FakePlayer)) {
            PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
            buffer.writeFluidStack(this.getFluidTank().getFluid());
            NetPacketHandler.sendToPlayer(new SyncGUIMessage(this.field_174879_c, buffer), (ServerPlayerEntity)player);
        }
    }

    public void handleGUINetworkPacket(PacketBuffer buffer) {
        this.getFluidTank().setFluid(buffer.readFluidStack());
    }

    public void func_73660_a() {
        if (this.canProcessFill()) {
            if (this.processingFill >= (Integer)Config.HONEY_PROCEESS_TIME.get() * (Integer)Config.CONGEALER_TIME_MODIFIER.get()) {
                this.processFill();
                this.processingFill = 0;
            }
            ++this.processingFill;
        }
        if (this.dirty) {
            this.dirty = false;
            this.func_70296_d();
        }
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.lazyOptional.cast() : super.getCapability(cap, side);
    }

    @Override
    public CompoundNBT writeNBT(CompoundNBT tag) {
        CompoundNBT inv = this.getTileStackHandler().serializeNBT();
        tag.func_218657_a("inv", (INBT)inv);
        return super.writeNBT(tag);
    }

    @Override
    public void readNBT(CompoundNBT tag) {
        super.readNBT(tag);
        CompoundNBT invTag = tag.func_74775_l("inv");
        this.getTileStackHandler().deserializeNBT(invTag);
    }

    protected class TileStackHandler
    extends AutomationSensitiveItemStackHandler {
        protected TileStackHandler(int slots, AutomationSensitiveItemStackHandler.IAcceptor acceptor, AutomationSensitiveItemStackHandler.IRemover remover) {
            super(slots, acceptor, remover);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            HoneyCongealerTileEntity.this.func_70296_d();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.func_77973_b() == Items.field_151069_bo;
        }
    }
}

