/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.tileentity;

import com.google.common.collect.Sets;
import com.resourcefulbees.resourcefulbees.ResourcefulBees;
import com.resourcefulbees.resourcefulbees.block.EnderBeecon;
import com.resourcefulbees.resourcefulbees.capabilities.HoneyFluidTank;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.container.EnderBeeconContainer;
import com.resourcefulbees.resourcefulbees.entity.passive.CustomBeeEntity;
import com.resourcefulbees.resourcefulbees.lib.TranslationConstants;
import com.resourcefulbees.resourcefulbees.network.NetPacketHandler;
import com.resourcefulbees.resourcefulbees.network.packets.BeeconChangeMessage;
import com.resourcefulbees.resourcefulbees.network.packets.NewSyncGUIMessage;
import com.resourcefulbees.resourcefulbees.registry.ModEffects;
import com.resourcefulbees.resourcefulbees.registry.ModTileEntityTypes;
import com.resourcefulbees.resourcefulbees.tileentity.ISyncableGUI;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import io.netty.buffer.Unpooled;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnderBeeconTileEntity
extends TileEntity
implements ISyncableGUI,
ITickableTileEntity {
    public static final Set<Effect> ALLOWED_EFFECTS = Sets.newHashSet((Object[])new Effect[]{(Effect)ModEffects.CALMING.get(), Effects.field_76427_o, Effects.field_76426_n, Effects.field_76428_l});
    private final HoneyFluidTank tank = new HoneyFluidTank(16000){

        protected void onContentsChanged() {
            EnderBeeconTileEntity.this.updateBeecon = true;
            if (EnderBeeconTileEntity.this.func_145831_w() != null && !EnderBeeconTileEntity.this.func_145831_w().func_201670_d()) {
                NetPacketHandler.sendToAllLoaded(new NewSyncGUIMessage(EnderBeeconTileEntity.this.func_174877_v(), EnderBeeconTileEntity.this.getBufToSend()), EnderBeeconTileEntity.this.func_145831_w(), EnderBeeconTileEntity.this.func_174877_v());
            }
        }
    };
    private final LazyOptional<FluidTank> tankOptional = LazyOptional.of(() -> this.tank);
    private boolean updateBeecon = true;
    private boolean beeconActive = false;
    private Set<Effect> effects = new LinkedHashSet<Effect>();
    private int range = 10;

    public EnderBeeconTileEntity() {
        super((TileEntityType)ModTileEntityTypes.ENDER_BEECON_TILE_ENTITY.get());
    }

    @NotNull
    public ITextComponent func_145748_c_() {
        return TranslationConstants.Guis.BEECON;
    }

    @Nullable
    public Container createMenu(int id, @NotNull PlayerInventory playerInventory, @NotNull PlayerEntity playerEntity) {
        if (this.field_145850_b == null) {
            return null;
        }
        return new EnderBeeconContainer(id, this.field_145850_b, this.field_174879_c, playerInventory);
    }

    @NotNull
    public CompoundNBT func_189515_b(@NotNull CompoundNBT nbt) {
        nbt.func_218657_a("Tank", (INBT)this.tank.writeToNBT(new CompoundNBT()));
        nbt.func_74768_a("range", this.range);
        nbt.func_218657_a("active_effects", (INBT)this.writeEffectsToNBT(new ListNBT()));
        return super.func_189515_b(nbt);
    }

    public void func_230337_a_(@NotNull BlockState state, @NotNull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.tank.readFromNBT(nbt.func_74775_l("Tank"));
        this.effects = this.readEffectsFromNBT(nbt.func_150295_c("active_effects", 8));
        this.range = nbt.func_74762_e("range");
        this.range = Math.max(Math.min(this.range, 50), 10);
    }

    @NotNull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        if (this.doEffects()) {
            this.tank.drain(this.getDrain(), IFluidHandler.FluidAction.EXECUTE);
        }
        if (this.field_145850_b.func_82737_E() % 80L == 0L && !this.tank.isEmpty()) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            List bees = this.field_145850_b.func_217357_a(BeeEntity.class, this.getEffectBox(this.field_145850_b));
            bees.stream().filter(CustomBeeEntity.class::isInstance).map(CustomBeeEntity.class::cast).forEach(CustomBeeEntity::setHasDisruptorInRange);
            this.addEffectsToBees(this.field_145850_b, bees);
            if (state.func_235901_b_((Property)EnderBeecon.SOUND) && Boolean.TRUE.equals(state.func_177229_b((Property)EnderBeecon.SOUND))) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_206939_L, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
        this.pullFluidFromBelow(this.field_145850_b);
        this.startUpCheck(this.field_145850_b);
    }

    private void startUpCheck(@NotNull World level) {
        if (level.field_72995_K) {
            return;
        }
        boolean flag = this.tank.getFluidAmount() > 0;
        BlockState state = level.func_180495_p(this.field_174879_c);
        if (this.updateBeecon) {
            if (flag && !this.beeconActive) {
                if (state.func_235901_b_((Property)EnderBeecon.SOUND) && Boolean.TRUE.equals(state.func_177229_b((Property)EnderBeecon.SOUND))) {
                    level.func_184133_a(null, this.field_174879_c, SoundEvents.field_206938_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                this.beeconActive = true;
            } else if (!flag && this.beeconActive) {
                if (state.func_235901_b_((Property)EnderBeecon.SOUND) && Boolean.TRUE.equals(state.func_177229_b((Property)EnderBeecon.SOUND))) {
                    level.func_184133_a(null, this.field_174879_c, SoundEvents.field_206940_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                this.beeconActive = false;
            }
        }
        this.updateBeecon = false;
    }

    private void pullFluidFromBelow(@NotNull World level) {
        TileEntity tileEntity = level.func_175625_s(this.field_174879_c.func_177977_b());
        if (tileEntity == null) {
            return;
        }
        if (this.tank.getSpace() == 0) {
            return;
        }
        tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.UP).ifPresent(handler -> {
            for (int i = 0; i < handler.getTanks(); ++i) {
                FluidStack stack = handler.getFluidInTank(i);
                if (!this.tank.isFluidValid(stack) || !this.tank.getFluid().isFluidEqual(stack) && !this.tank.getFluid().isEmpty()) continue;
                int pullAmount = (Integer)Config.BEECON_PULL_AMOUNT.get();
                if (pullAmount > this.tank.getSpace()) {
                    pullAmount = this.tank.getSpace();
                }
                FluidStack amountDrained = handler.drain(new FluidStack(stack.getFluid(), pullAmount), IFluidHandler.FluidAction.EXECUTE);
                this.tank.fill(amountDrained, IFluidHandler.FluidAction.EXECUTE);
            }
        });
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 255.0, (double)this.field_174879_c.func_177952_p());
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 256.0;
    }

    public HoneyFluidTank getTank() {
        return this.tank;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
            return this.tankOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.tankOptional.invalidate();
    }

    public Set<Effect> getEffects() {
        return this.effects;
    }

    public AxisAlignedBB getEffectBox(@NotNull World level) {
        AxisAlignedBB pos = new AxisAlignedBB(this.field_174879_c).func_186662_g((double)this.range);
        return new AxisAlignedBB(pos.field_72340_a, 0.0, pos.field_72339_c, pos.field_72336_d, (double)level.func_217301_I(), pos.field_72334_f);
    }

    private void addEffectsToBees(@NotNull World level, List<BeeEntity> bees) {
        if (!level.field_72995_K && this.doEffects()) {
            for (BeeEntity mob : bees) {
                for (Effect effect : this.effects) {
                    mob.func_195064_c(new EffectInstance(effect, 120, 0, false, false));
                }
            }
        }
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int range) {
        this.range = range;
    }

    public boolean doEffects() {
        if (this.tank.isEmpty()) {
            return false;
        }
        return !this.effects.isEmpty();
    }

    public void handleBeeconUpdate(BeeconChangeMessage.Option option, int value) {
        if (this.field_145850_b == null) {
            return;
        }
        switch (option) {
            case EFFECT_OFF: 
            case EFFECT_ON: {
                Effect effect = Effect.func_188412_a((int)value);
                if (effect == null || !ALLOWED_EFFECTS.contains(effect)) break;
                if (option.equals((Object)BeeconChangeMessage.Option.EFFECT_ON)) {
                    this.effects.add(effect);
                } else {
                    this.effects.remove(effect);
                }
                this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
                break;
            }
            case BEAM: {
                this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)EnderBeecon.BEAM, (Comparable)Boolean.valueOf(value == 1)), 3);
                break;
            }
            case SOUND: {
                this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)EnderBeecon.SOUND, (Comparable)Boolean.valueOf(value == 1)), 3);
                break;
            }
            case RANGE: {
                this.setRange(value);
                this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
                break;
            }
            default: {
                ResourcefulBees.LOGGER.error("UNKNOWN Beecon Configuration Option '{}' please report to github!", (Object)option);
            }
        }
    }

    public int getDrain() {
        double base = ((Integer)Config.BEECON_BASE_DRAIN.get()).intValue();
        for (Effect e : this.effects) {
            base += this.getEffectValue(e);
        }
        return (int)Math.ceil(base *= (double)this.range * (Double)Config.BEECON_RANGE_MULTIPLIER.get() * 0.1);
    }

    public boolean hasEffect(Effect effect) {
        return this.effects.contains(effect);
    }

    public ListNBT writeEffectsToNBT(ListNBT nbt) {
        for (Effect effect : this.effects) {
            ResourceLocation effectId = effect.getEffect().getRegistryName();
            if (effectId == null) continue;
            nbt.add((Object)StringNBT.func_229705_a_((String)effectId.toString()));
        }
        return nbt;
    }

    public Set<Effect> readEffectsFromNBT(ListNBT nbt) {
        LinkedHashSet<Effect> beeconEffects = new LinkedHashSet<Effect>();
        for (INBT inbt : nbt) {
            Effect effect;
            if (!(inbt instanceof StringNBT) || (effect = BeeInfoUtils.getEffect(inbt.func_150285_a_())) == null) continue;
            beeconEffects.add(effect);
        }
        return beeconEffects;
    }

    public double getEffectValue(Effect effect) {
        if (((Effect)ModEffects.CALMING.get()).equals(effect)) {
            return (Double)Config.BEECON_CALMING_VALUE.get();
        }
        if (Effects.field_76427_o.equals(effect)) {
            return (Double)Config.BEECON_WATER_BREATHING_VALUE.get();
        }
        if (Effects.field_76426_n.equals(effect)) {
            return (Double)Config.BEECON_FIRE_RESISTANCE_VALUE.get();
        }
        if (Effects.field_76428_l.equals(effect)) {
            return (Double)Config.BEECON_REGENERATION_VALUE.get();
        }
        ResourcefulBees.LOGGER.error("Effect {} does not have an effect value", (Object)effect.getRegistryName());
        return 1.0;
    }

    private PacketBuffer getBufToSend() {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.writeFluidStack(this.tank.getFluid());
        return buffer;
    }

    @Override
    public void sendGUINetworkPacket(IContainerListener player) {
        if (player instanceof ServerPlayerEntity && !(player instanceof FakePlayer)) {
            NetPacketHandler.sendToPlayer(new NewSyncGUIMessage(this.field_174879_c, this.getBufToSend()), (ServerPlayerEntity)player);
        }
    }

    @Override
    public void handleGUINetworkPacket(PacketBuffer buffer) {
        this.tank.setFluid(buffer.readFluidStack());
    }
}

