/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.tileentity;

import com.resourcefulbees.resourcefulbees.block.CentrifugeBlock;
import com.resourcefulbees.resourcefulbees.capabilities.CustomEnergyStorage;
import com.resourcefulbees.resourcefulbees.capabilities.MultiFluidTank;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.container.AutomationSensitiveItemStackHandler;
import com.resourcefulbees.resourcefulbees.container.CentrifugeContainer;
import com.resourcefulbees.resourcefulbees.network.NetPacketHandler;
import com.resourcefulbees.resourcefulbees.network.packets.SyncGUIMessage;
import com.resourcefulbees.resourcefulbees.recipe.CentrifugeRecipe;
import com.resourcefulbees.resourcefulbees.registry.ModContainers;
import com.resourcefulbees.resourcefulbees.utils.MathUtils;
import com.resourcefulbees.resourcefulbees.utils.NBTUtils;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CentrifugeTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public static final int BOTTLE_SLOT = 0;
    public static final int HONEYCOMB_SLOT = 1;
    public static final int OUTPUT1 = 2;
    public static final int OUTPUT2 = 3;
    public static final int HONEY_BOTTLE = 4;
    private static final int INPUTS = 1;
    private static final int TANK_CAPACITY = 5000;
    protected int[] honeycombSlots;
    protected int[] outputSlots;
    protected AutomationSensitiveItemStackHandler itemStackHandler;
    protected MultiFluidTank fluidTanks;
    protected CustomEnergyStorage energyStorage = this.createEnergy();
    protected LazyOptional<IItemHandler> lazyOptional = LazyOptional.of(() -> this.itemStackHandler);
    protected LazyOptional<IEnergyStorage> energyOptional = LazyOptional.of(() -> this.energyStorage);
    protected LazyOptional<MultiFluidTank> fluidOptional = LazyOptional.of(() -> this.fluidTanks);
    protected int[] time;
    protected List<CentrifugeRecipe> recipes;
    protected ItemStack failedMatch = ItemStack.field_190927_a;
    protected boolean dirty;
    protected boolean[] isProcessing;
    protected boolean[] processCompleted;
    protected boolean isPoweredByRedstone;
    protected boolean requiresRedstone;
    private final IIntArray times = new TimesArray(1);

    public CentrifugeTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
        this.initializeInputsAndOutputs();
        this.itemStackHandler = new TileStackHandler(this.getTotalSlots());
        this.fluidTanks = new MultiFluidTank(this.getMaxTankCapacity(), this.getTotalTanks());
        this.time = new int[this.getNumberOfInputs()];
        this.recipes = Arrays.asList(null, null, null, null, null, null, null, null, null);
        this.isProcessing = new boolean[this.getNumberOfInputs()];
        this.processCompleted = new boolean[this.getNumberOfInputs()];
    }

    protected void initializeInputsAndOutputs() {
        int i;
        this.honeycombSlots = new int[this.getNumberOfInputs()];
        for (i = 0; i < this.honeycombSlots.length; ++i) {
            this.honeycombSlots[i] = i + 1;
        }
        this.outputSlots = new int[this.getNumberOfInputs() * 6];
        for (i = 0; i < this.outputSlots.length; ++i) {
            this.outputSlots[i] = i + this.honeycombSlots.length + 1;
        }
    }

    public int[] getHoneycombSlots() {
        return this.honeycombSlots;
    }

    public int[] getOutputSlots() {
        return this.outputSlots;
    }

    public AutomationSensitiveItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    public void func_73660_a() {
        boolean worldCheck;
        boolean redstoneCheck = this.requiresRedstone && !this.isPoweredByRedstone;
        boolean bl = worldCheck = this.field_145850_b == null || this.field_145850_b.func_201670_d();
        if (worldCheck || redstoneCheck) {
            return;
        }
        for (int i = 0; i < this.honeycombSlots.length; ++i) {
            this.recipes.set(i, this.getRecipe(i));
            if (this.canStartCentrifugeProcess(i)) {
                this.isProcessing[i] = true;
                this.setPoweredBlockState(true);
            }
            if (this.isProcessing[i] && !this.processCompleted[i]) {
                this.processRecipe(i);
            }
            if (!this.processCompleted[i]) continue;
            this.completeProcess(i);
        }
        if (this.dirty) {
            this.dirty = false;
            this.func_70296_d();
        }
    }

    protected void resetProcess(int i) {
        this.processCompleted[i] = false;
        this.isProcessing[i] = false;
        this.time[i] = 0;
        this.recipes.set(i, null);
        this.setPoweredBlockState(false);
    }

    protected void completeProcess(int i) {
        if (this.recipes.get(i) == null) {
            this.resetProcess(i);
            return;
        }
        if (!this.inventoryHasSpace(this.recipes.get(i))) {
            return;
        }
        if (!this.tanksHasSpace(this.recipes.get(i))) {
            return;
        }
        this.consumeInput(i);
        ItemStack glassBottle = this.itemStackHandler.getStackInSlot(0);
        ArrayList<ItemStack> depositStacks = new ArrayList<ItemStack>();
        if (this.field_145850_b == null) {
            this.resetProcess(i);
            return;
        }
        CentrifugeRecipe recipe = this.recipes.get(i);
        for (int j = 0; j < recipe.itemOutputs.size(); ++j) {
            float chance = ((Float)recipe.itemOutputs.get(j).getRight()).floatValue();
            if (!(chance >= this.field_145850_b.field_73012_v.nextFloat())) continue;
            depositStacks.add(((ItemStack)recipe.itemOutputs.get(j).getLeft()).func_77946_l());
            if (j != 2 || recipe.noBottleInput) continue;
            glassBottle.func_190918_g(((ItemStack)this.recipes.get((int)i).itemOutputs.get(2).getLeft()).func_190916_E());
        }
        for (Pair<FluidStack, Float> fluidOutput : recipe.fluidOutput) {
            FluidStack fluid;
            int tank;
            float chance = ((Float)fluidOutput.getRight()).floatValue();
            if (!(chance >= this.field_145850_b.field_73012_v.nextFloat()) || (tank = this.getValidTank(fluid = ((FluidStack)fluidOutput.getLeft()).copy())) == -1) continue;
            this.fluidTanks.fill(tank, fluid, IFluidHandler.FluidAction.EXECUTE);
        }
        if (!depositStacks.isEmpty()) {
            this.depositItemStacks(depositStacks);
        }
        this.resetProcess(i);
    }

    private boolean tanksHasSpace(CentrifugeRecipe centrifugeRecipe) {
        if (centrifugeRecipe == null) {
            return false;
        }
        for (Pair<FluidStack, Float> f : centrifugeRecipe.fluidOutput) {
            if (((FluidStack)f.getLeft()).isEmpty() || this.getValidTank((FluidStack)f.getKey()) >= 0) continue;
            return false;
        }
        return true;
    }

    private int getValidTank(FluidStack fluid) {
        for (int i = 0; i < this.fluidTanks.getTanks(); ++i) {
            if (this.fluidTanks.getFluidInTank(i).getFluid() != fluid.getFluid() && !this.fluidTanks.getFluidInTank(i).isEmpty()) continue;
            if (this.fluidTanks.getFluidInTank(i).getAmount() + fluid.getAmount() <= this.fluidTanks.getTankCapacity(i)) {
                return i;
            }
            return -1;
        }
        return -1;
    }

    protected void processRecipe(int i) {
        if (this.canProcess(i)) {
            this.energyStorage.consumeEnergy((Integer)Config.RF_TICK_CENTRIFUGE.get());
            int n = i;
            this.time[n] = this.time[n] + 1;
            this.processCompleted[i] = this.time[i] >= this.getRecipeTime(i);
            this.dirty = true;
        } else {
            this.resetProcess(i);
        }
    }

    protected void consumeInput(int i) {
        ItemStack combInput = this.itemStackHandler.getStackInSlot(this.honeycombSlots[i]);
        ItemStack[] stacks = this.recipes.get((int)i).ingredient.func_193365_a();
        int inputAmount = stacks.length == 1 ? stacks[0].func_190916_E() : 1;
        combInput.func_190918_g(inputAmount);
    }

    protected boolean canStartCentrifugeProcess(int i) {
        if (!this.isProcessing[i] && !this.itemStackHandler.getStackInSlot(this.honeycombSlots[i]).func_190926_b() && this.canProcessRecipe(i)) {
            ItemStack combInput = this.itemStackHandler.getStackInSlot(this.honeycombSlots[i]);
            ItemStack[] stacks = this.recipes.get((int)i).ingredient.func_193365_a();
            int inputAmount = stacks.length == 1 ? stacks[0].func_190916_E() : 1;
            return combInput.func_190916_E() >= inputAmount;
        }
        return false;
    }

    protected boolean canProcessRecipe(int i) {
        return this.recipes.get(i) != null && !this.recipes.get((int)i).multiblock;
    }

    protected boolean canProcess(int i) {
        return !this.itemStackHandler.getStackInSlot(this.honeycombSlots[i]).func_190926_b() && this.canProcessFluid(i) && this.canProcessEnergy();
    }

    protected boolean canProcessFluid(int i) {
        return this.tanksHasSpace(this.recipes.get(i));
    }

    protected boolean canProcessEnergy() {
        return this.energyStorage.getEnergyStored() >= (Integer)Config.RF_TICK_CENTRIFUGE.get();
    }

    public CentrifugeRecipe getRecipe(int i) {
        ItemStack input = this.itemStackHandler.getStackInSlot(this.honeycombSlots[i]);
        Inventory recipeInv = new Inventory(new ItemStack[]{input, this.itemStackHandler.getStackInSlot(0)});
        if (input.func_190926_b() || input == this.failedMatch) {
            return null;
        }
        if (this.field_145850_b != null) {
            boolean matches;
            boolean bl = matches = this.recipes.get(i) == null;
            if (!matches) {
                boolean bl2 = matches = !this.recipes.get(i).func_77569_a((IInventory)recipeInv, this.field_145850_b);
            }
            if (matches) {
                CentrifugeRecipe rec = this.field_145850_b.func_199532_z().func_215371_a(CentrifugeRecipe.CENTRIFUGE_RECIPE_TYPE, (IInventory)recipeInv, this.field_145850_b).orElse(null);
                this.failedMatch = rec == null ? input : ItemStack.field_190927_a;
                this.recipes.set(i, rec);
            }
            return this.recipes.get(i);
        }
        return null;
    }

    public int getProcessTime(int i) {
        return this.time[i];
    }

    public int getTotalSlots() {
        return 1 + this.honeycombSlots.length + this.outputSlots.length;
    }

    public int getNumberOfInputs() {
        return 1;
    }

    public int getTotalTanks() {
        return 1 + this.honeycombSlots.length;
    }

    public int getMaxTankCapacity() {
        return 5000;
    }

    public int getRecipeTime(int i) {
        return this.getRecipe(i) != null ? Math.max(5, this.getRecipe((int)i).time) : (Integer)Config.GLOBAL_CENTRIFUGE_RECIPE_TIME.get();
    }

    protected void depositItemStacks(List<ItemStack> itemStacks) {
        itemStacks.forEach(itemStack -> {
            for (int slotIndex = this.outputSlots[0]; !itemStack.func_190926_b() && slotIndex < this.itemStackHandler.getSlots(); ++slotIndex) {
                ItemStack slotStack = this.itemStackHandler.getStackInSlot(slotIndex);
                int itemMaxStackSize = itemStack.func_77976_d();
                if (slotStack.func_190926_b()) {
                    this.itemStackHandler.setStackInSlot(slotIndex, itemStack.func_77979_a(itemMaxStackSize));
                    continue;
                }
                if (!Container.func_195929_a((ItemStack)itemStack, (ItemStack)slotStack) || slotStack.func_190916_E() == itemMaxStackSize) continue;
                int combinedCount = itemStack.func_190916_E() + slotStack.func_190916_E();
                if (combinedCount <= itemMaxStackSize) {
                    itemStack.func_190920_e(0);
                    slotStack.func_190920_e(combinedCount);
                } else {
                    itemStack.func_190918_g(itemMaxStackSize - slotStack.func_190916_E());
                    slotStack.func_190920_e(itemMaxStackSize);
                }
                this.itemStackHandler.setStackInSlot(slotIndex, slotStack);
            }
        });
    }

    protected boolean inventoryHasSpace(CentrifugeRecipe recipe) {
        int emptySlots = 0;
        for (int i = this.outputSlots[0]; i < this.itemStackHandler.getSlots(); ++i) {
            if (!this.itemStackHandler.getStackInSlot(i).func_190926_b()) continue;
            ++emptySlots;
        }
        boolean hasSpace = true;
        for (int i = 0; recipe != null && hasSpace && i < recipe.itemOutputs.size(); ++i) {
            ItemStack output = (ItemStack)recipe.itemOutputs.get(i).getLeft();
            if (output.func_190926_b() || i == 2 && this.itemStackHandler.getStackInSlot(0).func_190926_b()) continue;
            int count = output.func_190916_E();
            for (int j = this.outputSlots[0]; count > 0 && j < this.itemStackHandler.getSlots(); ++j) {
                ItemStack slotStack = this.itemStackHandler.getStackInSlot(j);
                if (slotStack.func_190926_b() && emptySlots != 0) {
                    count -= Math.min(count, output.func_77976_d());
                    --emptySlots;
                    continue;
                }
                if (!Container.func_195929_a((ItemStack)output, (ItemStack)slotStack) || slotStack.func_190916_E() == output.func_77976_d()) continue;
                count -= Math.min(count, output.func_77976_d() - slotStack.func_190916_E());
            }
            hasSpace = count <= 0;
        }
        return hasSpace;
    }

    public void drainFluidInTank(int tank) {
        this.fluidTanks.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE, tank);
    }

    public void updateRequiresRedstone() {
        this.requiresRedstone = !this.requiresRedstone;
    }

    public boolean getRequiresRedstone() {
        return this.requiresRedstone;
    }

    public void setRequiresRedstone(boolean requiresRedstone) {
        this.requiresRedstone = requiresRedstone;
    }

    public void setIsPoweredByRedstone(boolean isPoweredByRedstone) {
        this.isPoweredByRedstone = isPoweredByRedstone;
    }

    protected void setPoweredBlockState(boolean powered) {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)CentrifugeBlock.PROPERTY_ON, (Comparable)Boolean.valueOf(powered)));
        }
    }

    @NotNull
    public CompoundNBT func_189515_b(@NotNull CompoundNBT tag) {
        super.func_189515_b(tag);
        return this.saveToNBT(tag);
    }

    protected CompoundNBT saveToNBT(CompoundNBT tag) {
        tag.func_218657_a("inv", (INBT)this.itemStackHandler.serializeNBT());
        tag.func_74783_a("time", this.time);
        tag.func_218657_a("energy", (INBT)this.energyStorage.serializeNBT());
        tag.func_218657_a("Tanks", (INBT)this.fluidTanks.writeToNBT());
        tag.func_218657_a("isProcessing", (INBT)NBTUtils.writeBooleans(this.isProcessing));
        tag.func_218657_a("processCompleted", (INBT)NBTUtils.writeBooleans(this.processCompleted));
        tag.func_74757_a("requiresRedstone", this.requiresRedstone);
        tag.func_74757_a("isPoweredByRedstone", this.isPoweredByRedstone);
        return tag;
    }

    protected void loadFromNBT(CompoundNBT tag) {
        this.itemStackHandler.deserializeNBTWithoutCheckingSize(tag.func_74775_l("inv"));
        this.time = NBTUtils.getFallbackIntArray("time", tag, this.getNumberOfInputs());
        this.energyStorage.deserializeNBT(tag.func_74775_l("energy"));
        this.fluidTanks.readFromNBT(tag);
        this.isProcessing = NBTUtils.loadBooleans(this.honeycombSlots.length, tag.func_74775_l("isProcessing"));
        this.processCompleted = NBTUtils.loadBooleans(this.honeycombSlots.length, tag.func_74775_l("processCompleted"));
        this.requiresRedstone = tag.func_74767_n("requiresRedstone");
        this.isPoweredByRedstone = tag.func_74767_n("isPoweredByRedstone");
    }

    public void func_230337_a_(@NotNull BlockState state, @NotNull CompoundNBT tag) {
        this.loadFromNBT(tag);
        super.func_230337_a_(state, tag);
    }

    @NotNull
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        return nbtTagCompound;
    }

    public void handleUpdateTag(@NotNull BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.saveToNBT(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT nbt = pkt.func_148857_g();
        this.loadFromNBT(nbt);
    }

    public void dropInventory(World world, @NotNull BlockPos pos) {
        IntStream.range(0, this.itemStackHandler.getSlots()).mapToObj(arg_0 -> ((AutomationSensitiveItemStackHandler)this.itemStackHandler).getStackInSlot(arg_0)).filter(s -> !s.func_190926_b()).forEach(stack -> InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            return this.lazyOptional.cast();
        }
        if (cap.equals((Object)CapabilityEnergy.ENERGY)) {
            return this.energyOptional.cast();
        }
        if (cap.equals((Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
            return this.fluidOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void invalidateCaps() {
        this.lazyOptional.invalidate();
        this.energyOptional.invalidate();
        this.fluidOptional.invalidate();
    }

    public AutomationSensitiveItemStackHandler.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> {
            boolean isInputSlot = slot <= this.getNumberOfInputs();
            boolean isBottleSlot = slot == 0;
            return !automation || isInputSlot && !isBottleSlot && !stack.func_77973_b().equals(Items.field_151069_bo) || isBottleSlot && stack.func_77973_b().equals(Items.field_151069_bo);
        };
    }

    public AutomationSensitiveItemStackHandler.IRemover getRemover() {
        return (slot, automation) -> !automation || slot > this.getNumberOfInputs();
    }

    @Nullable
    public Container createMenu(int id, @NotNull PlayerInventory playerInventory, @NotNull PlayerEntity playerEntity) {
        assert (this.field_145850_b != null);
        return new CentrifugeContainer((ContainerType)ModContainers.CENTRIFUGE_CONTAINER.get(), id, this.field_145850_b, this.field_174879_c, playerInventory, this.times);
    }

    @NotNull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("gui.resourcefulbees.centrifuge");
    }

    protected CustomEnergyStorage createEnergy() {
        return new CustomEnergyStorage((Integer)Config.MAX_CENTRIFUGE_RF.get(), (Integer)Config.MAX_CENTRIFUGE_RECEIVE_RATE.get(), 0){

            @Override
            protected void onEnergyChanged() {
                CentrifugeTileEntity.this.func_70296_d();
            }
        };
    }

    public void sendGUINetworkPacket(IContainerListener player) {
        if (player instanceof ServerPlayerEntity && !(player instanceof FakePlayer)) {
            PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
            for (int i = 0; i < this.fluidTanks.getTanks(); ++i) {
                buffer.writeFluidStack(this.fluidTanks.getFluidInTank(i));
            }
            buffer.writeInt(this.energyStorage.getEnergyStored());
            NetPacketHandler.sendToPlayer(new SyncGUIMessage(this.field_174879_c, buffer), (ServerPlayerEntity)player);
        }
    }

    public void handleGUINetworkPacket(PacketBuffer buffer) {
        for (int i = 0; i < this.fluidTanks.getTanks(); ++i) {
            this.fluidTanks.setFluidInTank(i, buffer.readFluidStack());
        }
        this.energyStorage.setEnergy(buffer.readInt());
    }

    protected class TimesArray
    implements IIntArray {
        private final int count;

        public TimesArray(int count) {
            this.count = count;
        }

        public int func_221476_a(int index) {
            return MathUtils.inRangeExclusive(index, -1, this.func_221478_a()) ? CentrifugeTileEntity.this.time[index] : 0;
        }

        public void func_221477_a(int index, int value) {
            if (!MathUtils.inRangeExclusive(index, -1, this.func_221478_a())) {
                return;
            }
            CentrifugeTileEntity.this.time[index] = value;
        }

        public int func_221478_a() {
            return this.count;
        }
    }

    protected class TileStackHandler
    extends AutomationSensitiveItemStackHandler {
        protected TileStackHandler(int slots) {
            super(slots);
        }

        @Override
        public AutomationSensitiveItemStackHandler.IAcceptor getAcceptor() {
            return CentrifugeTileEntity.this.getAcceptor();
        }

        @Override
        public AutomationSensitiveItemStackHandler.IRemover getRemover() {
            return CentrifugeTileEntity.this.getRemover();
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            CentrifugeTileEntity.this.func_70296_d();
        }
    }
}

