/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.tileentity;

import com.resourcefulbees.resourcefulbees.api.honeydata.HoneyBottleData;
import com.resourcefulbees.resourcefulbees.block.ColoredHoneyBlock;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.container.AutomationSensitiveItemStackHandler;
import com.resourcefulbees.resourcefulbees.tileentity.AbstractHoneyTank;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractHoneyTankContainer
extends AbstractHoneyTank
implements ITickableTileEntity,
INamedContainerProvider {
    public static final ITag<Fluid> HONEY_FLUID_TAG = BeeInfoUtils.getFluidTag("resourcefulbees:resourceful_honey");
    public static final ITag<Item> HONEY_BOTTLE_TAG = BeeInfoUtils.getItemTag("resourcefulbees:resourceful_honey_bottle");
    public static final int BOTTLE_INPUT_EMPTY = 0;
    public static final int BOTTLE_OUTPUT_EMPTY = 1;
    public static final int HONEY_FILL_AMOUNT = 250;
    private AutomationSensitiveItemStackHandler tileStackHandler = new TileStackHandler(2, this.getAcceptor(), this.getRemover());
    private LazyOptional<IItemHandler> lazyOptional = LazyOptional.of(this::getTileStackHandler);
    private boolean dirty;
    private int processingEmpty;

    public float getProcessEmptyPercent() {
        if (!this.canProcessFluid()) {
            return 0.0f;
        }
        if (this.processingEmpty == (Integer)Config.HONEY_PROCEESS_TIME.get()) {
            return 1.0f;
        }
        return (float)this.processingEmpty / (float)((Integer)Config.HONEY_PROCEESS_TIME.get()).intValue();
    }

    public void setTileStackHandler(AutomationSensitiveItemStackHandler tileStackHandler) {
        this.tileStackHandler = tileStackHandler;
        this.lazyOptional = LazyOptional.of(this::getTileStackHandler);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty() {
        this.dirty = true;
    }

    public AbstractHoneyTankContainer(TileEntityType<?> tileEntityType, int level) {
        super(tileEntityType, level);
    }

    public AbstractHoneyTankContainer(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    public boolean canStartFluidProcess() {
        boolean hasRoom;
        boolean outputValid;
        ItemStack stack = this.getTileStackHandler().getStackInSlot(0);
        ItemStack output = this.getTileStackHandler().getStackInSlot(1);
        boolean stackValid = false;
        boolean isBucket = false;
        boolean isBlock = false;
        if (!stack.func_190926_b()) {
            BlockItem blockItem = null;
            if (stack.func_77973_b() instanceof BlockItem) {
                blockItem = (BlockItem)stack.func_77973_b();
            }
            if (blockItem != null && blockItem.func_179223_d() instanceof ColoredHoneyBlock) {
                stackValid = ((ColoredHoneyBlock)blockItem.func_179223_d()).getData().doGenerateHoneyFluid();
                isBlock = true;
            } else if (stack.func_77973_b() instanceof BucketItem) {
                BucketItem bucket = (BucketItem)stack.func_77973_b();
                stackValid = bucket.getFluid().func_207185_a(HONEY_FLUID_TAG);
                isBucket = true;
            } else {
                stackValid = stack.func_77973_b().func_206844_a(HONEY_BOTTLE_TAG);
            }
        }
        if (!output.func_190926_b() && !isBlock) {
            outputValid = isBucket ? output.func_77973_b() == Items.field_151133_ar : output.func_77973_b() == Items.field_151069_bo;
            hasRoom = output.func_190916_E() < output.func_77976_d();
        } else {
            outputValid = true;
            hasRoom = true;
        }
        return stackValid && outputValid && hasRoom;
    }

    public void processFluid() {
        if (this.canProcessFluid()) {
            ItemStack stack = this.getTileStackHandler().getStackInSlot(0);
            ItemStack output = this.getTileStackHandler().getStackInSlot(1);
            BlockItem blockItem = null;
            if (stack.func_77973_b() instanceof BlockItem) {
                blockItem = (BlockItem)stack.func_77973_b();
            }
            if (blockItem != null && blockItem.func_179223_d() instanceof ColoredHoneyBlock) {
                stack.func_190918_g(1);
                HoneyBottleData data = ((ColoredHoneyBlock)blockItem.func_179223_d()).getData();
                this.getFluidTank().fill(new FluidStack((Fluid)data.getHoneyStillFluidRegistryObject().get(), 1000), IFluidHandler.FluidAction.EXECUTE);
            } else if (stack.func_77973_b() instanceof BucketItem) {
                BucketItem bucket = (BucketItem)stack.func_77973_b();
                this.getFluidTank().fill(new FluidStack(bucket.getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
                stack.func_190918_g(1);
                if (output.func_190926_b()) {
                    this.getTileStackHandler().setStackInSlot(1, new ItemStack((IItemProvider)Items.field_151133_ar));
                } else {
                    output.func_190917_f(1);
                }
            } else {
                FluidStack fluidStack = new FluidStack(BeeInfoUtils.getFluidFromBottle(stack), 250);
                if (!fluidStack.isEmpty()) {
                    this.getFluidTank().fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                }
                stack.func_190918_g(1);
                if (output.func_190926_b()) {
                    this.getTileStackHandler().setStackInSlot(1, new ItemStack((IItemProvider)Items.field_151069_bo));
                } else {
                    output.func_190917_f(1);
                }
            }
            this.dirty = true;
        }
    }

    public boolean canProcessFluid() {
        Fluid fluid;
        boolean spaceLeft;
        ItemStack stack = this.getTileStackHandler().getStackInSlot(0);
        if (!this.canStartFluidProcess()) {
            return false;
        }
        BlockItem blockItem = null;
        if (stack.func_77973_b() instanceof BlockItem) {
            blockItem = (BlockItem)stack.func_77973_b();
        }
        if (blockItem != null && blockItem.func_179223_d() instanceof ColoredHoneyBlock) {
            HoneyBottleData item = ((ColoredHoneyBlock)blockItem.func_179223_d()).getData();
            spaceLeft = this.getFluidTank().getFluidAmount() + 1000 <= this.getFluidTank().getCapacity();
            fluid = (Fluid)item.getHoneyStillFluidRegistryObject().get();
        } else if (stack.func_77973_b() instanceof BucketItem) {
            BucketItem item = (BucketItem)stack.func_77973_b();
            spaceLeft = this.getFluidTank().getFluidAmount() + 1000 <= this.getFluidTank().getCapacity();
            fluid = item.getFluid();
        } else {
            spaceLeft = this.getFluidTank().getFluidAmount() + 250 <= this.getFluidTank().getCapacity();
            fluid = BeeInfoUtils.getFluidFromBottle(stack);
        }
        return spaceLeft && (this.getFluidTank().getFluid().getFluid() == fluid || this.getFluidTank().isEmpty());
    }

    @NotNull
    public AutomationSensitiveItemStackHandler getTileStackHandler() {
        return this.tileStackHandler;
    }

    public static boolean isItemValid(ItemStack stack) {
        BlockItem blockItem = null;
        if (stack.func_77973_b() instanceof BlockItem) {
            blockItem = (BlockItem)stack.func_77973_b();
        }
        if (blockItem != null && blockItem.func_179223_d() instanceof ColoredHoneyBlock) {
            ColoredHoneyBlock block = (ColoredHoneyBlock)blockItem.func_179223_d();
            return block.getData().doGenerateHoneyFluid();
        }
        if (stack.func_77973_b() instanceof BucketItem) {
            BucketItem bucket = (BucketItem)stack.func_77973_b();
            return bucket.getFluid().func_207185_a(HONEY_FLUID_TAG);
        }
        return stack.func_77973_b().func_206844_a(HONEY_BOTTLE_TAG);
    }

    public AutomationSensitiveItemStackHandler.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation || slot == 0;
    }

    public AutomationSensitiveItemStackHandler.IRemover getRemover() {
        return (slot, automation) -> !automation || slot == 1;
    }

    public void func_73660_a() {
        if (this.canProcessFluid()) {
            if (this.processingEmpty >= (Integer)Config.HONEY_PROCEESS_TIME.get()) {
                this.processFluid();
                this.processingEmpty = 0;
            }
            ++this.processingEmpty;
        }
        if (this.dirty) {
            this.dirty = false;
            this.func_70296_d();
        }
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    protected class TileStackHandler
    extends AutomationSensitiveItemStackHandler {
        protected TileStackHandler(int slots, AutomationSensitiveItemStackHandler.IAcceptor acceptor, AutomationSensitiveItemStackHandler.IRemover remover) {
            super(slots, acceptor, remover);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            AbstractHoneyTankContainer.this.func_70296_d();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return AbstractHoneyTankContainer.isItemValid(stack);
        }
    }
}

