/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.recipe;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Comparator;
import java.util.stream.Stream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.tags.ITag;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyLoadedTagIngredient
extends Ingredient {
    private final ITag<Item> tag;
    private ItemStack[] stacks;
    private IntList stackingIds;

    public LazyLoadedTagIngredient(ITag<Item> tag) {
        super(Stream.empty());
        this.tag = tag;
    }

    private void updateStacks() {
        if (this.stacks != null) {
            return;
        }
        this.stacks = (ItemStack[])this.tag.func_230236_b_().stream().map(ItemStack::new).toArray(ItemStack[]::new);
    }

    @NotNull
    public ItemStack[] func_193365_a() {
        this.updateStacks();
        return this.stacks;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        this.updateStacks();
        if (this.stacks.length == 0) {
            return stack.func_190926_b();
        }
        return this.tag.func_230235_a_((Object)stack.func_77973_b());
    }

    @NotNull
    public IntList func_194139_b() {
        if (this.stackingIds == null) {
            this.updateStacks();
            this.stackingIds = new IntArrayList(this.func_193365_a().length);
            for (ItemStack itemstack : this.func_193365_a()) {
                this.stackingIds.add(RecipeItemHelper.func_194113_b((ItemStack)itemstack));
            }
            this.stackingIds.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
        }
        return this.stackingIds;
    }

    public boolean func_203189_d() {
        return this.func_193365_a().length == 0;
    }

    @NotNull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return VanillaIngredientSerializer.INSTANCE;
    }
}

