/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.recipe;

import com.google.gson.JsonObject;
import com.resourcefulbees.resourcefulbees.block.multiblocks.apiary.ApiaryBlock;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import com.resourcefulbees.resourcefulbees.registry.ModRecipeSerializers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class HiveUpgradeRecipe
extends ShapedRecipe {
    public HiveUpgradeRecipe(ResourceLocation id, NonNullList<Ingredient> ingredients, ItemStack result) {
        super(id, "", 3, 3, ingredients, result);
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingInventory inventory) {
        List<ItemStack> stacks = this.getHives(inventory);
        NonNullList remainingItems = super.func_179532_b((IInventory)inventory);
        ItemStack beeBox = new ItemStack((IItemProvider)ModItems.CRAFTING_BEE_BOX.get());
        CompoundNBT tag = new CompoundNBT();
        ListNBT allBees = new ListNBT();
        for (ItemStack stack : stacks) {
            if (!stack.func_77942_o() || stack.func_77978_p() == null || stack.func_77978_p().isEmpty() || !stack.func_77978_p().func_74764_b("BlockEntityTag")) {
                return remainingItems;
            }
            ListNBT list = stack.func_77978_p().func_74775_l("BlockEntityTag").func_150295_c("Bees", 10);
            if (list.isEmpty()) continue;
            allBees.addAll((Collection)list);
        }
        if (!allBees.isEmpty()) {
            tag.func_218657_a("Bees", (INBT)allBees);
            beeBox.func_77982_d(tag);
            for (int i = 0; i < remainingItems.size(); ++i) {
                if (((ItemStack)remainingItems.get(i)).func_77973_b() != Items.field_190931_a) continue;
                remainingItems.set(i, (Object)beeBox);
                break;
            }
        }
        return remainingItems;
    }

    public List<ItemStack> getHives(CraftingInventory inventory) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            Block block = Block.func_149634_a((Item)item.func_77973_b());
            if (block == Blocks.field_150350_a || !(block instanceof ApiaryBlock) && !(block instanceof BeehiveBlock)) continue;
            stacks.add(item);
        }
        return stacks;
    }

    @NotNull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeSerializers.APIARY_UPGRADE_RECIPE.get();
    }

    public static class Serializer
    extends ShapedRecipe.Serializer {
        @NotNull
        public ShapedRecipe func_199425_a_(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            ShapedRecipe recipe = super.func_199425_a_(recipeId, json);
            return new HiveUpgradeRecipe(recipeId, (NonNullList<Ingredient>)recipe.func_192400_c(), recipe.func_77571_b());
        }

        public ShapedRecipe func_199426_a_(@NotNull ResourceLocation recipeId, @NotNull PacketBuffer buffer) {
            ShapedRecipe recipe = super.func_199426_a_(recipeId, buffer);
            assert (recipe != null) : "why is recipe null?";
            return new HiveUpgradeRecipe(recipeId, (NonNullList<Ingredient>)recipe.func_192400_c(), recipe.func_77571_b());
        }
    }
}

