/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.StackList;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HiveIngredient
extends Ingredient {
    public static final List<ItemStack> NESTS = Arrays.asList(((Item)ModItems.OAK_BEE_NEST_ITEM.get()).func_190903_i(), ((Item)ModItems.ACACIA_BEE_NEST_ITEM.get()).func_190903_i(), ((Item)ModItems.GRASS_BEE_NEST_ITEM.get()).func_190903_i(), ((Item)ModItems.JUNGLE_BEE_NEST_ITEM.get()).func_190903_i(), ((Item)ModItems.NETHER_BEE_NEST_ITEM.get()).func_190903_i(), ((Item)ModItems.PRISMARINE_BEE_NEST_ITEM.get()).func_190903_i(), ((Item)ModItems.PURPUR_BEE_NEST_ITEM.get()).func_190903_i(), ((Item)ModItems.BIRCH_BEE_NEST_ITEM.get()).func_190903_i(), ((Item)ModItems.WITHER_BEE_NEST_ITEM.get()).func_190903_i(), ((Item)ModItems.BROWN_MUSHROOM_NEST_ITEM.get()).func_190903_i(), ((Item)ModItems.CRIMSON_BEE_NEST_ITEM.get()).func_190903_i(), ((Item)ModItems.CRIMSON_NYLIUM_BEE_NEST_ITEM.get()).func_190903_i(), ((Item)ModItems.DARK_OAK_NEST_ITEM.get()).func_190903_i(), ((Item)ModItems.RED_MUSHROOM_NEST_ITEM.get()).func_190903_i(), ((Item)ModItems.SPRUCE_BEE_NEST_ITEM.get()).func_190903_i(), ((Item)ModItems.WARPED_BEE_NEST_ITEM.get()).func_190903_i(), ((Item)ModItems.WARPED_NYLIUM_BEE_NEST_ITEM.get()).func_190903_i(), ((Item)ModItems.T1_BEEHIVE_ITEM.get()).func_190903_i(), ((Item)ModItems.T2_BEEHIVE_ITEM.get()).func_190903_i(), ((Item)ModItems.T3_BEEHIVE_ITEM.get()).func_190903_i(), ((Item)ModItems.T4_BEEHIVE_ITEM.get()).func_190903_i());
    private static final Map<Item, Integer> ITEM_TIER = (Map)Util.func_199748_a(() -> {
        HashMap<IForgeRegistryEntry, Integer> map = new HashMap<IForgeRegistryEntry, Integer>();
        map.put(ModItems.T1_BEEHIVE_ITEM.get(), 1);
        map.put(ModItems.T2_BEEHIVE_ITEM.get(), 2);
        map.put(ModItems.T3_BEEHIVE_ITEM.get(), 3);
        map.put(ModItems.T4_BEEHIVE_ITEM.get(), 4);
        return map;
    });
    public int tier;

    @NotNull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    protected HiveIngredient(int tier) {
        super(Stream.of(new StackList(HiveIngredient.getNests(tier))));
        this.tier = tier;
    }

    public static Collection<ItemStack> getNests(int tier) {
        ArrayList<ItemStack> nests = new ArrayList<ItemStack>(ITEM_TIER.entrySet().stream().filter(i -> (Integer)i.getValue() == tier).map(i -> new ItemStack((IItemProvider)i.getKey())).collect(Collectors.toList()));
        NESTS.stream().filter(stack -> {
            if (ITEM_TIER.containsKey(stack.func_77973_b())) {
                return ITEM_TIER.get(stack.func_77973_b()) <= tier;
            }
            return true;
        }).map(stack -> {
            if (tier == 0) {
                return stack;
            }
            stack = stack.func_77946_l();
            stack.func_77982_d(new CompoundNBT());
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("Tier", tier);
            stack.func_77978_p().func_218657_a("BlockEntityTag", (INBT)tag);
            return stack;
        }).forEach(nests::add);
        return nests;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        for (ItemStack nest : NESTS) {
            if (!nest.func_77973_b().equals(stack.func_77973_b())) continue;
            return this.tier == HiveIngredient.getTier(stack);
        }
        return false;
    }

    private static int getTier(ItemStack stack) {
        if (stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("BlockEntityTag")) {
            return ITEM_TIER.get(stack.func_77973_b()) == null ? -1 : ITEM_TIER.get(stack.func_77973_b());
        }
        CompoundNBT tag = stack.func_77978_p().func_74775_l("BlockEntityTag");
        return tag.func_74764_b("Tier") ? tag.func_74762_e("Tier") : -1;
    }

    public static class Serializer
    implements IIngredientSerializer<HiveIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        @NotNull
        public HiveIngredient parse(@NotNull PacketBuffer buffer) {
            return new HiveIngredient(buffer.readInt());
        }

        @NotNull
        public HiveIngredient parse(@NotNull JsonObject json) {
            if (json.has("tier")) {
                return new HiveIngredient(json.get("tier").getAsInt());
            }
            throw new JsonSyntaxException("Requires tier element for 'resourcefulbees:hive' ingredient!");
        }

        public void write(@NotNull PacketBuffer buffer, @NotNull HiveIngredient ingredient) {
            buffer.writeInt(ingredient.tier);
        }
    }
}

