/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.network.packets;

import com.resourcefulbees.resourcefulbees.tileentity.ISyncableGUI;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class NewSyncGUIMessage {
    private final BlockPos pos;
    private final PacketBuffer buffer;
    private final boolean initPacket;

    public NewSyncGUIMessage(BlockPos pos, PacketBuffer buffer) {
        this.pos = pos;
        this.buffer = buffer;
        this.initPacket = false;
    }

    public NewSyncGUIMessage(BlockPos pos, PacketBuffer buffer, boolean initPacket) {
        this.pos = pos;
        this.buffer = buffer;
        this.initPacket = initPacket;
    }

    public static void encode(NewSyncGUIMessage message, PacketBuffer buffer) {
        buffer.func_179255_a(message.pos);
        buffer.writeBoolean(message.initPacket);
        buffer.writeBytes((ByteBuf)message.buffer);
    }

    public static NewSyncGUIMessage decode(PacketBuffer buffer) {
        return new NewSyncGUIMessage(buffer.func_179259_c(), buffer, buffer.readBoolean());
    }

    public static void handle(NewSyncGUIMessage message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            TileEntity tileEntity;
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null && player.field_70170_p.func_195588_v(message.pos) && (tileEntity = player.field_70170_p.func_175625_s(message.pos)) instanceof ISyncableGUI) {
                if (message.initPacket) {
                    ((ISyncableGUI)tileEntity).handleInitGUIPacket(message.buffer);
                } else {
                    ((ISyncableGUI)tileEntity).handleGUINetworkPacket(message.buffer);
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

