/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.network.packets;

import com.resourcefulbees.resourcefulbees.tileentity.EnderBeeconTileEntity;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class BeeconChangeMessage {
    private final Option option;
    private final int value;
    private final BlockPos pos;

    public BeeconChangeMessage(Option option, boolean value, BlockPos pos) {
        this(option, value ? 1 : 0, pos);
    }

    public BeeconChangeMessage(Option option, int value, BlockPos pos) {
        this.option = option;
        this.value = value;
        this.pos = pos;
    }

    public static void encode(BeeconChangeMessage message, PacketBuffer buffer) {
        buffer.func_179249_a((Enum)message.option);
        buffer.writeInt(message.value);
        buffer.func_179255_a(message.pos);
    }

    public static BeeconChangeMessage decode(PacketBuffer buffer) {
        return new BeeconChangeMessage((Option)buffer.func_179257_a(Option.class), buffer.readInt(), buffer.func_179259_c());
    }

    public static void handle(BeeconChangeMessage message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            TileEntity tileEntity;
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            if (player != null && player.field_70170_p.func_195588_v(message.pos) && (tileEntity = player.field_70170_p.func_175625_s(message.pos)) instanceof EnderBeeconTileEntity) {
                EnderBeeconTileEntity beecon = (EnderBeeconTileEntity)tileEntity;
                beecon.handleBeeconUpdate(message.option, message.value);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static enum Option {
        EFFECT_ON,
        EFFECT_OFF,
        BEAM,
        SOUND,
        RANGE;

    }
}

