/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.item;

import com.resourcefulbees.resourcefulbees.api.IBeepediaData;
import com.resourcefulbees.resourcefulbees.capabilities.BeepediaData;
import com.resourcefulbees.resourcefulbees.entity.passive.CustomBeeEntity;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.utils.BeepediaUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Beepedia
extends Item {
    public static final String CREATIVE_TAG = "Creative";

    public Beepedia(Item.Properties properties) {
        super(properties);
    }

    public void checkAndAddBees(ItemStack stack, CustomBeeEntity entity, IBeepediaData data) {
        CompoundNBT nbt;
        CompoundNBT compoundNBT = nbt = stack.func_77942_o() && stack.func_77978_p() != null ? stack.func_77978_p() : new CompoundNBT();
        if (nbt.func_74767_n(CREATIVE_TAG)) {
            return;
        }
        if (nbt.func_74764_b("Bees")) {
            ListNBT listNBT = nbt.func_150295_c("Bees", 8).func_74737_b();
            listNBT.forEach(i -> data.getBeeList().add(i.func_150285_a_()));
            nbt.func_82580_o("Bees");
        }
        if (entity != null) {
            data.getBeeList().add(entity.getBeeType());
            data.getBeeList().removeIf(b -> BeeRegistry.getRegistry().getBeeData((String)b) == null);
            nbt.func_74757_a("Complete", data.getBeeList().size() == BeeRegistry.getRegistry().getBees().size());
        }
        stack.func_77982_d(nbt);
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @NotNull Hand hand) {
        IBeepediaData data = (IBeepediaData)player.getCapability(BeepediaData.Provider.BEEPEDIA_DATA).orElseGet(BeepediaData::new);
        ItemStack itemstack = player.func_184586_b(hand);
        this.checkAndAddBees(itemstack, null, data);
        if (world.field_72995_K) {
            BeepediaUtils.loadBeepedia(itemstack, null, data);
        }
        return ActionResult.func_233538_a_((Object)itemstack, (boolean)world.func_201670_d());
    }

    @NotNull
    public ActionResultType func_111207_a(@NotNull ItemStack stack, PlayerEntity player, @NotNull LivingEntity entity, @NotNull Hand hand) {
        IBeepediaData data = (IBeepediaData)player.getCapability(BeepediaData.Provider.BEEPEDIA_DATA).orElseGet(BeepediaData::new);
        if (entity instanceof CustomBeeEntity) {
            this.checkAndAddBees(stack, (CustomBeeEntity)entity, data);
            if (player.field_70170_p.field_72995_K) {
                BeepediaUtils.loadBeepedia(stack, (Entity)entity, data);
            }
            player.func_184611_a(hand, stack);
            return ActionResultType.SUCCESS;
        }
        return super.func_111207_a(stack, player, entity, hand);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p() != null && !stack.func_77978_p().isEmpty() && stack.func_77978_p().func_74767_n(CREATIVE_TAG)) {
            return new TranslationTextComponent("item.resourcefulbees.creative_beepedia").func_240699_a_(TextFormatting.LIGHT_PURPLE);
        }
        return super.func_200295_i(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add((ITextComponent)new TranslationTextComponent("item.resourcefulbees.information.beepedia").func_240699_a_(TextFormatting.GREEN));
        boolean creative = stack.func_77942_o() && stack.func_77978_p() != null && !stack.func_77978_p().isEmpty() && stack.func_77978_p().func_74767_n(CREATIVE_TAG);
        int total = BeeRegistry.getRegistry().getBees().size();
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        int count = ((IBeepediaData)Minecraft.func_71410_x().field_71439_g.getCapability(BeepediaData.Provider.BEEPEDIA_DATA).orElseGet(BeepediaData::new)).getBeeList().size();
        tooltip.add((ITextComponent)new TranslationTextComponent("gui.resourcefulbees.beepedia.home.progress").func_240699_a_(TextFormatting.GRAY).func_240702_b_(String.format("%d / %d", creative ? total : count, total)).func_240699_a_(TextFormatting.GOLD));
    }

    public static boolean isCreative(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_74767_n(CREATIVE_TAG);
    }
}

