/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.item;

import com.resourcefulbees.resourcefulbees.api.beedata.ColorData;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.utils.color.Color;
import com.resourcefulbees.resourcefulbees.utils.color.RainbowColor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeeSpawnEggItem
extends SpawnEggItem {
    protected static final List<BeeSpawnEggItem> eggsToAdd = new ArrayList<BeeSpawnEggItem>();
    private final Lazy<? extends EntityType<?>> entityType;
    private final ColorData colorData;
    private final CustomBeeData beeData;

    public BeeSpawnEggItem(RegistryObject<? extends EntityType<?>> entityTypeSupplier, int firstColor, int secondColor, CustomBeeData beeData, Item.Properties properties) {
        super(null, firstColor, secondColor, properties);
        this.beeData = beeData;
        this.entityType = Lazy.of(entityTypeSupplier);
        this.colorData = beeData.getColorData();
        eggsToAdd.add(this);
    }

    @NotNull
    public EntityType<?> func_208076_b(@Nullable CompoundNBT nbt) {
        return (EntityType)this.entityType.get();
    }

    public CustomBeeData getBeeData() {
        return this.beeData;
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        ColorData colorData = ((BeeSpawnEggItem)stack.func_77973_b()).colorData;
        int primaryColor = Color.parseInt("#edc343");
        int secondaryColor = 0x303030;
        if (colorData.hasPrimaryColor()) {
            primaryColor = colorData.getPrimaryColorInt();
        } else if (colorData.isRainbowBee()) {
            primaryColor = RainbowColor.getRGB();
        } else if (colorData.hasHoneycombColor()) {
            primaryColor = colorData.getHoneycombColorInt();
        }
        if (colorData.hasSecondaryColor()) {
            secondaryColor = colorData.getSecondaryColorInt();
        }
        return tintIndex == 0 ? primaryColor : secondaryColor;
    }

    public static void initSpawnEggs() {
        for (SpawnEggItem spawnEggItem : eggsToAdd) {
            field_195987_b.put(spawnEggItem.func_208076_b(null), spawnEggItem);
        }
        eggsToAdd.clear();
    }

    @NotNull
    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack itemstack = context.func_195996_i();
        PlayerEntity player = context.func_195999_j();
        if (player != null) {
            World world = context.func_195991_k();
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            BlockPos blockpos = context.func_195995_a();
            Direction direction = context.func_196000_l();
            BlockState blockstate = world.func_180495_p(blockpos);
            BlockPos blockpos1 = blockstate.func_196952_d((IBlockReader)world, blockpos).func_197766_b() ? blockpos : blockpos.func_177972_a(direction);
            EntityType<?> entitytype = this.func_208076_b(itemstack.func_77978_p());
            if (entitytype.func_220331_a((ServerWorld)world, itemstack, context.func_195999_j(), blockpos1, SpawnReason.SPAWN_EGG, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP) != null) {
                itemstack.func_190918_g(1);
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.SUCCESS;
    }

    @NotNull
    public Optional<MobEntity> func_234809_a_(@NotNull PlayerEntity playerEntity, @NotNull MobEntity mobEntity, @NotNull EntityType<? extends MobEntity> entityType, @NotNull ServerWorld world, @NotNull Vector3d vector3d, @NotNull ItemStack stack) {
        return Optional.empty();
    }
}

