/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.item;

import com.resourcefulbees.resourcefulbees.api.beedata.ColorData;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.api.beedata.TraitData;
import com.resourcefulbees.resourcefulbees.entity.passive.CustomBeeEntity;
import com.resourcefulbees.resourcefulbees.entity.passive.ResourcefulBee;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import com.resourcefulbees.resourcefulbees.utils.color.Color;
import com.resourcefulbees.resourcefulbees.utils.color.RainbowColor;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeeJar
extends Item {
    public BeeJar(Item.Properties properties) {
        super(properties);
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        CompoundNBT tag = stack.func_77978_p();
        if (tintIndex == 1 && tag != null) {
            if (tag.func_74764_b("Color") && !tag.func_74779_i("Color").equals("-1")) {
                return tag.func_74779_i("Color").equals("rainbow") ? RainbowColor.getRGB() : Color.parseInt(tag.func_74779_i("Color"));
            }
            if (!tag.func_74764_b("Color") && tag.func_74764_b("Entity") && BeeJar.getWorld() != null) {
                Entity entity;
                String id = tag.func_74779_i("Entity");
                EntityType<?> entityType = BeeInfoUtils.getEntityType(id);
                if (entityType != null && (entity = entityType.func_200721_a(BeeJar.getWorld())) instanceof CustomBeeEntity) {
                    ColorData renderData = ((CustomBeeEntity)entity).getBeeData().getColorData();
                    String beeColor = "#edc343";
                    if (renderData.isRainbowBee()) {
                        beeColor = "rainbow";
                    } else if (renderData.hasPrimaryColor()) {
                        beeColor = renderData.getPrimaryColor();
                    } else if (renderData.hasHoneycombColor()) {
                        beeColor = renderData.getHoneycombColor();
                    }
                    tag.func_74778_a("Color", beeColor);
                    return tag.func_74779_i("Color").equals("rainbow") ? RainbowColor.getRGB() : Color.parseInt(tag.func_74779_i("Color"));
                }
                tag.func_74778_a("Color", "-1");
                stack.func_77982_d(tag);
            }
            return 15582019;
        }
        return -1;
    }

    public static boolean isFilled(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("Entity");
    }

    @NotNull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player != null) {
            World playerWorld = context.func_195999_j().func_130014_f_();
            ItemStack stack = context.func_195996_i();
            if (playerWorld.func_201670_d() || !BeeJar.isFilled(stack)) {
                return ActionResultType.FAIL;
            }
            World worldIn = context.func_195991_k();
            BlockPos pos = context.func_195995_a();
            Entity entity = BeeJar.getEntityFromStack(stack, worldIn, true);
            if (entity != null) {
                assert (stack.func_77978_p() != null);
                CompoundNBT display = stack.func_77978_p().func_74775_l("display");
                if (!display.func_74779_i("Name").contains("item.resourcefulbees.bee_jar_filled")) {
                    entity.func_200203_b((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)display.func_74779_i("Name")));
                }
                if (entity instanceof BeeEntity) {
                    BeeEntity beeEntity = (BeeEntity)entity;
                    BeeJar.resetBee(beeEntity);
                    BeeJar.setBeeAngry(beeEntity, player);
                }
                BlockPos blockPos = pos.func_177972_a(context.func_196000_l());
                entity.func_70080_a((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5, 0.0f, 0.0f);
                worldIn.func_217376_c(entity);
            }
            if (player.func_184812_l_()) {
                return ActionResultType.SUCCESS;
            }
            if (stack.func_190916_E() > 1) {
                if (!player.func_191521_c(new ItemStack((IItemProvider)ModItems.BEE_JAR.get()))) {
                    player.func_71019_a(new ItemStack((IItemProvider)ModItems.BEE_JAR.get()), false);
                }
                stack.func_190918_g(1);
            } else {
                stack.func_77982_d(null);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public static void setBeeAngry(BeeEntity beeEntity, PlayerEntity player) {
        if (beeEntity.func_233678_J__()) {
            ResourcefulBee customBee;
            TraitData traitData;
            beeEntity.func_70624_b((LivingEntity)player);
            if (beeEntity instanceof ResourcefulBee && (traitData = (customBee = (ResourcefulBee)beeEntity).getBeeData().getTraitData()).getDamageTypes().stream().anyMatch(damageType -> ((String)damageType.getLeft()).equals("explosive"))) {
                customBee.setExplosiveCooldown(60);
            }
        }
    }

    public static void resetBee(BeeEntity beeEntity) {
        beeEntity.field_226368_bH_ = null;
        beeEntity.field_226369_bI_ = null;
    }

    @Nullable
    public static Entity getEntityFromStack(ItemStack stack, World world, boolean withInfo) {
        EntityType type;
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && (type = (EntityType)EntityType.func_220327_a((String)tag.func_74779_i("Entity")).orElse(null)) != null) {
            Entity entity = type.func_200721_a(world);
            if (entity != null && withInfo) {
                entity.func_70020_e(tag);
            }
            return entity;
        }
        return null;
    }

    @NotNull
    public ActionResultType func_111207_a(@NotNull ItemStack stack, @NotNull PlayerEntity player, LivingEntity targetIn, @NotNull Hand hand) {
        if (targetIn.func_130014_f_().func_201670_d() || !(targetIn instanceof BeeEntity) || !targetIn.func_70089_S() || ((BeeEntity)targetIn).func_233678_J__() || BeeJar.isFilled(stack)) {
            return ActionResultType.FAIL;
        }
        BeeEntity target = (BeeEntity)targetIn;
        if (stack.func_190916_E() > 1) {
            ItemStack newJar = new ItemStack((IItemProvider)ModItems.BEE_JAR.get());
            newJar.func_77982_d(BeeInfoUtils.createJarBeeTag(target, "Entity"));
            stack.func_190918_g(1);
            BeeJar.renameJar(newJar, target);
            if (!player.func_191521_c(newJar)) {
                player.func_71019_a(newJar, false);
            }
        } else {
            stack.func_77982_d(BeeInfoUtils.createJarBeeTag(target, "Entity"));
            BeeJar.renameJar(stack, target);
        }
        player.func_184611_a(hand, stack);
        player.func_184609_a(hand);
        target.remove(true);
        return ActionResultType.PASS;
    }

    public static void renameJar(ItemStack stack, Entity target, String name) {
        if (stack.func_77978_p() == null || stack.func_77978_p().func_74764_b("display")) {
            return;
        }
        CompoundNBT nbt = stack.func_196082_o();
        ITextComponent beeName = target.func_200200_C_();
        TranslationTextComponent bottleName = new TranslationTextComponent(name);
        bottleName.func_240702_b_(" - ").func_230529_a_(beeName);
        bottleName.func_230530_a_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(false)));
        CompoundNBT displayNBT = new CompoundNBT();
        displayNBT.func_74778_a("Name", ITextComponent.Serializer.func_150696_a((ITextComponent)bottleName));
        nbt.func_218657_a("display", (INBT)displayNBT);
    }

    public static void renameJar(ItemStack stack, BeeEntity target) {
        BeeJar.renameJar(stack, (Entity)target, stack.func_77973_b().func_77667_c(stack));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void fillJar(ItemStack stack, CustomBeeData beeData) {
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(beeData.getEntityTypeRegistryID());
        World world = BeeJar.getWorld();
        if (world == null) {
            return;
        }
        Entity entity = entityType.func_200721_a(world);
        if (entity != null) {
            stack.func_77982_d(BeeInfoUtils.createJarBeeTag((BeeEntity)entity, "Entity"));
            BeeJar.renameJar(stack, (BeeEntity)entity);
        }
    }

    private static World getWorld() {
        if (FMLLoader.getDist().isClient()) {
            return BeeInfoUtils.getClientWorld();
        }
        return ServerLifecycleHooks.getCurrentServer().func_241755_D_();
    }

    private void renameJar(ItemStack stack, CompoundNBT tag, String name) {
        Entity entity;
        World world = BeeJar.getWorld();
        if (world == null) {
            return;
        }
        if (stack.func_77978_p() == null || stack.func_77978_p().func_74764_b("display")) {
            return;
        }
        String id = tag.func_74779_i("Entity");
        EntityType<?> entityType = BeeInfoUtils.getEntityType(id);
        if (entityType != null && (entity = entityType.func_200721_a(world)) != null) {
            BeeJar.renameJar(stack, entity, name);
        }
    }

    @NotNull
    public String func_77667_c(@NotNull ItemStack stack) {
        String name;
        if (BeeJar.isFilled(stack)) {
            name = "item.resourcefulbees.bee_jar_filled";
            this.renameJar(stack, stack.func_77978_p(), name);
        } else {
            name = "item.resourcefulbees.bee_jar_empty";
        }
        return name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && BeeJar.isFilled(stack)) {
            String id = tag.func_74779_i("Entity");
            EntityType<?> entityType = BeeInfoUtils.getEntityType(id);
            StringTextComponent name = entityType == null ? new StringTextComponent("NULL_ENTITY") : entityType.func_212546_e();
            tooltip.add((ITextComponent)new StringTextComponent("  - ").func_230529_a_((ITextComponent)name).func_240699_a_(TextFormatting.WHITE));
        }
    }
}

