/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.item;

import com.resourcefulbees.resourcefulbees.item.BeeJar;
import com.resourcefulbees.resourcefulbees.tileentity.multiblocks.apiary.ApiaryTileEntity;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeeBox
extends Item {
    private static final String ITEM_DOT = "item.";
    boolean isTemp;

    public BeeBox(Item.Properties properties, boolean isTemp) {
        super(properties);
        this.isTemp = isTemp;
    }

    @NotNull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player != null) {
            BlockPos pos;
            World playerWorld = context.func_195999_j().func_130014_f_();
            ItemStack stack = context.func_195996_i();
            if (playerWorld.func_201670_d()) {
                return ActionResultType.FAIL;
            }
            World worldIn = context.func_195991_k();
            if ((worldIn.func_175625_s(pos = context.func_195995_a()) instanceof ApiaryTileEntity || worldIn.func_175625_s(pos) instanceof BeehiveTileEntity) && context.func_195999_j().func_225608_bj_()) {
                return this.stealBees(player, worldIn, stack, pos);
            }
            if (!BeeBox.isFilled(stack)) {
                return ActionResultType.FAIL;
            }
            if (context.func_195999_j().func_225608_bj_()) {
                this.releaseAll(worldIn, stack, pos, context, player);
            } else {
                this.releaseOne(worldIn, stack, pos, context, player);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    private void releaseOne(World worldIn, ItemStack stack, BlockPos pos, ItemUseContext context, PlayerEntity player) {
        assert (stack.func_77978_p() != null);
        ListNBT listNBT = stack.func_77978_p().func_150295_c("Bees", 10);
        CompoundNBT tag = (CompoundNBT)listNBT.remove(0);
        EntityType.func_220327_a((String)tag.func_74775_l("EntityData").func_74779_i("id")).ifPresent(type -> {
            Entity entity = type.func_200721_a(worldIn);
            if (entity != null) {
                entity.func_70020_e(tag);
                this.loadEntity(pos, context, entity, worldIn, player);
            }
        });
        if (listNBT.isEmpty()) {
            stack.func_77982_d(null);
            if (this.isTemp) {
                stack.func_190918_g(1);
            }
        } else {
            CompoundNBT nbt = stack.func_77978_p();
            nbt.func_218657_a("Bees", (INBT)listNBT);
            stack.func_77982_d(nbt);
        }
    }

    private void releaseAll(World worldIn, ItemStack stack, BlockPos pos, ItemUseContext context, PlayerEntity player) {
        List<Entity> entities = this.getEntitiesFromStack(stack, worldIn, true);
        for (Entity entity : entities) {
            if (entity == null) continue;
            this.loadEntity(pos, context, entity, worldIn, player);
        }
        if (this.isTemp) {
            stack.func_190918_g(1);
        } else {
            stack.func_77982_d(null);
        }
    }

    private ActionResultType stealBees(PlayerEntity player, World worldIn, ItemStack stack, BlockPos pos) {
        if (this.isTemp) {
            return ActionResultType.FAIL;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        ListNBT list = stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("Bees") ? stack.func_77978_p().func_150295_c("Bees", 10) : new ListNBT();
        int space = 10 - list.size();
        if (tile instanceof ApiaryTileEntity) {
            ApiaryTileEntity apiary = (ApiaryTileEntity)tile;
            Map<String, ApiaryTileEntity.ApiaryBee> bees = apiary.bees;
            if (apiary.bees.isEmpty()) {
                return ActionResultType.FAIL;
            }
            for (int i = 0; i < space && !apiary.bees.isEmpty(); ++i) {
                ApiaryTileEntity.ApiaryBee bee = bees.remove(bees.entrySet().iterator().next().getKey());
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_218657_a("EntityData", (INBT)bee.entityData);
                list.add((Object)nbt);
            }
        } else if (tile instanceof BeehiveTileEntity) {
            ListIterator beeIterator;
            BeehiveTileEntity hive = (BeehiveTileEntity)tile;
            if (hive.field_226958_a_.isEmpty()) {
                return ActionResultType.FAIL;
            }
            if (!hive.func_226972_k_()) {
                hive.func_226963_a_(player, worldIn.func_180495_p(pos), BeehiveTileEntity.State.EMERGENCY);
                return ActionResultType.SUCCESS;
            }
            for (int i = 0; i < space && (beeIterator = hive.field_226958_a_.listIterator()).hasNext(); ++i) {
                BeehiveTileEntity.Bee bee = (BeehiveTileEntity.Bee)beeIterator.next();
                beeIterator.remove();
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_218657_a("EntityData", (INBT)bee.field_226977_a_);
                list.add((Object)nbt);
            }
        }
        CompoundNBT nbt = stack.func_77978_p() == null ? new CompoundNBT() : stack.func_77978_p();
        nbt.func_218657_a("Bees", (INBT)list);
        stack.func_77982_d(nbt);
        return ActionResultType.SUCCESS;
    }

    private void loadEntity(BlockPos pos, ItemUseContext context, Entity entity, World worldIn, PlayerEntity player) {
        BlockPos blockPos = pos.func_177972_a(context.func_196000_l());
        entity.func_70080_a((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5, 0.0f, 0.0f);
        worldIn.func_217376_c(entity);
        if (entity instanceof BeeEntity) {
            BeeEntity beeEntity = (BeeEntity)entity;
            BeeJar.resetBee(beeEntity);
            BeeJar.setBeeAngry(beeEntity, player);
        }
    }

    @NotNull
    public List<Entity> getEntitiesFromStack(ItemStack stack, World world, boolean withInfo) {
        CompoundNBT tag = stack.func_77978_p();
        ArrayList<Entity> entities = new ArrayList<Entity>();
        if (tag != null) {
            ListNBT bees = tag.func_150295_c("Bees", 10);
            bees.stream().map(CompoundNBT.class::cast).forEach(compoundNBT -> {
                EntityType type = EntityType.func_220327_a((String)compoundNBT.func_74775_l("EntityData").func_74779_i("id")).orElse(null);
                if (type != null) {
                    Entity entity = type.func_200721_a(world);
                    if (entity != null && withInfo) {
                        entity.func_70020_e(compoundNBT.func_74775_l("EntityData"));
                    }
                    entities.add(entity);
                }
            });
        }
        return entities;
    }

    @NotNull
    public ActionResultType func_111207_a(@NotNull ItemStack stack, @NotNull PlayerEntity player, LivingEntity targetIn, @NotNull Hand hand) {
        ListNBT bees;
        if (targetIn.func_130014_f_().func_201670_d() || !(targetIn instanceof BeeEntity) || ((BeeEntity)targetIn).func_233678_J__() || !targetIn.func_70089_S()) {
            return ActionResultType.FAIL;
        }
        if (this.isTemp) {
            return ActionResultType.FAIL;
        }
        BeeEntity target = (BeeEntity)targetIn;
        CompoundNBT tag = stack.func_77978_p() == null ? new CompoundNBT() : stack.func_77978_p();
        ListNBT listNBT = bees = tag.func_74764_b("Bees") ? tag.func_150295_c("Bees", 10) : new ListNBT();
        if (bees.size() == 10) {
            return ActionResultType.FAIL;
        }
        CompoundNBT entityData = new CompoundNBT();
        entityData.func_218657_a("EntityData", (INBT)BeeInfoUtils.createJarBeeTag(target, "id"));
        bees.add((Object)entityData);
        tag.func_218657_a("Bees", (INBT)bees);
        stack.func_77982_d(tag);
        player.func_184611_a(hand, stack);
        player.func_184609_a(hand);
        target.remove(true);
        return ActionResultType.PASS;
    }

    public static boolean isFilled(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("Bees");
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag tooltipFlag) {
        super.func_77624_a(stack, world, tooltip, tooltipFlag);
        if (this.isTemp) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.resourcefulbees.information.bee_box.temp_info").func_240699_a_(TextFormatting.GOLD));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.resourcefulbees.information.bee_box.info").func_240699_a_(TextFormatting.GOLD));
        }
        if (BeeInfoUtils.isShiftPressed() && BeeBox.isFilled(stack)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.resourcefulbees.information.bee_box.bees").func_240699_a_(TextFormatting.YELLOW));
            stack.func_77978_p().func_150295_c("Bees", 10).stream().map(CompoundNBT.class::cast).forEach(compoundNBT -> {
                String id = compoundNBT.func_74775_l("EntityData").func_74779_i("id");
                EntityType<?> entityType = BeeInfoUtils.getEntityType(id);
                TranslationTextComponent name = entityType == null ? new TranslationTextComponent("NULL_NAME") : entityType.func_212546_e();
                tooltip.add((ITextComponent)new StringTextComponent("  - ").func_230529_a_((ITextComponent)name).func_240699_a_(TextFormatting.WHITE));
            });
        } else if (BeeBox.isFilled(stack)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.resourcefulbees.information.bee_box.more_info").func_240699_a_(TextFormatting.YELLOW));
        }
    }
}

