/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.init;

import com.resourcefulbees.resourcefulbees.ResourcefulBees;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.api.beedata.MutationData;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.Mutation;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.MutationOutput;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.outputs.BlockOutput;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.outputs.EntityOutput;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.outputs.ItemOutput;
import com.resourcefulbees.resourcefulbees.lib.MutationTypes;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import com.resourcefulbees.resourcefulbees.utils.RandomCollection;
import com.resourcefulbees.resourcefulbees.utils.validation.SecondPhaseValidator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;

public class MutationSetup {
    private MutationSetup() {
        throw new IllegalStateException("Utility Class");
    }

    public static void setupMutations() {
        ResourcefulBees.LOGGER.info("Validating Mutations...");
        BeeRegistry.getRegistry().getBees().values().forEach(MutationSetup::initMutationData);
    }

    private static void initMutationData(CustomBeeData beeData) {
        beeData.getMutationData().initializeMutations();
        if (beeData.getMutationData().hasMutation()) {
            MutationSetup.setupMutations(beeData);
        }
    }

    private static void setupMutations(CustomBeeData customBeeData) {
        List<Object> mutations;
        MutationData mutationData = customBeeData.getMutationData();
        List<Object> list = mutations = mutationData.getMutations() == null ? new LinkedList() : mutationData.getMutations();
        if (MutationSetup.hasLegacyMutation(mutationData)) {
            mutations.add(new Mutation(mutationData.getMutationType(), mutationData.getMutationInput(), 1.0, new MutationOutput(mutationData.getMutationOutput(), 1.0, null)));
        }
        mutations.removeIf(mutation -> SecondPhaseValidator.validateMutation(customBeeData.getName(), mutation));
        mutationData.initializeMutations();
        MutationSetup.addMutations(customBeeData.getMutationData(), mutations, customBeeData.getName());
    }

    private static boolean hasLegacyMutation(MutationData mutationData) {
        return !mutationData.getMutationInput().isEmpty() && !mutationData.getMutationOutput().isEmpty() && !mutationData.getMutationType().equals((Object)MutationTypes.NONE);
    }

    private static void addMutations(MutationData mutationData, List<Mutation> mutations, String name) {
        mutations.stream().filter(mutation -> !mutation.getType().equals((Object)MutationTypes.NONE)).forEach(mutation -> {
            if (mutation.isTag()) {
                if (mutation.getType().equals((Object)MutationTypes.BLOCK_TO_ITEM) || mutation.getType().equals((Object)MutationTypes.ITEM)) {
                    MutationSetup.addBlockItemTagMutation(mutationData, mutation, name);
                } else {
                    MutationSetup.addBlockTagMutation(mutationData, mutation, name);
                }
            } else if (mutation.getType().equals((Object)MutationTypes.ENTITY_TO_ENTITY) || mutation.getType().equals((Object)MutationTypes.ENTITY)) {
                MutationSetup.addEntityMutation(mutationData, mutation, name);
            } else if (mutation.getType().equals((Object)MutationTypes.BLOCK_TO_ITEM) || mutation.getType().equals((Object)MutationTypes.ITEM)) {
                MutationSetup.addBlockItemMutation(mutationData, mutation, name);
            } else {
                MutationSetup.addBlockMutation(mutationData, mutation, name);
            }
        });
    }

    private static void addBlockItemTagMutation(MutationData mutationData, Mutation mutation, String name) {
        String tag = mutation.getInputID().replace("tag:", "");
        ITag<Block> input = BeeInfoUtils.getBlockTag(tag);
        if (input == null) {
            input = BeeInfoUtils.getFluidTag(tag);
        }
        RandomCollection<ItemOutput> randomCollection = MutationSetup.createRandomItemCollection(mutation);
        if (input != null && !randomCollection.isEmpty() && mutation.getType() != MutationTypes.NONE) {
            input.func_230236_b_().forEach(o -> {
                if (o instanceof Block) {
                    mutationData.addItemMutation((Block)o, randomCollection, mutation.getChance());
                    return;
                }
                if (o instanceof Fluid) {
                    Block block = ((Fluid)o).func_207188_f().func_206883_i().func_177230_c();
                    mutationData.addItemMutation(block, randomCollection, mutation.getChance());
                }
            });
            mutationData.addJeiBlockTagItemMutation(input, randomCollection, mutation.getChance());
        } else {
            MutationSetup.logWarning(mutation, name);
        }
    }

    private static void addBlockItemMutation(MutationData mutationData, Mutation mutation, String name) {
        Block input = BeeInfoUtils.getBlock(mutation.getInputID());
        RandomCollection<ItemOutput> randomCollection = MutationSetup.createRandomItemCollection(mutation);
        if (input != Blocks.field_150350_a && !randomCollection.isEmpty() && mutation.getType() != MutationTypes.NONE) {
            mutationData.addItemMutation(input, randomCollection, mutation.getChance());
            mutationData.addJeiItemMutation(input, randomCollection, mutation.getChance());
        } else {
            MutationSetup.logWarning(mutation, name);
        }
    }

    private static void addBlockMutation(MutationData mutationData, Mutation mutation, String name) {
        Block input = BeeInfoUtils.getBlock(mutation.getInputID());
        RandomCollection<BlockOutput> randomCollection = MutationSetup.createRandomBlockCollection(mutation);
        if (input != Blocks.field_150350_a && !randomCollection.isEmpty() && mutation.getType() != MutationTypes.NONE) {
            mutationData.addBlockMutation(input, randomCollection, mutation.getChance());
            mutationData.addJeiBlockMutation(input, randomCollection, mutation.getChance());
        } else {
            MutationSetup.logWarning(mutation, name);
        }
    }

    private static void addBlockTagMutation(MutationData mutationData, Mutation mutation, String name) {
        String tag = mutation.getInputID().replace("tag:", "");
        ITag<Block> input = BeeInfoUtils.getBlockTag(tag);
        if (input == null) {
            input = BeeInfoUtils.getFluidTag(tag);
        }
        RandomCollection<BlockOutput> randomCollection = MutationSetup.createRandomBlockCollection(mutation);
        if (input != null && !randomCollection.isEmpty() && mutation.getType() != MutationTypes.NONE) {
            input.func_230236_b_().forEach(o -> {
                if (o instanceof Block) {
                    mutationData.addBlockMutation((Block)o, randomCollection, mutation.getChance());
                    return;
                }
                if (o instanceof Fluid) {
                    Block block = ((Fluid)o).func_207188_f().func_206883_i().func_177230_c();
                    mutationData.addBlockMutation(block, randomCollection, mutation.getChance());
                }
            });
            mutationData.addJeiBlockTagMutation(input, randomCollection, mutation.getChance());
        } else {
            MutationSetup.logWarning(mutation, name);
        }
    }

    private static void addEntityMutation(MutationData mutationData, Mutation mutation, String name) {
        EntityType<?> input = BeeInfoUtils.getEntityType(mutation.getInputID().replace("entity:", ""));
        RandomCollection<EntityOutput> randomCollection = new RandomCollection<EntityOutput>();
        mutation.getOutputs().forEach(mutationOutput -> {
            EntityType<?> output;
            if (mutationOutput.getOutputID() != null && (output = BeeInfoUtils.getEntityType(mutationOutput.getOutputID().replace("entity:", ""))) != null) {
                randomCollection.add(mutationOutput.getWeight(), new EntityOutput(output, mutationOutput.getNbt(), mutationOutput.getWeight()));
            }
        });
        if (input != null && !randomCollection.isEmpty() && mutation.getType() != MutationTypes.NONE) {
            mutationData.addEntityMutation(input, randomCollection, mutation.getChance());
        } else {
            MutationSetup.logWarning(mutation, name);
        }
    }

    private static RandomCollection<ItemOutput> createRandomItemCollection(Mutation mutation) {
        RandomCollection<ItemOutput> randomCollection = new RandomCollection<ItemOutput>();
        mutation.getOutputs().forEach(mutationOutput -> {
            Item output = BeeInfoUtils.getItem(mutationOutput.getOutputID());
            CompoundNBT compoundNBT = mutationOutput.getNbt();
            if (!output.equals(Items.field_190931_a)) {
                randomCollection.add(mutationOutput.getWeight(), new ItemOutput(output, compoundNBT, mutationOutput.getWeight()));
            }
        });
        return randomCollection;
    }

    private static RandomCollection<BlockOutput> createRandomBlockCollection(Mutation mutation) {
        RandomCollection<BlockOutput> randomCollection = new RandomCollection<BlockOutput>();
        mutation.getOutputs().forEach(mutationOutput -> {
            Block output = BeeInfoUtils.getBlock(mutationOutput.getOutputID());
            CompoundNBT compoundNBT = mutationOutput.getNbt();
            if (!output.equals(Blocks.field_150350_a)) {
                randomCollection.add(mutationOutput.getWeight(), new BlockOutput(output, compoundNBT, mutationOutput.getWeight()));
            }
        });
        return randomCollection;
    }

    private static void logWarning(Mutation mutation, String name) {
        ResourcefulBees.LOGGER.warn("Could not validate mutation for: {}   mutation: {}", (Object)name, (Object)mutation);
    }
}

