/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.init;

import com.google.gson.Gson;
import com.resourcefulbees.resourcefulbees.ResourcefulBees;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.init.ModSetup;
import com.resourcefulbees.resourcefulbees.registry.BiomeDictionary;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.Locale;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;

public class BiomeDictionarySetup {
    private static final String JSON = ".json";
    private static final String ZIP = ".zip";
    private static Path dictionaryPath;

    private BiomeDictionarySetup() {
        throw new IllegalStateException("Utility Class");
    }

    public static void buildDictionary() {
        ResourcefulBees.LOGGER.info("Building Biome Dictionary...");
        if (((Boolean)Config.GENERATE_BIOME_DICTIONARIES.get()).booleanValue()) {
            BiomeDictionarySetup.setupDefaultTypes();
        }
        BiomeDictionarySetup.addBiomeTypes();
    }

    private static void parseType(Reader reader, String name) {
        Gson gson = new Gson();
        BiomeDictionary.BiomeType biomeType = (BiomeDictionary.BiomeType)gson.fromJson(reader, BiomeDictionary.BiomeType.class);
        for (String biome : biomeType.getBiomes()) {
            BiomeDictionary.getTypes().computeIfAbsent(name.toLowerCase(Locale.ENGLISH), k -> new HashSet()).add(new ResourceLocation(biome.toLowerCase(Locale.ENGLISH)));
        }
    }

    private static void addBiomeTypes() {
        try (Stream<Path> zipStream = Files.walk(dictionaryPath, new FileVisitOption[0]);
             Stream<Path> jsonStream = Files.walk(dictionaryPath, new FileVisitOption[0]);){
            zipStream.filter(f -> f.getFileName().toString().endsWith(ZIP)).forEach(BiomeDictionarySetup::addZippedType);
            jsonStream.filter(f -> f.getFileName().toString().endsWith(JSON)).forEach(BiomeDictionarySetup::addType);
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.error("Could not stream biome dictionary!!", (Throwable)e);
        }
    }

    private static void addType(Path file) {
        File f = file.toFile();
        try {
            ModSetup.parseType(f, BiomeDictionarySetup::parseType);
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.error("File not found when parsing biome types");
        }
    }

    private static void addZippedType(Path file) {
        try (ZipFile zf = new ZipFile(file.toString());){
            zf.stream().forEach(zipEntry -> {
                if (zipEntry.getName().endsWith(JSON)) {
                    try {
                        ModSetup.parseType(zf, zipEntry, BiomeDictionarySetup::parseType);
                    }
                    catch (IOException e) {
                        String name = zipEntry.getName();
                        name = name.substring(name.lastIndexOf("/") + 1, name.indexOf(46));
                        ResourcefulBees.LOGGER.error("Could not parse {} biome type from ZipFile", (Object)name);
                    }
                }
            });
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.warn("Could not read ZipFile! ZipFile: {}", (Object)file.getFileName());
        }
    }

    private static void setupDefaultTypes() {
        ModFileInfo mod = ModList.get().getModFileById("resourcefulbees");
        Path source = mod.getFile().getFilePath();
        try {
            if (Files.isRegularFile(source, new LinkOption[0])) {
                BiomeDictionarySetup.createFileSystem(source);
            } else if (Files.isDirectory(source, new LinkOption[0])) {
                BiomeDictionarySetup.copyDefaultTypes(Paths.get(source.toString(), "/data/resourcefulbees/biome_dictionary"));
            }
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.error("Could not setup default types!!", (Throwable)e);
        }
    }

    private static void createFileSystem(Path source) throws IOException {
        try (FileSystem fileSystem = FileSystems.newFileSystem(source, null);){
            Path defaultBees = fileSystem.getPath("/data/resourcefulbees/biome_dictionary", new String[0]);
            if (Files.exists(defaultBees, new LinkOption[0])) {
                BiomeDictionarySetup.copyDefaultTypes(defaultBees);
            }
        }
    }

    private static void copyDefaultTypes(Path source) {
        try (Stream<Path> sourceStream = Files.walk(source, new FileVisitOption[0]);){
            sourceStream.filter(f -> f.getFileName().toString().endsWith(JSON)).forEach(path -> {
                File targetFile = new File(String.valueOf(Paths.get(dictionaryPath.toString(), "/", path.getFileName().toString())));
                try {
                    Files.copy(path, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    ResourcefulBees.LOGGER.error("Could not copy default biome types!!", (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.error("Could not stream default biome types!!", (Throwable)e);
        }
    }

    public static void setDictionaryPath(Path dictionaryPath) {
        BiomeDictionarySetup.dictionaryPath = dictionaryPath;
    }
}

