/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.init;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.resourcefulbees.resourcefulbees.ResourcefulBees;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.api.honeydata.HoneyBottleData;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.entity.passive.AbBee;
import com.resourcefulbees.resourcefulbees.entity.passive.CustomBeeEntity;
import com.resourcefulbees.resourcefulbees.entity.passive.KittenBee;
import com.resourcefulbees.resourcefulbees.entity.passive.OreoBee;
import com.resourcefulbees.resourcefulbees.entity.passive.StarryBee;
import com.resourcefulbees.resourcefulbees.entity.passive.YetiBee;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.registry.ModEntities;
import com.resourcefulbees.resourcefulbees.registry.ModFeatures;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Locale;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.registries.ForgeRegistries;

public class BeeSetup {
    private static final String JSON = ".json";
    private static final String ZIP = ".zip";
    private static Path beePath;
    private static Path resourcePath;
    private static Path honeyPath;

    private BeeSetup() {
        throw new IllegalStateException("Utility Class");
    }

    public static void setBeePath(Path path) {
        beePath = path;
    }

    public static void setResourcePath(Path path) {
        resourcePath = path;
    }

    public static Path getResourcePath() {
        return resourcePath;
    }

    public static void setHoneyPath(Path path) {
        honeyPath = path;
    }

    public static void setupBees() {
        if (Boolean.TRUE.equals(Config.ENABLE_EASTER_EGG_BEES.get())) {
            OreoBee.register();
            KittenBee.register();
            YetiBee.register();
            StarryBee.register();
            StarryBee.register();
        }
        if (Boolean.TRUE.equals(Config.ENABLE_CUSTOM_PATREON_BEES.get())) {
            AbBee.register();
        }
        if (Boolean.TRUE.equals(Config.GENERATE_DEFAULTS.get())) {
            BeeSetup.setupDefaultBees();
            BeeSetup.setupDefaultHoney();
        }
        BeeSetup.addBees();
        BeeSetup.addHoney();
    }

    private static void parseBee(File file) throws IOException {
        String name = file.getName();
        name = name.substring(0, name.indexOf(46));
        BufferedReader r = Files.newBufferedReader(file.toPath());
        BeeSetup.parseBee(r, name);
    }

    private static void parseBee(ZipFile zf, ZipEntry zipEntry) throws IOException {
        String name = zipEntry.getName();
        name = name.substring(name.lastIndexOf("/") + 1, name.indexOf(46));
        InputStream input = zf.getInputStream(zipEntry);
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        BeeSetup.parseBee(reader, name);
    }

    private static void parseBee(Reader reader, String name) {
        name = name.toLowerCase(Locale.ENGLISH).replace(" ", "_");
        Gson gson = new Gson();
        try {
            CustomBeeData bee = (CustomBeeData)gson.fromJson(reader, CustomBeeData.class);
            bee.setName(name);
            bee.setShouldResourcefulBeesDoForgeRegistration(true);
            BeeRegistry.getRegistry().registerBee(name, bee);
        }
        catch (JsonSyntaxException e) {
            String exception = String.format("Error was found trying to parse bee: %s. Json is invalid, validate it here : https://jsonlint.com/", name);
            throw new JsonSyntaxException(exception);
        }
    }

    private static void parseHoney(File file) throws IOException {
        String name = file.getName();
        name = name.substring(0, name.indexOf(46));
        BufferedReader r = Files.newBufferedReader(file.toPath());
        BeeSetup.parseHoney(r, name);
    }

    private static void parseHoney(ZipFile zf, ZipEntry zipEntry) throws IOException {
        String name = zipEntry.getName();
        name = name.substring(name.lastIndexOf("/") + 1, name.indexOf(46));
        InputStream input = zf.getInputStream(zipEntry);
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        BeeSetup.parseHoney(reader, name);
    }

    private static void parseHoney(Reader reader, String name) {
        name = name.toLowerCase(Locale.ENGLISH).replace(" ", "_");
        Gson gson = new Gson();
        try {
            HoneyBottleData honey = (HoneyBottleData)gson.fromJson(reader, HoneyBottleData.class);
            if (honey.getName() == null) {
                honey.setName(name);
            }
            honey.setShouldResourcefulBeesDoForgeRegistration(true);
            BeeRegistry.getRegistry().registerHoney(honey.getName(), honey);
        }
        catch (JsonSyntaxException e) {
            String exception = String.format("Error was found trying to parse honey: %s. Json is invalid, validate it here : https://jsonlint.com/", name);
            throw new JsonSyntaxException(exception);
        }
    }

    private static void addBees() {
        ResourcefulBees.LOGGER.info("Registering Custom Bees...");
        try (Stream<Path> zipStream = Files.walk(beePath, new FileVisitOption[0]);
             Stream<Path> jsonStream = Files.walk(beePath, new FileVisitOption[0]);){
            zipStream.filter(f -> f.getFileName().toString().endsWith(ZIP)).forEach(BeeSetup::addZippedBee);
            jsonStream.filter(f -> f.getFileName().toString().endsWith(JSON)).forEach(BeeSetup::addBee);
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.error("Could not stream bees!!", (Throwable)e);
        }
    }

    private static void addHoney() {
        ResourcefulBees.LOGGER.info("Registering Custom Honeys..");
        try (Stream<Path> zipStream = Files.walk(honeyPath, new FileVisitOption[0]);
             Stream<Path> jsonStream = Files.walk(honeyPath, new FileVisitOption[0]);){
            zipStream.filter(f -> f.getFileName().toString().endsWith(ZIP)).forEach(BeeSetup::addZippedHoney);
            jsonStream.filter(f -> f.getFileName().toString().endsWith(JSON)).forEach(BeeSetup::addHoney);
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.error("Could not stream honey!!", (Throwable)e);
        }
    }

    private static void addHoney(Path file) {
        File f = file.toFile();
        try {
            BeeSetup.parseHoney(f);
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.error("File not found when parsing honey");
        }
    }

    private static void addZippedHoney(Path file) {
        try (ZipFile zf = new ZipFile(file.toString());){
            zf.stream().forEach(zipEntry -> {
                if (zipEntry.getName().endsWith(JSON)) {
                    try {
                        BeeSetup.parseHoney(zf, zipEntry);
                    }
                    catch (IOException e) {
                        String name = zipEntry.getName();
                        name = name.substring(name.lastIndexOf("/") + 1, name.indexOf(46));
                        ResourcefulBees.LOGGER.error("Could not parse {} honey from ZipFile", (Object)name);
                    }
                }
            });
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.warn("Could not read ZipFile! ZipFile: {}", (Object)file.getFileName());
        }
    }

    private static void addBee(Path file) {
        File f = file.toFile();
        try {
            BeeSetup.parseBee(f);
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.error("File not found when parsing bees");
        }
    }

    private static void addZippedBee(Path file) {
        try (ZipFile zf = new ZipFile(file.toString());){
            zf.stream().forEach(zipEntry -> {
                if (zipEntry.getName().endsWith(JSON)) {
                    try {
                        BeeSetup.parseBee(zf, zipEntry);
                    }
                    catch (IOException e) {
                        String name = zipEntry.getName();
                        name = name.substring(name.lastIndexOf("/") + 1, name.indexOf(46));
                        ResourcefulBees.LOGGER.error("Could not parse {} bee from ZipFile", (Object)name);
                    }
                }
            });
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.warn("Could not read ZipFile! ZipFile: {}", (Object)file.getFileName());
        }
    }

    private static void setupDefaultBees() {
        ModFileInfo mod = ModList.get().getModFileById("resourcefulbees");
        Path source = mod.getFile().getFilePath();
        try {
            if (Files.isRegularFile(source, new LinkOption[0])) {
                BeeSetup.createFileSystem(source);
            } else if (Files.isDirectory(source, new LinkOption[0])) {
                BeeSetup.copyDefaultBees(Paths.get(source.toString(), "/data/resourcefulbees/default_bees"));
            }
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.error("Could not setup default bees!!", (Throwable)e);
        }
    }

    private static void setupDefaultHoney() {
        ModFileInfo mod = ModList.get().getModFileById("resourcefulbees");
        Path source = mod.getFile().getFilePath();
        try {
            if (Files.isRegularFile(source, new LinkOption[0])) {
                BeeSetup.createFileSystem(source);
            } else if (Files.isDirectory(source, new LinkOption[0])) {
                BeeSetup.copyDefaultHoney(Paths.get(source.toString(), "/data/resourcefulbees/default_honey"));
            }
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.error("Could not setup default honey!!", (Throwable)e);
        }
    }

    private static void copyDefaultHoney(Path source) {
        try (Stream<Path> sourceStream = Files.walk(source, new FileVisitOption[0]);){
            sourceStream.filter(f -> f.getFileName().toString().endsWith(JSON)).forEach(path -> {
                File targetFile = new File(String.valueOf(Paths.get(honeyPath.toString(), "/", path.getFileName().toString())));
                try {
                    Files.copy(path, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    ResourcefulBees.LOGGER.error("Could not copy default honey!!", (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.error("Could not stream honey!!", (Throwable)e);
        }
    }

    private static void createFileSystem(Path source) throws IOException {
        try (FileSystem fileSystem = FileSystems.newFileSystem(source, null);){
            Path defaultBees = fileSystem.getPath("/data/resourcefulbees/default_bees", new String[0]);
            Path defaultHoney = fileSystem.getPath("/data/resourcefulbees/default_honey", new String[0]);
            if (Files.exists(defaultBees, new LinkOption[0])) {
                BeeSetup.copyDefaultBees(defaultBees);
            }
            if (Files.exists(defaultHoney, new LinkOption[0])) {
                BeeSetup.copyDefaultHoney(defaultHoney);
            }
        }
    }

    private static void copyDefaultBees(Path source) {
        try (Stream<Path> sourceStream = Files.walk(source, new FileVisitOption[0]);){
            sourceStream.filter(f -> f.getFileName().toString().endsWith(JSON)).forEach(path -> {
                File targetFile = new File(String.valueOf(Paths.get(beePath.toString(), "/", path.getFileName().toString())));
                try {
                    Files.copy(path, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    ResourcefulBees.LOGGER.error("Could not copy default bees!!", (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.error("Could not stream bees!!", (Throwable)e);
        }
    }

    public static void onBiomeLoad(BiomeLoadingEvent event) {
        if (event.getName() != null && BeeRegistry.getSpawnableBiomes().containsKey(event.getName())) {
            BeeRegistry.getSpawnableBiomes().get(event.getName()).forEach(customBeeData -> {
                EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(customBeeData.getEntityTypeRegistryID());
                if (entityType != null) {
                    event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners(entityType, customBeeData.getSpawnData().getSpawnWeight() + (event.getName().func_110623_a().contains("flower_forest") ? (Integer)Config.BEE_FLOWER_FOREST_MULTIPLIER.get() : 0), customBeeData.getSpawnData().getMinGroupSize(), customBeeData.getSpawnData().getMaxGroupSize()));
                }
            });
            if (Boolean.TRUE.equals(Config.GENERATE_BEE_NESTS.get())) {
                BeeSetup.addNestFeature(event);
            }
        }
    }

    private static void addNestFeature(BiomeLoadingEvent event) {
        Biome.Category category = event.getCategory();
        if (category == Biome.Category.NETHER) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.ConfiguredFeatures.NETHER_NESTS);
        } else if (category == Biome.Category.THEEND) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.ConfiguredFeatures.THE_END_NESTS);
        } else {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.ConfiguredFeatures.OVERWORLD_NESTS);
        }
    }

    public static void registerBeePlacements() {
        ModEntities.getModBees().forEach((s, entityTypeRegistryObject) -> {
            CustomBeeData beeData = BeeRegistry.getRegistry().getBeeData((String)s);
            if (beeData.getSpawnData().canSpawnInWorld()) {
                EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)entityTypeRegistryObject.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, CustomBeeEntity::canBeeSpawn);
            }
        });
    }
}

