/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.fluids;

import com.resourcefulbees.resourcefulbees.api.honeydata.HoneyBottleData;
import com.resourcefulbees.resourcefulbees.utils.color.RainbowColor;
import java.util.function.BiFunction;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class HoneyFluidAttributes
extends FluidAttributes {
    private final HoneyBottleData honeyData;

    protected HoneyFluidAttributes(FluidAttributes.Builder builder, Fluid fluid, HoneyBottleData honeyData) {
        super(builder, fluid);
        this.honeyData = honeyData;
    }

    public int getColor(IBlockDisplayReader world, BlockPos pos) {
        return this.getColor();
    }

    public int getColor(FluidStack stack) {
        return this.getColor();
    }

    public int getColor() {
        return this.honeyData.isRainbow() ? RainbowColor.getRGB() : this.honeyData.getHoneyColorInt() | 0xFF000000;
    }

    public static Builder builder(ResourceLocation stillTexture, ResourceLocation flowingTexture, HoneyBottleData honeyData) {
        return new Builder(stillTexture, flowingTexture, (builder, fluid) -> new HoneyFluidAttributes((FluidAttributes.Builder)builder, (Fluid)fluid, honeyData));
    }

    public static class Builder
    extends FluidAttributes.Builder {
        protected Builder(ResourceLocation stillTexture, ResourceLocation flowingTexture, BiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> factory) {
            super(stillTexture, flowingTexture, factory);
        }
    }
}

