/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.entity.passive;

import com.resourcefulbees.resourcefulbees.api.ICustomBee;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.api.beedata.SpawnData;
import com.resourcefulbees.resourcefulbees.api.beedata.TraitData;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.entity.passive.ModBeeEntity;
import com.resourcefulbees.resourcefulbees.mixin.AnimalEntityAccessor;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import java.util.Objects;
import java.util.Random;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.NameTagItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class CustomBeeEntity
extends ModBeeEntity
implements ICustomBee,
IAnimatable {
    private static final DataParameter<Integer> FEED_COUNT = EntityDataManager.func_187226_a(CustomBeeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    protected final CustomBeeData beeData;
    protected int timeWithoutHive;
    protected int flowerID;
    private BlockPos lastFlower;
    private boolean hasHiveInRange;
    private int disruptorInRange;

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.bee.fly", Boolean.valueOf(true)).addAnimation("animation.bee.fly.bobbing", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public CustomBeeEntity(EntityType<? extends BeeEntity> type, World world, CustomBeeData beeData) {
        super(type, world);
        this.beeData = beeData;
    }

    public static AttributeModifierMap.MutableAttribute createBeeAttributes(String key) {
        CustomBeeData beeData = BeeRegistry.getRegistry().getBeeData(key);
        return CustomBeeEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, (double)beeData.getCombatData().getBaseHealth()).func_233815_a_(Attributes.field_233822_e_, (double)0.6f).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233823_f_, (double)beeData.getCombatData().getAttackDamage()).func_233815_a_(Attributes.field_233819_b_, 48.0);
    }

    @Override
    public String getBeeType() {
        return this.beeData.getName();
    }

    public BlockPos getLastFlower() {
        return this.lastFlower;
    }

    public void setLastFlower(BlockPos lastFlower) {
        this.lastFlower = lastFlower;
    }

    @Override
    public CustomBeeData getBeeData() {
        return this.beeData;
    }

    public int getFlowerEntityID() {
        return this.flowerID;
    }

    public void setFlowerEntityID(int id) {
        this.flowerID = id;
    }

    @Override
    public int getFeedCount() {
        return (Integer)this.field_70180_af.func_187225_a(FEED_COUNT);
    }

    @Override
    public void resetFeedCount() {
        this.field_70180_af.func_187227_b(FEED_COUNT, (Object)0);
    }

    @Override
    public void addFeedCount() {
        this.field_70180_af.func_187227_b(FEED_COUNT, (Object)(this.getFeedCount() + 1));
    }

    public boolean func_180431_b(@NotNull DamageSource source) {
        if (this.beeData.getCombatData().isInvulnerable() && !source.func_76357_e()) {
            return true;
        }
        TraitData info = this.getBeeData().getTraitData();
        if (this.func_70644_a(Effects.field_76427_o) && source == DamageSource.field_76369_e) {
            return true;
        }
        if (source.equals(DamageSource.field_220302_v)) {
            return true;
        }
        if (info.hasTraits() && info.hasDamageImmunities()) {
            return info.getDamageImmunities().stream().anyMatch(source.field_76373_n::equalsIgnoreCase);
        }
        return super.func_180431_b(source);
    }

    public boolean func_70687_e(@NotNull EffectInstance effectInstance) {
        TraitData info = this.getBeeData().getTraitData();
        if (info.hasTraits() && info.hasPotionImmunities()) {
            Effect potionEffect = effectInstance.func_188419_a();
            return info.getPotionImmunities().stream().noneMatch(potionEffect::equals);
        }
        return super.func_70687_e(effectInstance);
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            TraitData info;
            if (this.field_70173_aa % 40 == 0 && (info = this.getBeeData().getTraitData()).hasTraits() && info.hasParticleEffects()) {
                info.getParticleEffects().forEach(basicParticleType -> {
                    for (int i = 0; i < 10; ++i) {
                        this.field_70170_p.func_195594_a((IParticleData)basicParticleType, this.func_226282_d_(0.5), this.func_226279_cv_() - 0.25, this.func_226287_g_(0.5), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
                    }
                });
            }
        } else {
            if (((Boolean)Config.BEES_DIE_IN_VOID.get()).booleanValue() && this.func_213303_ch().field_72448_b <= 0.0) {
                this.func_70106_y();
            }
            if (!this.func_145818_k_() && this.field_70173_aa % 100 == 0) {
                if (this.hasHiveInRange() || this.func_226425_er_() || this.func_184218_aH() || this.func_104002_bU() || this.func_110167_bD() || this.func_226411_eD_() || this.disruptorInRange > 0 || this.func_70631_g_()) {
                    this.timeWithoutHive = 0;
                } else {
                    this.timeWithoutHive += 100;
                    if (this.timeWithoutHive >= 12000) {
                        this.func_70106_y();
                    }
                }
                this.hasHiveInRange = false;
            }
            if (this.field_70173_aa % 100 == 0) {
                --this.disruptorInRange;
                if (this.disruptorInRange < 0) {
                    this.disruptorInRange = 0;
                }
            }
        }
        super.func_70636_d();
    }

    public boolean hasHiveInRange() {
        return this.hasHiveInRange;
    }

    public void setHasHiveInRange(boolean hasHiveInRange) {
        this.hasHiveInRange = hasHiveInRange;
    }

    public static boolean canBeeSpawn(EntityType<? extends AgeableEntity> typeIn, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        String namespaceID = EntityType.func_200718_a(typeIn).toString();
        String beeType = namespaceID.substring(namespaceID.lastIndexOf(":") + 1, namespaceID.length() - 4);
        SpawnData spawnData = BeeRegistry.getRegistry().getBeeData(beeType).getSpawnData();
        switch (reason) {
            case NATURAL: 
            case CHUNK_GENERATION: {
                if (!spawnData.canSpawnInWorld()) break;
                if (pos.func_177956_o() < spawnData.getMinYLevel() || pos.func_177956_o() > spawnData.getMaxYLevel()) {
                    return false;
                }
                switch (spawnData.getLightLevel()) {
                    case DAY: {
                        return worldIn.func_201696_r(pos) >= 8;
                    }
                    case NIGHT: {
                        return worldIn.func_201696_r(pos) <= 7;
                    }
                    case ANY: {
                        return true;
                    }
                }
                break;
            }
            default: {
                return true;
            }
        }
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FEED_COUNT, (Object)0);
    }

    public void func_70037_a(@NotNull CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(FEED_COUNT, (Object)compound.func_74762_e("FeedCount"));
    }

    public void func_213281_b(@NotNull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("BeeType", this.getBeeType());
        compound.func_74768_a("FeedCount", this.getFeedCount());
    }

    @Override
    public AgeableEntity createSelectedChild(CustomBeeData customBeeData) {
        EntityType entityType = (EntityType)Objects.requireNonNull(ForgeRegistries.ENTITIES.getValue(customBeeData.getEntityTypeRegistryID()));
        Entity entity = entityType.func_200721_a(this.field_70170_p);
        return (AgeableEntity)entity;
    }

    public void func_146082_f(@Nullable PlayerEntity player) {
        if (player != null && !(player instanceof FakePlayer)) {
            super.func_146082_f(player);
        }
    }

    public void func_204700_e(int time) {
    }

    public void setLoveTime(int time) {
        ((AnimalEntityAccessor)((Object)this)).setLove(time);
    }

    public void func_70875_t() {
        super.func_70875_t();
        this.resetFeedCount();
    }

    public boolean func_70877_b(@NotNull ItemStack stack) {
        return BeeInfoUtils.isValidBreedItem(stack, this.getBeeData().getBreedData());
    }

    @NotNull
    public ActionResultType func_230254_b_(PlayerEntity player, @NotNull Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (item instanceof NameTagItem) {
            super.func_230254_b_(player, hand);
        }
        if (this.func_70877_b(itemstack)) {
            if (!this.field_70170_p.field_72995_K && this.func_70874_b() == 0 && !this.func_70880_s()) {
                this.func_175505_a(player, itemstack);
                player.func_191521_c(new ItemStack((IItemProvider)this.beeData.getBreedData().getFeedReturnItem()));
                this.addFeedCount();
                if (this.getFeedCount() >= this.getBeeData().getBreedData().getFeedAmount()) {
                    this.func_146082_f(player);
                }
                player.func_226292_a_(hand, true);
                return ActionResultType.PASS;
            }
            if (this.func_70631_g_()) {
                this.func_175505_a(player, itemstack);
                this.func_175501_a((int)((double)(-this.func_70874_b()) / 20.0 * (double)0.1f), true);
                return ActionResultType.PASS;
            }
        }
        return ActionResultType.FAIL;
    }

    protected void func_175500_n() {
        super.func_175500_n();
        if (!this.func_70631_g_()) {
            BlockPos pos = this.func_233580_cy_();
            this.func_70634_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public void setHasDisruptorInRange() {
        this.disruptorInRange += 2;
        if (this.disruptorInRange > 10) {
            this.disruptorInRange = 10;
        }
    }

    public boolean getDisruptorInRange() {
        return this.disruptorInRange > 0;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "bee_controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

