/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.entity.goals;

import com.resourcefulbees.resourcefulbees.api.traitdata.BeeAura;
import com.resourcefulbees.resourcefulbees.entity.passive.CustomBeeEntity;
import com.resourcefulbees.resourcefulbees.registry.ModEffects;
import com.resourcefulbees.resourcefulbees.utils.DamageUtils;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlaySoundPacket;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.Difficulty;
import net.minecraft.world.server.ServerWorld;

public class BeeAuraGoal
extends Goal {
    private final CustomBeeEntity entity;
    Random random = new Random();

    public BeeAuraGoal(CustomBeeEntity entity) {
        this.entity = entity;
    }

    public boolean func_75250_a() {
        return this.entity.getBeeData().getTraitData().hasBeeAuras();
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.entity.field_70173_aa % 160 == 0) {
            this.radiateAura();
        }
    }

    private void radiateAura() {
        AxisAlignedBB bb = new AxisAlignedBB(this.entity.func_233580_cy_()).func_186662_g((double)this.entity.getBeeData().getAuraRange());
        List entityList = this.entity.field_70170_p.func_217373_a(EntityPredicate.field_221016_a, (LivingEntity)this.entity, bb);
        this.entity.getBeeData().getTraitData().getBeeAuras().forEach(aura -> {
            if (this.entity.func_70644_a((Effect)ModEffects.CALMING.get()) && aura.calmingDisabled) {
                return;
            }
            AtomicReference<Boolean> flag = new AtomicReference<Boolean>(false);
            AtomicReference<BasicParticleType> type = new AtomicReference<BasicParticleType>(ParticleTypes.field_197598_I);
            entityList.forEach(playerEntity -> {
                if (!aura.isBeneficial() && this.entity.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
                    return;
                }
                switch (aura.auraType) {
                    case POTION: {
                        if (aura.potionEffect == null) {
                            return;
                        }
                        this.grantPotion((PlayerEntity)playerEntity, (BeeAura)aura);
                        type.set(ParticleTypes.field_197607_R);
                        flag.set(true);
                        break;
                    }
                    case BURNING: {
                        this.burnEntity((PlayerEntity)playerEntity);
                        type.set(ParticleTypes.field_197631_x);
                        flag.set(true);
                        break;
                    }
                    case HEALING: {
                        this.healEntity((PlayerEntity)playerEntity, (BeeAura)aura);
                        type.set(ParticleTypes.field_197632_y);
                        flag.set(true);
                        break;
                    }
                    case DAMAGING: {
                        this.damageEntity((PlayerEntity)playerEntity, (BeeAura)aura);
                        type.set(ParticleTypes.field_197614_g);
                        flag.set(true);
                        break;
                    }
                    case EXPERIENCE: {
                        this.giveExperience((PlayerEntity)playerEntity, (BeeAura)aura);
                        type.set(ParticleTypes.field_197623_p);
                        flag.set(true);
                        break;
                    }
                    case EXPERIENCE_DRAIN: {
                        this.removeExperience((PlayerEntity)playerEntity, (BeeAura)aura);
                        type.set(ParticleTypes.field_197598_I);
                        flag.set(true);
                        break;
                    }
                }
                if (Boolean.TRUE.equals(flag.get())) {
                    this.spawnParticles((LivingEntity)playerEntity, (IParticleData)type.get());
                }
            });
            if (Boolean.TRUE.equals(flag.get())) {
                this.spawnParticles((LivingEntity)this.entity, (IParticleData)type.get());
            }
        });
    }

    private void removeExperience(PlayerEntity playerEntity, BeeAura aura) {
        if (playerEntity.field_70170_p.field_72995_K) {
            return;
        }
        playerEntity.func_195068_e(-aura.getExperience());
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)playerEntity;
        serverPlayer.field_71135_a.func_147359_a((IPacket)new SPlaySoundPacket(SoundEvents.field_219642_eu.func_187503_a(), playerEntity.func_184176_by(), playerEntity.func_242282_l(0.0f), 0.1f, (this.random.nextFloat() - this.random.nextFloat()) * 0.35f + 0.9f));
    }

    private void giveExperience(PlayerEntity playerEntity, BeeAura aura) {
        if (playerEntity.field_70170_p.field_72995_K) {
            return;
        }
        playerEntity.func_195068_e(aura.getExperience());
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)playerEntity;
        serverPlayer.field_71135_a.func_147359_a((IPacket)new SPlaySoundPacket(SoundEvents.field_187604_bf.func_187503_a(), playerEntity.func_184176_by(), playerEntity.func_242282_l(0.0f), 0.1f, (this.random.nextFloat() - this.random.nextFloat()) * 0.35f + 0.9f));
    }

    private void damageEntity(PlayerEntity playerEntity, BeeAura aura) {
        DamageUtils.dealDamage(aura.getDamage(), aura.damageType, (LivingEntity)playerEntity, (LivingEntity)this.entity);
    }

    private void healEntity(PlayerEntity playerEntity, BeeAura aura) {
        playerEntity.func_70691_i((float)aura.getHealing());
    }

    private void burnEntity(PlayerEntity playerEntity) {
        playerEntity.func_241209_g_(200);
    }

    private void grantPotion(PlayerEntity playerEntity, BeeAura aura) {
        playerEntity.func_195064_c(aura.getInstance(200));
    }

    protected void spawnParticles(LivingEntity livingEntity, IParticleData particleType) {
        float power = 0.1f;
        if (particleType.equals(ParticleTypes.field_197623_p)) {
            power = 1.0f;
        } else if (particleType.equals(ParticleTypes.field_197614_g)) {
            power = 0.5f;
        }
        if (!this.entity.field_70170_p.func_201670_d()) {
            ServerWorld worldServer = (ServerWorld)this.entity.field_70170_p;
            double d0 = worldServer.field_73012_v.nextGaussian() * 0.1;
            double d1 = worldServer.field_73012_v.nextGaussian() * 0.1;
            double d2 = worldServer.field_73012_v.nextGaussian() * 0.1;
            worldServer.func_195598_a(particleType, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_() + (double)livingEntity.func_213302_cg() + 0.1, livingEntity.func_226281_cx_(), 5, d0, d1, d2, (double)power);
        }
    }
}

