/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.data;

import com.resourcefulbees.resourcefulbees.ResourcefulBees;
import com.resourcefulbees.resourcefulbees.api.IBeeRegistry;
import com.resourcefulbees.resourcefulbees.api.beedata.CentrifugeData;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.api.honeydata.HoneyBottleData;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.recipe.CentrifugeRecipe;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import com.resourcefulbees.resourcefulbees.utils.validation.SecondPhaseValidator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class RecipeBuilder
implements IResourceManagerReloadListener {
    private static RecipeManager recipeManager;
    private static final IBeeRegistry BEE_REGISTRY;

    private static void setRecipeManager(RecipeManager recipeManager) {
        RecipeBuilder.recipeManager = recipeManager;
    }

    public void func_195410_a(@NotNull IResourceManager resourceManager) {
        ResourcefulBees.LOGGER.info("Loading comb recipes for {} bees...", (Object)BEE_REGISTRY.getBees().size());
        BEE_REGISTRY.getBees().forEach((s, customBeeData) -> {
            if (customBeeData.hasHoneycomb()) {
                CentrifugeData centrifugeData = customBeeData.getCentrifugeData();
                centrifugeData.init();
                if (centrifugeData.hasCentrifugeOutput() && ((Boolean)Config.CENTRIFUGE_RECIPES.get()).booleanValue()) {
                    SecondPhaseValidator.validateCentrifugeOutputs(customBeeData);
                    if (centrifugeData.hasCentrifugeOutput()) {
                        ResourcefulBees.LOGGER.debug("Starting recipe registration for bee: {}", (Object)customBeeData.getName());
                        IRecipe<?> honeycombCentrifuge = this.centrifugeRecipe((String)s, (CustomBeeData)customBeeData, 1);
                        IRecipe<?> honeycombBlockCentrifuge = this.centrifugeRecipe((String)s, (CustomBeeData)customBeeData, 9);
                        IRecipe<?> honeycombCentrifugeNoBottle = this.centrifugeRecipeNoBottle((String)s, (CustomBeeData)customBeeData, 1);
                        IRecipe<?> honeycombBlockCentrifugeNoBottle = this.centrifugeRecipeNoBottle((String)s, (CustomBeeData)customBeeData, 9);
                        RecipeBuilder.getRecipeManager().field_199522_d.computeIfAbsent(honeycombCentrifuge.func_222127_g(), t -> new HashMap()).put(honeycombCentrifuge.func_199560_c(), honeycombCentrifuge);
                        RecipeBuilder.getRecipeManager().field_199522_d.computeIfAbsent(honeycombBlockCentrifuge.func_222127_g(), t -> new HashMap()).put(honeycombBlockCentrifuge.func_199560_c(), honeycombBlockCentrifuge);
                        if (honeycombBlockCentrifugeNoBottle != null && honeycombCentrifugeNoBottle != null) {
                            RecipeBuilder.getRecipeManager().field_199522_d.computeIfAbsent(honeycombCentrifugeNoBottle.func_222127_g(), t -> new HashMap()).put(honeycombCentrifugeNoBottle.func_199560_c(), honeycombCentrifugeNoBottle);
                            RecipeBuilder.getRecipeManager().field_199522_d.computeIfAbsent(honeycombBlockCentrifugeNoBottle.func_222127_g(), t -> new HashMap()).put(honeycombBlockCentrifugeNoBottle.func_199560_c(), honeycombBlockCentrifugeNoBottle);
                        }
                    }
                }
                if (((Boolean)Config.HONEYCOMB_BLOCK_RECIPES.get()).booleanValue() && !customBeeData.hasCustomDrop()) {
                    IRecipe<?> honeycombBlock = this.makeHoneycombRecipe((String)s, (CustomBeeData)customBeeData);
                    IRecipe<?> honeycomb = this.combBlockToCombRecipe((String)s, (CustomBeeData)customBeeData);
                    RecipeBuilder.getRecipeManager().field_199522_d.computeIfAbsent(honeycombBlock.func_222127_g(), t -> new HashMap()).put(honeycombBlock.func_199560_c(), honeycombBlock);
                    RecipeBuilder.getRecipeManager().field_199522_d.computeIfAbsent(honeycomb.func_222127_g(), t -> new HashMap()).put(honeycomb.func_199560_c(), honeycomb);
                }
            }
        });
        if (((Boolean)Config.HONEY_BLOCK_RECIPES.get()).booleanValue() && ((Boolean)Config.HONEY_GENERATE_BLOCKS.get()).booleanValue()) {
            BEE_REGISTRY.getHoneyBottles().forEach((s, honeyData) -> {
                SecondPhaseValidator.validateHoneyEffects(honeyData);
                if (honeyData.doGenerateHoneyBlock() && honeyData.doHoneyBlockRecipe()) {
                    IRecipe<?> honeyBlock = this.makeHoneyBlockRecipe((HoneyBottleData)honeyData);
                    IRecipe<?> honeyBottle = this.makeHoneyBottleRecipe((HoneyBottleData)honeyData);
                    IRecipe<?> bottleToBucket = this.makeBottleToBucketRecipe((HoneyBottleData)honeyData);
                    IRecipe<?> bucketToBottle = this.makeBucketToBottleRecipe((HoneyBottleData)honeyData);
                    IRecipe<?> blockToBucket = this.makeBlockToBucketRecipe((HoneyBottleData)honeyData);
                    IRecipe<?> bucketToBlock = this.makeBucketToBlockRecipe((HoneyBottleData)honeyData);
                    this.getBottleRecipes(honeyBlock, honeyBottle, bottleToBucket);
                    this.getBottleRecipes(bucketToBottle, blockToBucket, bucketToBlock);
                }
            });
        }
    }

    public void getBottleRecipes(IRecipe<?> recipe, IRecipe<?> recipe1, IRecipe<?> recipe2) {
        RecipeBuilder.getRecipeManager().field_199522_d.computeIfAbsent(recipe.func_222127_g(), t -> new HashMap()).put(recipe.func_199560_c(), recipe);
        RecipeBuilder.getRecipeManager().field_199522_d.computeIfAbsent(recipe1.func_222127_g(), t -> new HashMap()).put(recipe1.func_199560_c(), recipe1);
        RecipeBuilder.getRecipeManager().field_199522_d.computeIfAbsent(recipe2.func_222127_g(), t -> new HashMap()).put(recipe2.func_199560_c(), recipe2);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)this);
        RecipeBuilder.setRecipeManager(event.getDataPackRegistries().func_240967_e_());
        ResourcefulBees.LOGGER.info("Adding Reload Listener: 'resourcefulbees recipe manager'");
    }

    private IRecipe<?> makeHoneycombRecipe(String beeType, CustomBeeData info) {
        Ingredient honeycombItem = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)info.getCombRegistryObject().get()});
        return new ShapedRecipe(new ResourceLocation("resourcefulbees", beeType + "_honeycomb_block"), "", 3, 3, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{honeycombItem, honeycombItem, honeycombItem, honeycombItem, honeycombItem, honeycombItem, honeycombItem, honeycombItem, honeycombItem}), new ItemStack((IItemProvider)info.getCombBlockItemRegistryObject().get()));
    }

    private IRecipe<?> makeHoneyBlockRecipe(HoneyBottleData info) {
        Ingredient honeyBottleItem = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)info.getHoneyBottleRegistryObject().get()});
        return new ShapedRecipe(new ResourceLocation("resourcefulbees", info.getName() + "_honey_block"), "", 2, 2, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{honeyBottleItem, honeyBottleItem, honeyBottleItem, honeyBottleItem}), new ItemStack((IItemProvider)info.getHoneyBlockItemRegistryObject().get()));
    }

    private IRecipe<?> makeBottleToBucketRecipe(HoneyBottleData info) {
        Ingredient honeyBottleItem = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)info.getHoneyBottleRegistryObject().get()});
        Ingredient bucketItem = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151133_ar});
        return new ShapelessRecipe(new ResourceLocation("resourcefulbees", info.getName() + "_bottle_to_bucket"), "", new ItemStack((IItemProvider)info.getHoneyBucketItemRegistryObject().get()), NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{bucketItem, honeyBottleItem, honeyBottleItem, honeyBottleItem, honeyBottleItem}));
    }

    private IRecipe<?> makeBucketToBottleRecipe(HoneyBottleData info) {
        Ingredient honeyBucketItem = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)info.getHoneyBucketItemRegistryObject().get()});
        Ingredient bottleItem = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151069_bo});
        return new ShapelessRecipe(new ResourceLocation("resourcefulbees", info.getName() + "_bucket_to_bottle"), "", new ItemStack((IItemProvider)info.getHoneyBottleRegistryObject().get(), 4), NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{bottleItem, bottleItem, bottleItem, bottleItem, honeyBucketItem}));
    }

    private IRecipe<?> makeBlockToBucketRecipe(HoneyBottleData info) {
        Ingredient honeyBlockItem = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)info.getHoneyBlockItemRegistryObject().get()});
        Ingredient bucketItem = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151133_ar});
        return new ShapelessRecipe(new ResourceLocation("resourcefulbees", info.getName() + "_block_to_bucket"), "", new ItemStack((IItemProvider)info.getHoneyBucketItemRegistryObject().get()), NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{honeyBlockItem, bucketItem}));
    }

    private IRecipe<?> makeBucketToBlockRecipe(HoneyBottleData info) {
        Ingredient honeyBucketItem = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)info.getHoneyBucketItemRegistryObject().get()});
        return new ShapelessRecipe(new ResourceLocation("resourcefulbees", info.getName() + "_bucket_to_block"), "", new ItemStack((IItemProvider)info.getHoneyBlockItemRegistryObject().get()), NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{honeyBucketItem}));
    }

    private IRecipe<?> makeHoneyBottleRecipe(HoneyBottleData info) {
        Ingredient honeyBlockItem = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)info.getHoneyBlockItemRegistryObject().get()});
        Ingredient bottleItem = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151069_bo});
        return new ShapelessRecipe(new ResourceLocation("resourcefulbees", info.getName() + "_honey_bottle"), "", new ItemStack((IItemProvider)info.getHoneyBottleRegistryObject().get(), 4), NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{honeyBlockItem, bottleItem, bottleItem, bottleItem, bottleItem}));
    }

    private IRecipe<?> centrifugeRecipeNoBottle(String beeType, CustomBeeData info, int multiplier) {
        ResourceLocation recipeLoc;
        CentrifugeData data = info.getCentrifugeData();
        boolean isBlockRecipe = multiplier > 1;
        ItemStack mainOutput = data.isMainIsFluidOutput() ? ItemStack.field_190927_a : new ItemStack((IItemProvider)BeeInfoUtils.getItem(data.getMainOutput()), data.getMainOutputCount() * multiplier);
        ItemStack secondaryOutput = new ItemStack((IItemProvider)BeeInfoUtils.getItem(data.getSecondaryOutput()), data.getSecondaryOutputCount() * multiplier);
        ItemStack bottleOutput = new ItemStack((IItemProvider)BeeInfoUtils.getItem(data.getBottleOutput()), data.getBottleOutputCount() * multiplier);
        FluidStack fluidOutput = data.hasFluidOutput() ? new FluidStack(BeeInfoUtils.getFluid(data.getFluidOutput()), data.getFluidOutputCount() * multiplier) : FluidStack.EMPTY;
        mainOutput.func_77982_d(data.getMainNBT());
        secondaryOutput.func_77982_d(data.getSecondaryNBT());
        bottleOutput.func_77982_d(data.getBottleNBT());
        FluidStack bottleFluid = new FluidStack(BeeInfoUtils.getFluidFromBottle(bottleOutput), 250 * multiplier);
        ResourceLocation resourceLocation = recipeLoc = isBlockRecipe ? new ResourceLocation("resourcefulbees", beeType + "_honeycomb_block_centrifuge_no_bottle") : new ResourceLocation("resourcefulbees", beeType + "_honeycomb_centrifuge_no_bottle");
        if (bottleFluid.isEmpty()) {
            return null;
        }
        return new CentrifugeRecipe(recipeLoc, isBlockRecipe ? Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)info.getCombBlockRegistryObject().get(), data.getMainInputCount())}) : Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)info.getCombRegistryObject().get(), data.getMainInputCount())}), (List<Pair<ItemStack, Float>>)NonNullList.func_193580_a((Object)Pair.of((Object)ItemStack.field_190927_a, (Object)Float.valueOf(0.0f)), (Object[])new Pair[]{Pair.of((Object)mainOutput, (Object)Float.valueOf(data.getMainOutputWeight())), Pair.of((Object)secondaryOutput, (Object)Float.valueOf(data.getSecondaryOutputWeight()))}), (List<Pair<FluidStack, Float>>)NonNullList.func_193580_a((Object)Pair.of((Object)FluidStack.EMPTY, (Object)Float.valueOf(0.0f)), (Object[])new Pair[]{Pair.of((Object)fluidOutput, (Object)Float.valueOf(data.getFluidOutputWeight())), Pair.of((Object)bottleFluid, (Object)Float.valueOf(data.getBottleOutputWeight()))}), data.getRecipeTime(), (data.getRecipeTime() - (Integer)Config.MULTIBLOCK_RECIPE_TIME_REDUCTION.get()) * (isBlockRecipe ? 3 : 1), isBlockRecipe, data.hasFluidOutput(), true);
    }

    private IRecipe<?> centrifugeRecipe(String beeType, CustomBeeData info, int multiplier) {
        CentrifugeData data = info.getCentrifugeData();
        boolean isBlockRecipe = multiplier > 1;
        ItemStack mainOutput = data.isMainIsFluidOutput() ? ItemStack.field_190927_a : new ItemStack((IItemProvider)BeeInfoUtils.getItem(data.getMainOutput()), data.getMainOutputCount() * multiplier);
        ItemStack secondaryOutput = new ItemStack((IItemProvider)BeeInfoUtils.getItem(data.getSecondaryOutput()), data.getSecondaryOutputCount() * multiplier);
        ItemStack bottleOutput = new ItemStack((IItemProvider)BeeInfoUtils.getItem(data.getBottleOutput()), data.getBottleOutputCount() * multiplier);
        FluidStack fluidOutput = data.hasFluidOutput() ? new FluidStack(BeeInfoUtils.getFluid(data.getFluidOutput()), data.getFluidOutputCount() * multiplier) : FluidStack.EMPTY;
        mainOutput.func_77982_d(data.getMainNBT());
        secondaryOutput.func_77982_d(data.getSecondaryNBT());
        bottleOutput.func_77982_d(data.getBottleNBT());
        ResourceLocation recipeLoc = isBlockRecipe ? new ResourceLocation("resourcefulbees", beeType + "_honeycomb_block_centrifuge") : new ResourceLocation("resourcefulbees", beeType + "_honeycomb_centrifuge");
        return new CentrifugeRecipe(recipeLoc, isBlockRecipe ? Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)info.getCombBlockRegistryObject().get(), data.getMainInputCount())}) : Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)info.getCombRegistryObject().get(), data.getMainInputCount())}), (List<Pair<ItemStack, Float>>)NonNullList.func_193580_a((Object)Pair.of((Object)ItemStack.field_190927_a, (Object)Float.valueOf(0.0f)), (Object[])new Pair[]{Pair.of((Object)mainOutput, (Object)Float.valueOf(data.getMainOutputWeight())), Pair.of((Object)secondaryOutput, (Object)Float.valueOf(data.getSecondaryOutputWeight())), Pair.of((Object)bottleOutput, (Object)Float.valueOf(data.getBottleOutputWeight()))}), (List<Pair<FluidStack, Float>>)NonNullList.func_193580_a((Object)Pair.of((Object)FluidStack.EMPTY, (Object)Float.valueOf(0.0f)), (Object[])new Pair[]{Pair.of((Object)fluidOutput, (Object)Float.valueOf(data.getFluidOutputWeight()))}), data.getRecipeTime(), (data.getRecipeTime() - (Integer)Config.MULTIBLOCK_RECIPE_TIME_REDUCTION.get()) * (isBlockRecipe ? 3 : 1), isBlockRecipe, data.hasFluidOutput(), false);
    }

    private IRecipe<?> combBlockToCombRecipe(String beeType, CustomBeeData info) {
        return new ShapelessRecipe(new ResourceLocation("resourcefulbees", beeType + "_block_to_honeycomb"), "", new ItemStack((IItemProvider)info.getCombRegistryObject().get(), 9), NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)info.getCombBlockItemRegistryObject().get())})}));
    }

    public static RecipeManager getRecipeManager() {
        if (!RecipeBuilder.recipeManager.field_199522_d.getClass().equals(HashMap.class)) {
            RecipeBuilder.recipeManager.field_199522_d = new HashMap(RecipeBuilder.recipeManager.field_199522_d);
            RecipeBuilder.recipeManager.field_199522_d.replaceAll((t, v) -> new HashMap((Map)RecipeBuilder.recipeManager.field_199522_d.get(t)));
        }
        return recipeManager;
    }

    static {
        BEE_REGISTRY = BeeRegistry.getRegistry();
    }
}

