/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.resourcefulbees.resourcefulbees.data.DataGen;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataPackLoader
implements IPackFinder {
    private static final String DATAPACK_NAME = "resourcefulbees:internals";
    public static final DataPackLoader INSTANCE = new DataPackLoader();
    private static final Gson GSON = new Gson();

    public void func_230230_a_(@NotNull Consumer<ResourcePackInfo> packList, @NotNull ResourcePackInfo.IFactory factory) {
        try (MemoryDataPack dataPack = new MemoryDataPack();){
            DataGen.getTags().forEach((location, resourceLocations) -> {
                ITag.Builder builder = ITag.Builder.func_200047_a();
                resourceLocations.forEach(t -> builder.func_232961_a_(t, DATAPACK_NAME));
                dataPack.putJson(ResourcePackType.SERVER_DATA, (ResourceLocation)location, (JsonElement)builder.func_232965_c_());
            });
            ResourcePackInfo pack = ResourcePackInfo.func_195793_a((String)DATAPACK_NAME, (boolean)true, () -> dataPack, (ResourcePackInfo.IFactory)factory, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.BOTTOM, (IPackNameDecorator)IPackNameDecorator.field_232626_b_);
            packList.accept(pack);
        }
    }

    private static class MemoryDataPack
    implements IResourcePack {
        private static final JsonObject meta = new JsonObject();
        private final HashMap<ResourceLocation, Supplier<? extends InputStream>> assets = new HashMap();
        private final HashMap<ResourceLocation, Supplier<? extends InputStream>> data = new HashMap();

        private MemoryDataPack() {
        }

        @Nullable
        private HashMap<ResourceLocation, Supplier<? extends InputStream>> getResourcePackTypeMap(ResourcePackType type) {
            if (type.equals((Object)ResourcePackType.CLIENT_RESOURCES)) {
                return this.assets;
            }
            if (type.equals((Object)ResourcePackType.SERVER_DATA)) {
                return this.data;
            }
            return null;
        }

        public void putJson(ResourcePackType type, ResourceLocation location, JsonElement json) {
            HashMap<ResourceLocation, Supplier<? extends InputStream>> map = this.getResourcePackTypeMap(type);
            if (map != null) {
                map.put(location, () -> new ByteArrayInputStream(GSON.toJson(json).getBytes(StandardCharsets.UTF_8)));
            }
        }

        @NotNull
        public InputStream func_195763_b(@NotNull String file) throws IOException {
            if (file.contains("/") || file.contains("\\")) {
                throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
            }
            throw new FileNotFoundException(file);
        }

        @NotNull
        public InputStream func_195761_a(@NotNull ResourcePackType type, @NotNull ResourceLocation location) throws IOException {
            HashMap<ResourceLocation, Supplier<? extends InputStream>> map = this.getResourcePackTypeMap(type);
            if (map != null && map.containsKey(location)) {
                return (InputStream)((Supplier)map.get(location)).get();
            }
            throw new FileNotFoundException(location.toString());
        }

        @NotNull
        public Collection<ResourceLocation> func_225637_a_(@NotNull ResourcePackType type, @NotNull String namespace, @NotNull String path, int maxFolderWalk, @NotNull Predicate<String> predicate) {
            HashMap<ResourceLocation, Supplier<? extends InputStream>> map = this.getResourcePackTypeMap(type);
            if (map == null) {
                return Collections.emptyList();
            }
            return map.keySet().stream().filter(location -> location.func_110624_b().equals(namespace)).filter(location -> location.func_110623_a().split("/").length < maxFolderWalk).filter(location -> location.func_110623_a().startsWith(path)).filter(location -> predicate.test(location.func_110623_a().substring(Math.max(location.func_110623_a().lastIndexOf(47), 0)))).collect(Collectors.toList());
        }

        public boolean func_195764_b(@NotNull ResourcePackType type, @NotNull ResourceLocation location) {
            HashMap<ResourceLocation, Supplier<? extends InputStream>> map = this.getResourcePackTypeMap(type);
            return map != null && map.containsKey(location);
        }

        @NotNull
        public Set<String> func_195759_a(@NotNull ResourcePackType type) {
            HashMap<ResourceLocation, Supplier<? extends InputStream>> map = this.getResourcePackTypeMap(type);
            if (map == null) {
                return Collections.emptySet();
            }
            return map.keySet().stream().map(ResourceLocation::func_110624_b).collect(Collectors.toSet());
        }

        @Nullable
        public <T> T func_195760_a(@NotNull IMetadataSectionSerializer<T> serializer) {
            return (T)serializer.func_195812_a(meta);
        }

        @NotNull
        public String func_195762_a() {
            return DataPackLoader.DATAPACK_NAME;
        }

        public boolean isHidden() {
            return true;
        }

        public void close() {
        }

        static {
            meta.add("pack_format", (JsonElement)new JsonPrimitive((Number)4));
            meta.add("description", (JsonElement)new JsonPrimitive("Data for resourcefulbees tags."));
        }
    }
}

