/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.data;

import com.resourcefulbees.resourcefulbees.ResourcefulBees;
import com.resourcefulbees.resourcefulbees.api.IBeeRegistry;
import com.resourcefulbees.resourcefulbees.api.honeydata.HoneyBottleData;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.init.BeeSetup;
import com.resourcefulbees.resourcefulbees.mixin.BlockAccessor;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.registry.ModEntities;
import com.resourcefulbees.resourcefulbees.registry.TraitRegistry;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public class DataGen {
    private static final IBeeRegistry BEE_REGISTRY = BeeRegistry.getRegistry();
    private static final String ITEM_RESOURCEFULBEES = "item.resourcefulbees.";
    private static final Map<ResourceLocation, Set<ResourceLocation>> TAGS = new HashMap<ResourceLocation, Set<ResourceLocation>>();

    private DataGen() {
        throw new IllegalStateException("Utility Class");
    }

    public static void generateClientData() {
        if (((Boolean)Config.GENERATE_ENGLISH_LANG.get()).equals(Boolean.TRUE)) {
            DataGen.generateEnglishLang();
        }
    }

    public static Map<ResourceLocation, Set<ResourceLocation>> getTags() {
        return Collections.unmodifiableMap(TAGS);
    }

    public static void generateCommonData() {
        DataGen.generateBeeTags();
        DataGen.generateCombBlockItemTags();
        DataGen.generateCombBlockTags();
        DataGen.generateCombItemTags();
        DataGen.generateValidApiaryTag();
        DataGen.generateHoneyBottleTags();
        if (((Boolean)Config.HONEY_GENERATE_BLOCKS.get()).equals(Boolean.TRUE)) {
            DataGen.generateHoneyBlockTags();
            DataGen.generateHoneyBlockItemTags();
        }
        if (((Boolean)Config.HONEY_GENERATE_FLUIDS.get()).equals(Boolean.TRUE)) {
            DataGen.generateHoneyTags();
        }
    }

    private static void writeFile(String path, String file, String data) throws IOException {
        Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
        try (FileWriter writer = new FileWriter(Paths.get(path, file).toFile());){
            writer.write(data);
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.error("context", (Throwable)e);
        }
    }

    private static void generateEnglishLang() {
        ResourcefulBees.LOGGER.info("Generating English Lang...");
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        BEE_REGISTRY.getBees().forEach((name, customBeeData) -> {
            String displayName = StringUtils.replace((String)name, (String)"_", (String)" ");
            displayName = WordUtils.capitalizeFully((String)displayName);
            DataGen.generateLangEntry(builder, "block.resourcefulbees.", name, "_honeycomb_block", displayName, "Honeycomb Block");
            DataGen.generateLangEntry(builder, ITEM_RESOURCEFULBEES, name, "_honeycomb", displayName, "Honeycomb");
            DataGen.generateLangEntry(builder, ITEM_RESOURCEFULBEES, name, "_bee_spawn_egg", displayName, "Bee Spawn Egg");
            DataGen.generateLangEntry(builder, "entity.resourcefulbees.", name, "_bee", displayName, "Bee");
        });
        BEE_REGISTRY.getHoneyBottles().forEach((name, honeyData) -> {
            String displayName = StringUtils.replace((String)name, (String)"_", (String)" ");
            displayName = WordUtils.capitalizeFully((String)displayName);
            DataGen.generateLangEntry(builder, ITEM_RESOURCEFULBEES, name, "_honey_bottle", displayName, "Honey Bottle");
            if (Boolean.TRUE.equals(Config.HONEY_GENERATE_BLOCKS.get()) && honeyData.doGenerateHoneyBlock()) {
                DataGen.generateLangEntry(builder, "block.resourcefulbees.", name, "_honey_block", displayName, "Honey Block");
            }
            if (Boolean.TRUE.equals(Config.HONEY_GENERATE_FLUIDS.get()) && honeyData.doGenerateHoneyFluid()) {
                DataGen.generateLangEntry(builder, ITEM_RESOURCEFULBEES, name, "_honey_fluid_bucket", displayName, "Honey Bucket");
                DataGen.generateLangEntry(builder, "fluid.resourcefulbees.", name, "_honey", displayName, "Honey");
            }
        });
        TraitRegistry.getRegistry().getTraits().forEach((name, trait) -> {
            String displayName = StringUtils.replace((String)name, (String)"_", (String)" ");
            displayName = WordUtils.capitalizeFully((String)displayName);
            builder.append(String.format("\"%s\" : \"%s\",%n", trait.getTranslationKey(), displayName));
        });
        builder.deleteCharAt(builder.lastIndexOf(","));
        builder.append("}");
        String langPath = BeeSetup.getResourcePath().toString() + "/assets/resourcefulbees/lang/";
        String langFile = "en_us.json";
        try {
            DataGen.writeFile(langPath, langFile, builder.toString());
            ResourcefulBees.LOGGER.info("Language File Generated!");
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.error("Could not generate language file!");
        }
    }

    private static void generateLangEntry(StringBuilder builder, String prefix, String name, String suffix, String displayName, String displaySuffix) {
        builder.append("\"");
        builder.append(prefix);
        builder.append(name);
        builder.append(suffix);
        builder.append("\": \"");
        builder.append(displayName);
        builder.append(" ");
        builder.append(displaySuffix);
        builder.append("\",\n");
    }

    private static void generateValidApiaryTag() {
        TAGS.put(new ResourceLocation("resourcefulbees", "tags/items/valid_apiary.json"), ForgeRegistries.BLOCKS.getValues().stream().filter(block -> ((BlockAccessor)block).getHasCollision()).map(Block::func_199767_j).filter(item -> item != Items.field_190931_a).map(ForgeRegistryEntry::getRegistryName).collect(Collectors.toSet()));
    }

    private static void generateCombItemTags() {
        TAGS.put(new ResourceLocation("resourcefulbees", "tags/items/resourceful_honeycomb.json"), BEE_REGISTRY.getBees().values().stream().filter(bee -> bee.hasHoneycomb() && !bee.hasCustomDrop()).map(bee -> bee.getCombRegistryObject().getId()).collect(Collectors.toSet()));
    }

    private static void generateCombBlockItemTags() {
        TAGS.put(new ResourceLocation("resourcefulbees", "tags/items/resourceful_honeycomb_block.json"), BEE_REGISTRY.getBees().values().stream().filter(bee -> bee.hasHoneycomb() && !bee.hasCustomDrop()).map(bee -> bee.getCombBlockItemRegistryObject().getId()).collect(Collectors.toSet()));
    }

    private static void generateCombBlockTags() {
        TAGS.put(new ResourceLocation("resourcefulbees", "tags/blocks/resourceful_honeycomb_block.json"), BEE_REGISTRY.getBees().values().stream().filter(bee -> bee.hasHoneycomb() && !bee.hasCustomDrop()).map(bee -> bee.getCombBlockRegistryObject().getId()).collect(Collectors.toSet()));
    }

    private static void generateHoneyBottleTags() {
        TAGS.put(new ResourceLocation("resourcefulbees", "tags/items/resourceful_honey_bottle.json"), BEE_REGISTRY.getHoneyBottles().values().stream().filter(HoneyBottleData::doGenerateHoneyBlock).map(honey -> honey.getHoneyBottleRegistryObject().getId()).collect(Collectors.toSet()));
    }

    private static void generateHoneyBlockTags() {
        TAGS.put(new ResourceLocation("resourcefulbees", "tags/blocks/resourceful_honey_block.json"), BEE_REGISTRY.getHoneyBottles().values().stream().filter(HoneyBottleData::doGenerateHoneyBlock).map(honey -> honey.getHoneyBlockRegistryObject().getId()).collect(Collectors.toSet()));
    }

    private static void generateHoneyBlockItemTags() {
        TAGS.put(new ResourceLocation("resourcefulbees", "tags/items/resourceful_honey_block.json"), BEE_REGISTRY.getHoneyBottles().values().stream().filter(HoneyBottleData::doGenerateHoneyBlock).map(honey -> honey.getHoneyBlockItemRegistryObject().getId()).collect(Collectors.toSet()));
    }

    private static void generateBeeTags() {
        TAGS.put(new ResourceLocation("minecraft", "tags/entity_types/beehive_inhabitors.json"), ModEntities.getModBees().values().stream().map(RegistryObject::getId).collect(Collectors.toSet()));
    }

    private static void generateHoneyTags() {
        TAGS.put(new ResourceLocation("resourcefulbees", "tags/fluids/resourceful_honey.json"), BEE_REGISTRY.getHoneyBottles().values().stream().filter(HoneyBottleData::doGenerateHoneyFluid).flatMap(hbd -> Stream.of(hbd.getHoneyFlowingFluidRegistryObject().getId(), hbd.getHoneyStillFluidRegistryObject().getId())).collect(Collectors.toSet()));
    }
}

