/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.container;

import com.resourcefulbees.resourcefulbees.container.ContainerWithStackMove;
import com.resourcefulbees.resourcefulbees.container.OutputSlot;
import com.resourcefulbees.resourcefulbees.container.SlotItemHandlerUnconditioned;
import com.resourcefulbees.resourcefulbees.mixin.ContainerAccessor;
import com.resourcefulbees.resourcefulbees.registry.ModContainers;
import com.resourcefulbees.resourcefulbees.tileentity.HoneyGeneratorTileEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class HoneyGeneratorContainer
extends ContainerWithStackMove {
    private final HoneyGeneratorTileEntity honeyGeneratorTileEntity;
    private final PlayerEntity player;

    public HoneyGeneratorContainer(int id, World world, BlockPos pos, PlayerInventory inv) {
        super((ContainerType)ModContainers.HONEY_GENERATOR_CONTAINER.get(), id);
        this.player = inv.field_70458_d;
        this.honeyGeneratorTileEntity = (HoneyGeneratorTileEntity)world.func_175625_s(pos);
        if (this.honeyGeneratorTileEntity != null) {
            this.func_75146_a((Slot)new SlotItemHandlerUnconditioned(this.honeyGeneratorTileEntity.getTileStackHandler(), 0, 36, 20){

                @Override
                public boolean func_75214_a(ItemStack stack) {
                    return HoneyGeneratorContainer.this.honeyGeneratorTileEntity.getTileStackHandler().isItemValid(0, stack);
                }
            });
            this.func_75146_a((Slot)new OutputSlot((IItemHandler)this.honeyGeneratorTileEntity.getTileStackHandler(), 1, 36, 58));
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.func_75146_a(new Slot((IInventory)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
                }
            }
            for (int k = 0; k < 9; ++k) {
                this.func_75146_a(new Slot((IInventory)inv, k, 8 + k * 18, 142));
            }
        }
    }

    public int getEnergy() {
        return this.getHoneyGeneratorTileEntity().getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public int getFluidAmount() {
        return this.getHoneyGeneratorTileEntity().getFluidTank().getFluidAmount();
    }

    public int getMaxEnergy() {
        return this.getHoneyGeneratorTileEntity().getEnergyStorage().getMaxEnergyStored();
    }

    public int getMaxFluid() {
        return this.getHoneyGeneratorTileEntity().getFluidTank().getCapacity();
    }

    public int getTime() {
        return this.getHoneyGeneratorTileEntity().getFluidFilled();
    }

    public int getEnergyTime() {
        return this.getHoneyGeneratorTileEntity().getEnergyFilled();
    }

    public boolean func_75145_c(@NotNull PlayerEntity player) {
        return true;
    }

    @Override
    public int getContainerInputEnd() {
        return 1;
    }

    @Override
    public int getInventoryStart() {
        return 2;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.getHoneyGeneratorTileEntity() == null) {
            return;
        }
        for (IContainerListener listener : ((ContainerAccessor)((Object)this)).getListeners()) {
            this.getHoneyGeneratorTileEntity().sendGUINetworkPacket(listener);
        }
    }

    public HoneyGeneratorTileEntity getHoneyGeneratorTileEntity() {
        return this.honeyGeneratorTileEntity;
    }

    public PlayerEntity getPlayer() {
        return this.player;
    }
}

