/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.compat.top;

import com.resourcefulbees.resourcefulbees.tileentity.TieredBeehiveTileEntity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class TieredBeehiveDisplayOverride
implements IBlockDisplayOverride {
    public boolean overrideStandardInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, PlayerEntity playerEntity, World world, BlockState blockState, IProbeHitData iProbeHitData) {
        TileEntity tileEntity = world.func_175625_s(iProbeHitData.getPos());
        return tileEntity instanceof TieredBeehiveTileEntity && this.createHiveProbeData(probeMode, iProbeInfo, blockState, (TieredBeehiveTileEntity)tileEntity);
    }

    private boolean createHiveProbeData(ProbeMode mode, IProbeInfo probeInfo, BlockState blockState, TieredBeehiveTileEntity tileEntity) {
        probeInfo.horizontal().item(new ItemStack((IItemProvider)blockState.func_177230_c().func_199767_j())).vertical().itemLabel(new ItemStack((IItemProvider)blockState.func_177230_c().func_199767_j())).text(CompoundText.create().style(TextStyleClass.MODNAME).text("Resourceful Bees"));
        probeInfo.horizontal().vertical().text((ITextComponent)new TranslationTextComponent("gui.resourcefulbees.beehive.tier").func_240702_b_(this.getHiveTier(tileEntity))).text((ITextComponent)new TranslationTextComponent("gui.resourcefulbees.beehive.bees").func_240702_b_(this.getHiveBeeCount(tileEntity)).func_240702_b_(" / ").func_240702_b_(this.getHiveMaxBees(tileEntity))).text((ITextComponent)new TranslationTextComponent("gui.resourcefulbees.beehive.honeylevel").func_240702_b_(this.getHoneyLevel(tileEntity))).text((ITextComponent)new TranslationTextComponent("gui.resourcefulbees.beehive.smoked").func_240702_b_(this.getSmokedStatus(tileEntity)));
        this.createSmokedProbeData(probeInfo, tileEntity);
        if (mode.equals((Object)ProbeMode.EXTENDED)) {
            this.createHoneycombData(probeInfo, tileEntity);
        }
        return true;
    }

    private String getHiveMaxBees(TieredBeehiveTileEntity tileEntity) {
        return String.valueOf(tileEntity.getMaxBees());
    }

    @NotNull
    private String getHiveBeeCount(TieredBeehiveTileEntity tileEntity) {
        return String.valueOf(tileEntity.func_226971_j_());
    }

    @NotNull
    private String getSmokedStatus(TieredBeehiveTileEntity tileEntity) {
        return String.valueOf(tileEntity.func_226972_k_());
    }

    @NotNull
    private String getHiveTier(TieredBeehiveTileEntity tileEntity) {
        return String.valueOf(tileEntity.getTier());
    }

    private String getHoneyLevel(TieredBeehiveTileEntity tileEntity) {
        return String.valueOf(tileEntity.func_195044_w().func_177229_b((Property)BeehiveBlock.field_226873_c_));
    }

    private void createHoneycombData(IProbeInfo probeInfo, TieredBeehiveTileEntity tileEntity) {
        if (tileEntity.hasCombs()) {
            ArrayList<ItemStack> combs = new ArrayList<ItemStack>();
            this.buildHoneycombList(tileEntity, combs);
            IProbeInfo vertical = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(-16750951)).spacing(0));
            AtomicReference<IProbeInfo> horizontal = new AtomicReference<IProbeInfo>(vertical.horizontal(probeInfo.defaultLayoutStyle().spacing(10).alignment(ElementAlignment.ALIGN_CENTER)));
            if (combs.size() <= 4) {
                combs.forEach(honeycomb -> this.formatHoneycombData(probeInfo, vertical, horizontal, (ItemStack)honeycomb));
            } else {
                AtomicInteger columnCount = new AtomicInteger();
                combs.forEach(honeycomb -> this.formatHoneycombData(probeInfo, vertical, horizontal, columnCount, (ItemStack)honeycomb));
            }
        }
    }

    private void formatHoneycombData(IProbeInfo probeInfo, IProbeInfo vertical, AtomicReference<IProbeInfo> horizontal, AtomicInteger columnCount, ItemStack honeycomb) {
        if (columnCount.get() == 7) {
            horizontal.set(vertical.horizontal(probeInfo.defaultLayoutStyle().spacing(10).alignment(ElementAlignment.ALIGN_CENTER)));
            columnCount.set(0);
        }
        horizontal.get().item(honeycomb);
        columnCount.incrementAndGet();
    }

    private void formatHoneycombData(IProbeInfo probeInfo, IProbeInfo vertical, AtomicReference<IProbeInfo> horizontal, ItemStack honeycomb) {
        horizontal.set(vertical.horizontal(probeInfo.defaultLayoutStyle().spacing(10).alignment(ElementAlignment.ALIGN_CENTER)));
        horizontal.get().item(honeycomb).text(honeycomb.func_200301_q());
    }

    private void buildHoneycombList(TieredBeehiveTileEntity tileEntity, List<ItemStack> combs) {
        tileEntity.getHoneycombs().iterator().forEachRemaining(honeycomb -> {
            ItemStack comb = honeycomb.func_77946_l();
            Iterator iterator = combs.iterator();
            while (iterator.hasNext() && !comb.func_190926_b()) {
                ItemStack stackInList = (ItemStack)iterator.next();
                if (!Container.func_195929_a((ItemStack)comb, (ItemStack)stackInList)) continue;
                ((ItemStack)combs.get(combs.indexOf(stackInList))).func_190917_f(1);
                comb.func_190920_e(0);
            }
            if (!comb.func_190926_b()) {
                combs.add(comb);
            }
        });
    }

    private void createSmokedProbeData(IProbeInfo probeInfo, TieredBeehiveTileEntity tileEntity) {
        if (tileEntity.getTicksSmoked() != -1) {
            probeInfo.horizontal().vertical().text((ITextComponent)new StringTextComponent(new TranslationTextComponent("gui.resourcefulbees.beehive.smoke_time").getString())).progress((int)Math.floor((double)tileEntity.getTicksSmoked() / 20.0), 30);
        }
    }
}

