/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.compat.patchouli;

import com.google.gson.JsonElement;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.resourcefulbees.resourcefulbees.client.render.InterfaceBeeRenderer;
import com.resourcefulbees.resourcefulbees.client.render.patreon.LayerData;
import com.resourcefulbees.resourcefulbees.client.render.patreon.PetModelData;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;

public class RenderInterfaceBee
implements ICustomComponent {
    IVariable geoPath;
    IVariable texturePath;
    IVariable layers;
    IVariable scale;
    private transient PetModelData bee;
    private transient float modelScale;
    private transient int xOffset;
    private transient int yOffset;
    private final InterfaceBeeRenderer renderer = new InterfaceBeeRenderer();

    public void build(int x, int y, int page) {
        this.xOffset = x;
        this.yOffset = y;
    }

    public void render(@NotNull MatrixStack matrix, @NotNull IComponentRenderContext context, float partialTicks, int mouseX, int mouseY) {
        this.renderer.render(this.bee, matrix, partialTicks, context.getTicksInBook(), this.xOffset, this.yOffset, this.modelScale, 135.0f);
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        this.geoPath = (IVariable)lookup.apply(this.geoPath);
        this.texturePath = (IVariable)lookup.apply(this.texturePath);
        this.layers = (IVariable)lookup.apply(this.layers);
        this.scale = (IVariable)lookup.apply(this.scale);
        String tex = this.texturePath.asString();
        String geo = this.geoPath.asString();
        JsonElement element = this.layers.unwrap();
        LinkedHashSet<LayerData> vars = element.isJsonArray() ? this.layers.asStream().map(v -> LayerData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)v.unwrap()).result()).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet()) : new LinkedHashSet<LayerData>();
        this.bee = new PetModelData(0, "UI", new ResourceLocation(geo), new ResourceLocation(tex), vars);
        this.modelScale = this.scale.asNumber().floatValue();
    }
}

