/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.compat.patchouli;

import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ProcessorPotionRecipe
implements IComponentProcessor {
    private BrewingRecipe mix = null;
    private BrewingRecipe mix2 = null;
    String text;
    private IVariable hidden;

    public void setup(IVariableProvider lookup) {
        if (lookup.has("potion") && lookup.has("stack")) {
            IVariable potionID = lookup.get("potion");
            IVariable stackID = lookup.get("stack");
            Potion potion = (Potion)ForgeRegistries.POTION_TYPES.getValue(new ResourceLocation(potionID.asString()));
            ItemStack stack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(stackID.asString())));
            this.mix = BeeInfoUtils.getMix(potion, stack);
        }
        if (lookup.has("potion2") && lookup.has("stack2")) {
            IVariable potionID2 = lookup.get("potion2");
            IVariable stackID2 = lookup.get("stack2");
            Potion potion2 = (Potion)ForgeRegistries.POTION_TYPES.getValue(new ResourceLocation(potionID2.asString()));
            ItemStack stack2 = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(stackID2.asString())));
            this.mix2 = BeeInfoUtils.getMix(potion2, stack2);
        }
        if (lookup.has("text")) {
            this.text = lookup.get("text").asString();
        }
        if (lookup.has("hidden")) {
            this.hidden = lookup.get("hidden");
        }
    }

    public IVariable process(String key) {
        switch (key) {
            case "mix": {
                return IVariable.wrap((Boolean)(this.mix != null ? 1 : 0));
            }
            case "mix2": {
                return IVariable.wrap((Boolean)(this.mix2 != null ? 1 : 0));
            }
            case "mix2null": {
                return IVariable.wrap((Boolean)(this.mix2 == null ? 1 : 0));
            }
            case "mixnull": {
                return IVariable.wrap((Boolean)(this.mix == null ? 1 : 0));
            }
            case "title": {
                if (this.mix != null) {
                    return IVariable.from((Object)this.mix.getOutput().func_200301_q());
                }
                return IVariable.empty();
            }
            case "input": {
                if (this.mix != null) {
                    return IVariable.from((Object)this.mix.getInput().func_193365_a());
                }
                return IVariable.empty();
            }
            case "output": {
                if (this.mix != null) {
                    return IVariable.from((Object)this.mix.getOutput());
                }
                return IVariable.empty();
            }
            case "ingredient": {
                if (this.mix != null) {
                    return IVariable.from((Object)this.mix.getIngredient().func_193365_a());
                }
                return IVariable.empty();
            }
            case "title2": {
                if (this.mix2 != null) {
                    return IVariable.from((Object)this.mix2.getOutput().func_200301_q());
                }
                return IVariable.empty();
            }
            case "input2": {
                if (this.mix2 != null) {
                    return IVariable.from((Object)this.mix2.getInput().func_193365_a());
                }
                return IVariable.empty();
            }
            case "output2": {
                if (this.mix2 != null) {
                    return IVariable.from((Object)this.mix2.getOutput());
                }
                return IVariable.empty();
            }
            case "ingredient2": {
                if (this.mix2 != null) {
                    return IVariable.from((Object)this.mix2.getIngredient().func_193365_a());
                }
                return IVariable.empty();
            }
            case "stand": 
            case "stand2": {
                return IVariable.from((Object)new ItemStack((IItemProvider)Items.field_222088_mr));
            }
            case "background2": 
            case "background": {
                return IVariable.wrap((String)"textures/gui/patchouli/brewing_stand.png");
            }
            case "hidden": {
                return this.hidden;
            }
            case "text": {
                return IVariable.wrap((String)this.text);
            }
        }
        return IVariable.empty();
    }

    public boolean allowRender(String group) {
        return !"hidden".equals(group);
    }
}

