/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.compat.patchouli;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;

public class ListBeesComponent
implements ICustomComponent {
    transient float defaultRotation = -45.0f;
    transient float renderScale;
    transient float offset;
    transient int page;
    transient int pageCount;
    transient Button nextPage;
    transient Button prevPage;
    transient int xOffset;
    transient int yOffset;
    transient List<Pair<EntityType<?>, Optional<Entity>>> bees = new LinkedList();

    public void build(int xOffset, int yOffset, int page) {
        BeeRegistry.getRegistry().getBees().forEach((s, b) -> this.bees.add(Pair.of((Object)ForgeRegistries.ENTITIES.getValue(b.getEntityTypeRegistryID()), Optional.empty())));
        this.pageCount = this.bees.size();
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public void render(@NotNull MatrixStack matrixStack, @NotNull IComponentRenderContext context, float partialTicks, int mouseX, int mouseY) {
        this.prevPage.field_230693_o_ = this.page != 0;
        this.nextPage.field_230693_o_ = this.page != this.pageCount;
        this.renderEntity(matrixStack, context, this.page);
    }

    private void renderEntity(MatrixStack matrixStack, IComponentRenderContext context, int page) {
        Pair<EntityType<?>, Optional<Entity>> bee = this.bees.get(page);
        Optional entityOptional = (Optional)bee.getRight();
        if (entityOptional.isPresent()) {
            ListBeesComponent.renderEntity(matrixStack, (Entity)entityOptional.get(), (World)context.getGui().getMinecraft().field_71441_e, this.xOffset, this.yOffset, this.defaultRotation, this.renderScale, this.offset);
        } else {
            Entity entity = this.initEntity((EntityType)bee.getLeft(), context.getGui().getMinecraft().field_71441_e);
            if (entity == null) {
                this.bees.remove(page);
                this.pageCount = this.bees.size();
            } else {
                this.bees.set(page, Pair.of((Object)bee.getLeft(), Optional.of(entity)));
            }
        }
    }

    public static void renderEntity(MatrixStack ms, Entity entity, World world, float x, float y, float rotation, float renderScale, float offset) {
        entity.field_70170_p = world;
        ms.func_227860_a_();
        ms.func_227861_a_((double)x, (double)y, 50.0);
        ms.func_227862_a_(renderScale, renderScale, renderScale);
        ms.func_227861_a_(0.0, (double)offset, 0.0);
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        EntityRendererManager erd = Minecraft.func_71410_x().func_175598_ae();
        IRenderTypeBuffer.Impl immediate = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        erd.func_178633_a(false);
        erd.func_229084_a_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, ms, (IRenderTypeBuffer)immediate, 0xF000F0);
        erd.func_178633_a(true);
        immediate.func_228461_a_();
        ms.func_227865_b_();
    }

    private Entity initEntity(EntityType<?> left, ClientWorld world) {
        return left.func_200721_a((World)world);
    }

    public void onDisplayed(IComponentRenderContext context) {
        this.prevPage = new Button(0, 50, 10, 10, (ITextComponent)new StringTextComponent("<"), b -> {
            ++this.page;
            if (this.page > this.pageCount) {
                this.page = this.pageCount;
            }
        });
        this.nextPage = new Button(20, 50, 10, 10, (ITextComponent)new StringTextComponent(">"), b -> {
            --this.page;
            if (this.page < 0) {
                this.page = 0;
            }
        });
        context.registerButton(this.prevPage, 0, () -> {});
        context.registerButton(this.nextPage, 1, () -> {});
    }

    public void onVariablesAvailable(@NotNull UnaryOperator<IVariable> unaryOperator) {
    }
}

