/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.compat.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.compat.jei.BlockMutation;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import com.resourcefulbees.resourcefulbees.utils.RandomCollection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;

public class RecipeUtils {
    private RecipeUtils() {
        throw new IllegalStateException("Utility Class");
    }

    public static double getEffectiveWeight(RandomCollection<?> randomCollection, double weight) {
        return randomCollection.getAdjustedWeight(weight);
    }

    public static void setFluidInput(IIngredients ingredients, ITag<?> tagInput, Block blockInput) {
        if (tagInput != null) {
            ArrayList list = new ArrayList();
            ArrayList ingredientList = new ArrayList();
            tagInput.func_230236_b_().stream().filter(Fluid.class::isInstance).map(Fluid.class::cast).forEach(fluid -> ingredientList.add(new FluidStack(fluid, 1000)));
            list.add(ingredientList);
            ingredients.setInputLists(VanillaTypes.FLUID, list);
        } else if (blockInput instanceof FlowingFluidBlock) {
            FluidStack fluidStack = new FluidStack((Fluid)((FlowingFluidBlock)blockInput).getFluid(), 1000);
            ingredients.setInput(VanillaTypes.FLUID, (Object)fluidStack);
        }
    }

    public static void setBlockInput(IIngredients ingredients, ITag<?> tagInput, Block blockInput) {
        if (tagInput != null) {
            ArrayList list = new ArrayList();
            ArrayList ingredientList = new ArrayList();
            tagInput.func_230236_b_().stream().filter(Block.class::isInstance).map(Block.class::cast).forEach(block -> ingredientList.add(new ItemStack((IItemProvider)block)));
            list.add(ingredientList);
            ingredients.setInputLists(VanillaTypes.ITEM, list);
        } else {
            ItemStack itemStack = new ItemStack((IItemProvider)blockInput);
            ingredients.setInput(VanillaTypes.ITEM, (Object)itemStack);
        }
    }

    public static void setBlockOutput(Block block, CompoundNBT nbt, IIngredients ingredients) {
        ItemStack itemStack = new ItemStack((IItemProvider)block);
        if (!nbt.isEmpty()) {
            itemStack.func_77982_d(nbt);
        }
        ingredients.setOutput(VanillaTypes.ITEM, (Object)itemStack);
    }

    public static void setFluidOutput(Block block, CompoundNBT nbt, IIngredients ingredients) {
        FluidStack fluidStack = new FluidStack((Fluid)((FlowingFluidBlock)block).getFluid(), 1000);
        if (!nbt.isEmpty()) {
            fluidStack.setTag(nbt);
        }
        ingredients.setOutput(VanillaTypes.FLUID, (Object)fluidStack);
    }

    public static void addMutationToolTip(BlockMutation.Recipe recipe, IGuiItemStackGroup itemStacks) {
        itemStacks.addTooltipCallback((slotIndex, isInputStack, stack, tooltip) -> RecipeUtils.addMutationToolTip(slotIndex, recipe, tooltip));
    }

    public static void addMutationToolTip(BlockMutation.Recipe recipe, IGuiFluidStackGroup fluidStacks) {
        fluidStacks.addTooltipCallback((slotIndex, isInputStack, stack, tooltip) -> RecipeUtils.addMutationToolTip(slotIndex, recipe, tooltip));
    }

    private static void addMutationToolTip(int slotIndex, BlockMutation.Recipe recipe, List<ITextComponent> tooltip) {
        if (slotIndex == 0 && !recipe.getBlockOutput().getCompoundNBT().isEmpty()) {
            if (BeeInfoUtils.isShiftPressed()) {
                List<String> lore = BeeInfoUtils.getLoreLines(recipe.getBlockOutput().getCompoundNBT());
                lore.forEach(l -> tooltip.add((ITextComponent)new StringTextComponent(l).func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240745_a_((String)"dark_purple")))));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("gui.resourcefulbees.jei.tooltip.show_nbt").func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240745_a_((String)"dark_purple"))));
            }
        }
    }

    public static IGuiItemStackGroup setGuiItemStacksGroup(IRecipeLayout iRecipeLayout, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
        itemStacks.init(0, false, 65, 48);
        itemStacks.init(1, true, 15, 57);
        itemStacks.set(0, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        itemStacks.set(1, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        return itemStacks;
    }

    public static List<ITextComponent> getTooltipStrings(double mouseX, double mouseY, double chance) {
        double infoX = 63.0;
        double infoY = 8.0;
        if (mouseX >= infoX && mouseX <= infoX + 9.0 && mouseY >= infoY && mouseY <= infoY + 9.0) {
            return Collections.singletonList(new StringTextComponent(I18n.func_135052_a((String)"gui.resourcefulbees.jei.category.mutation.info", (Object[])new Object[0])));
        }
        double info2X = 54.0;
        double info2Y = 34.0;
        if (mouseX >= info2X && mouseX <= info2X + 9.0 && mouseY >= info2Y && mouseY <= info2Y + 9.0 && chance < 1.0) {
            return Collections.singletonList(new StringTextComponent(I18n.func_135052_a((String)"gui.resourcefulbees.jei.category.mutation_chance.info", (Object[])new Object[0])));
        }
        return Collections.emptyList();
    }

    public static void drawMutationScreen(MatrixStack stack, IDrawable beeHive, IDrawable info, double weight, double chance) {
        beeHive.draw(stack, 65, 10);
        info.draw(stack, 63, 8);
        if (weight == 1.0 && chance == 1.0) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontRenderer = minecraft.field_71466_p;
        DecimalFormat decimalFormat = new DecimalFormat("##%");
        if (chance < 1.0) {
            String chanceString = decimalFormat.format(chance);
            int padding2 = fontRenderer.func_78256_a(chanceString) / 2;
            info.draw(stack, 54, 34);
            fontRenderer.func_238421_b_(stack, chanceString, 76.0f - (float)padding2, 35.0f, -8355712);
        }
        if (weight < 1.0) {
            String weightString = decimalFormat.format(weight);
            int padding = fontRenderer.func_78256_a(weightString) / 2;
            fontRenderer.func_238421_b_(stack, weightString, 48.0f - (float)padding, 66.0f, -8355712);
        }
    }
}

