/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.compat.jei;

import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.client.gui.screen.CentrifugeScreen;
import com.resourcefulbees.resourcefulbees.client.gui.screen.MechanicalCentrifugeScreen;
import com.resourcefulbees.resourcefulbees.compat.jei.ApiaryCategory;
import com.resourcefulbees.resourcefulbees.compat.jei.BeeBreedingCategory;
import com.resourcefulbees.resourcefulbees.compat.jei.BeeHiveCategory;
import com.resourcefulbees.resourcefulbees.compat.jei.BiomeParser;
import com.resourcefulbees.resourcefulbees.compat.jei.BlockMutation;
import com.resourcefulbees.resourcefulbees.compat.jei.BlockToItem;
import com.resourcefulbees.resourcefulbees.compat.jei.CentrifugeRecipeCategory;
import com.resourcefulbees.resourcefulbees.compat.jei.EntityFlowerCategory;
import com.resourcefulbees.resourcefulbees.compat.jei.EntityToEntity;
import com.resourcefulbees.resourcefulbees.compat.jei.FlowersCategory;
import com.resourcefulbees.resourcefulbees.compat.jei.ingredients.EntityIngredient;
import com.resourcefulbees.resourcefulbees.compat.jei.ingredients.EntityIngredientFactory;
import com.resourcefulbees.resourcefulbees.compat.jei.ingredients.EntityIngredientHelper;
import com.resourcefulbees.resourcefulbees.compat.jei.ingredients.EntityRenderer;
import com.resourcefulbees.resourcefulbees.recipe.CentrifugeRecipe;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEICompat
implements IModPlugin {
    public static final IIngredientType<EntityIngredient> ENTITY_INGREDIENT = () -> EntityIngredient.class;

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeHiveCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeBreedingCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FlowersCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new EntityFlowerCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CentrifugeRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BlockMutation(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new EntityToEntity(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BlockToItem(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ApiaryCategory(helper)});
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("resourcefulbees", "jei");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.T1_BEEHIVE_ITEM.get()), new ResourceLocation[]{BeeHiveCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.T2_BEEHIVE_ITEM.get()), new ResourceLocation[]{BeeHiveCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.T3_BEEHIVE_ITEM.get()), new ResourceLocation[]{BeeHiveCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.T4_BEEHIVE_ITEM.get()), new ResourceLocation[]{BeeHiveCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.T1_APIARY_ITEM.get()), new ResourceLocation[]{ApiaryCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.T2_APIARY_ITEM.get()), new ResourceLocation[]{ApiaryCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.T3_APIARY_ITEM.get()), new ResourceLocation[]{ApiaryCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.T4_APIARY_ITEM.get()), new ResourceLocation[]{ApiaryCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.CENTRIFUGE_ITEM.get()), new ResourceLocation[]{CentrifugeRecipeCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.MECHANICAL_CENTRIFUGE_ITEM.get()), new ResourceLocation[]{CentrifugeRecipeCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.CENTRIFUGE_CONTROLLER_ITEM.get()), new ResourceLocation[]{CentrifugeRecipeCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.ELITE_CENTRIFUGE_CONTROLLER_ITEM.get()), new ResourceLocation[]{CentrifugeRecipeCategory.ID});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        ClientWorld clientWorld = Minecraft.func_71410_x().field_71441_e;
        if (clientWorld != null) {
            RecipeManager recipeManager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
            registration.addRecipes(BeeHiveCategory.getHoneycombRecipes(), BeeHiveCategory.ID);
            registration.addRecipes(recipeManager.func_215366_a(CentrifugeRecipe.CENTRIFUGE_RECIPE_TYPE).values(), CentrifugeRecipeCategory.ID);
            registration.addRecipes(BeeBreedingCategory.getBreedingRecipes(), BeeBreedingCategory.ID);
            registration.addRecipes(BlockMutation.getMutationRecipes(), BlockMutation.ID);
            registration.addRecipes(BlockToItem.getMutationRecipes(), BlockToItem.ID);
            registration.addRecipes(EntityToEntity.getMutationRecipes(), EntityToEntity.ID);
            registration.addRecipes(ApiaryCategory.getHoneycombRecipes(), ApiaryCategory.ID);
            registration.addRecipes(FlowersCategory.getFlowersRecipes(), FlowersCategory.ID);
            registration.addRecipes(EntityFlowerCategory.getFlowersRecipes(), EntityFlowerCategory.ID);
            this.registerInfoDesc(registration);
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(MechanicalCentrifugeScreen.class, 80, 30, 18, 18, new ResourceLocation[]{CentrifugeRecipeCategory.ID});
        registration.addGuiContainerHandler(CentrifugeScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<CentrifugeScreen>(){

            @NotNull
            public Collection<IGuiClickableArea> getGuiClickableAreas(@NotNull CentrifugeScreen screen, double mouseX, double mouseY) {
                IGuiClickableArea clickableArea = IGuiClickableArea.createBasic((int)(screen.getXSize() - 25), (int)50, (int)18, (int)18, (ResourceLocation[])new ResourceLocation[]{CentrifugeRecipeCategory.ID});
                return Collections.singleton(clickableArea);
            }
        });
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        List<EntityIngredient> entityIngredients = EntityIngredientFactory.create();
        registration.register(ENTITY_INGREDIENT, entityIngredients, (IIngredientHelper)new EntityIngredientHelper(), (IIngredientRenderer)new EntityRenderer());
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ModItems.BEEPEDIA.get(), itemStack -> itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("Creative") ? "creative.beepedia" : "");
    }

    public void registerInfoDesc(IRecipeRegistration registration) {
        for (EntityIngredient bee : EntityIngredientFactory.create()) {
            CustomBeeData beeData = BeeRegistry.getRegistry().getBeeData(bee.getBeeType());
            StringBuilder stats = new StringBuilder();
            String aqua = TextFormatting.DARK_AQUA.toString();
            String purple = TextFormatting.DARK_PURPLE.toString();
            stats.append(aqua).append(" Base Health: ").append(purple).append(beeData.getCombatData().getBaseHealth()).append("\n");
            stats.append(aqua).append(" Attack Damage: ").append(purple).append(beeData.getCombatData().getAttackDamage()).append("\n");
            stats.append(aqua).append(" Has Honeycomb: ").append(purple).append(StringUtils.capitalize((String)String.valueOf(beeData.hasHoneycomb()))).append("\n");
            stats.append(aqua).append(" Max Time in Hive: ").append(purple).append(beeData.getMaxTimeInHive()).append(" ticks\n");
            stats.append(aqua).append(" Has Mutation: ").append(purple).append(StringUtils.capitalize((String)String.valueOf(beeData.getMutationData().hasMutation()))).append("\n");
            if (beeData.getMutationData().hasMutation()) {
                stats.append(aqua).append(" Mutation Count: ").append(purple).append(StringUtils.capitalize((String)String.valueOf(beeData.getMutationData().getMutationCount()))).append("\n");
            }
            stats.append(aqua).append(" Is Breedable: ").append(purple).append(StringUtils.capitalize((String)String.valueOf(beeData.getBreedData().isBreedable()))).append("\n");
            if (beeData.getBreedData().isBreedable() && beeData.getBreedData().hasParents()) {
                stats.append(aqua).append(" Parents: ").append(purple).append(StringUtils.capitalize((String)beeData.getBreedData().getParent1())).append(" Bee, ").append(StringUtils.capitalize((String)beeData.getBreedData().getParent2())).append(" Bee\n");
            }
            if (beeData.hasTraitNames()) {
                StringJoiner traits = new StringJoiner(", ");
                Arrays.stream(beeData.getTraitNames()).forEach(trait -> traits.add(WordUtils.capitalize((String)trait.replace("_", " "))));
                stats.append(aqua).append(" Traits: ").append(purple).append(traits.toString()).append("\n");
            }
            stats.append(aqua).append(" Spawns in World: ").append(purple).append(StringUtils.capitalize((String)String.valueOf(beeData.getSpawnData().canSpawnInWorld()))).append("\n");
            if (beeData.getSpawnData().canSpawnInWorld()) {
                stats.append(aqua).append(" Light Level: ").append(purple).append((Object)beeData.getSpawnData().getLightLevel()).append("\n");
                stats.append(aqua).append(" Min Y Level: ").append(purple).append(beeData.getSpawnData().getMinYLevel()).append("\n");
                stats.append(aqua).append(" Max Y Level: ").append(purple).append(beeData.getSpawnData().getMaxYLevel()).append("\n");
                stats.append(aqua).append(" Min Group Size: ").append(purple).append(beeData.getSpawnData().getMinGroupSize()).append("\n");
                stats.append(aqua).append(" Max Group Size: ").append(purple).append(beeData.getSpawnData().getMaxGroupSize()).append("\n");
                stats.append(aqua).append(" Biomes: ").append(purple).append(BiomeParser.parseBiomes(beeData));
            }
            registration.addIngredientInfo((Object)bee, ENTITY_INGREDIENT, new String[]{stats.toString()});
        }
    }
}

