/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.compat.jei;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.compat.jei.BaseCategory;
import com.resourcefulbees.resourcefulbees.recipe.CentrifugeRecipe;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class CentrifugeRecipeCategory
extends BaseCategory<CentrifugeRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("resourcefulbees", "centrifuge");
    protected final IDrawableAnimated arrow;
    private final IDrawable fluidHider;
    private final IDrawable multiblock;
    private static final ResourceLocation BACKGROUND_IMAGE = new ResourceLocation("resourcefulbees", "textures/gui/jei/centrifuge.png");

    public CentrifugeRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, ID, I18n.func_135052_a((String)"gui.resourcefulbees.jei.category.centrifuge", (Object[])new Object[0]), (IDrawable)guiHelper.createDrawable(BACKGROUND_IMAGE, 0, 0, 133, 65), guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModItems.CENTRIFUGE_ITEM.get())), CentrifugeRecipe.class);
        this.fluidHider = guiHelper.createDrawable(BACKGROUND_IMAGE, 9, 41, 18, 18);
        this.arrow = guiHelper.drawableBuilder(new ResourceLocation("resourcefulbees", "textures/gui/jei/centrifuge.png"), 0, 66, 73, 30).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.multiblock = guiHelper.createDrawable(new ResourceLocation("resourcefulbees", "textures/gui/jei/icons.png"), 25, 0, 16, 16);
    }

    @Override
    public void setIngredients(CentrifugeRecipe recipe, @NotNull IIngredients iIngredients) {
        List<Pair<ItemStack, Float>> outputs = recipe.itemOutputs;
        List<Pair<FluidStack, Float>> fluidOutput = recipe.fluidOutput;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        fluids.add(((FluidStack)fluidOutput.get(0).getLeft()).copy());
        if (((ItemStack)outputs.get(0).getLeft()).func_77946_l().func_190926_b()) {
            stacks.add(new ItemStack((IItemProvider)Items.field_221574_b));
        } else {
            stacks.add(((ItemStack)outputs.get(0).getLeft()).func_77946_l());
        }
        stacks.add(((ItemStack)outputs.get(1).getLeft()).func_77946_l());
        if (recipe.noBottleInput) {
            iIngredients.setInputIngredients((List)Lists.newArrayList((Object[])new Ingredient[]{recipe.ingredient}));
            fluids.add(((FluidStack)fluidOutput.get(1).getLeft()).copy());
        } else {
            stacks.add(((ItemStack)outputs.get(2).getLeft()).func_77946_l());
            ItemStack bottleStack = new ItemStack((IItemProvider)Items.field_151069_bo, ((ItemStack)outputs.get(2).getLeft()).func_190916_E());
            iIngredients.setInputIngredients((List)Lists.newArrayList((Object[])new Ingredient[]{recipe.ingredient, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{bottleStack})}));
        }
        iIngredients.setOutputs(VanillaTypes.ITEM, stacks);
        iIngredients.setOutputs(VanillaTypes.FLUID, fluids);
    }

    @Override
    public void setRecipe(IRecipeLayout iRecipeLayout, CentrifugeRecipe centrifugeRecipe, IIngredients iIngredients) {
        IGuiItemStackGroup guiItemStacks = iRecipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = iRecipeLayout.getFluidStacks();
        guiItemStacks.init(1, true, 9, 5);
        guiItemStacks.set(1, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
        if (centrifugeRecipe.hasFluidOutput) {
            if (((ItemStack)centrifugeRecipe.itemOutputs.get(0).getLeft()).func_190926_b()) {
                guiFluidStacks.init(2, false, 109, 6, 16, 16, ((FluidStack)((List)iIngredients.getOutputs(VanillaTypes.FLUID).get(0)).get(0)).getAmount(), true, null);
                guiFluidStacks.set(2, (List)iIngredients.getOutputs(VanillaTypes.FLUID).get(0));
            } else {
                guiItemStacks.init(2, false, 108, 5);
                guiItemStacks.set(2, (List)iIngredients.getOutputs(VanillaTypes.ITEM).get(0));
                guiFluidStacks.init(5, false, 109, 42, 16, 16, ((FluidStack)((List)iIngredients.getOutputs(VanillaTypes.FLUID).get(0)).get(0)).getAmount(), true, null);
                guiFluidStacks.set(5, (List)iIngredients.getOutputs(VanillaTypes.FLUID).get(0));
            }
        } else {
            guiItemStacks.init(2, false, 108, 5);
            guiItemStacks.init(4, false, 59, 44);
            guiItemStacks.set(2, (List)iIngredients.getOutputs(VanillaTypes.ITEM).get(0));
        }
        if (centrifugeRecipe.noBottleInput) {
            guiFluidStacks.init(4, false, 60, 45, 16, 16, ((FluidStack)((List)iIngredients.getOutputs(VanillaTypes.FLUID).get(1)).get(0)).getAmount(), true, null);
            guiFluidStacks.set(4, (List)iIngredients.getOutputs(VanillaTypes.FLUID).get(1));
        } else {
            guiItemStacks.init(0, true, 9, 23);
            guiItemStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(1));
            guiItemStacks.init(4, false, 59, 44);
            guiItemStacks.set(4, (List)iIngredients.getOutputs(VanillaTypes.ITEM).get(2));
        }
        guiItemStacks.init(3, false, 108, 23);
        guiItemStacks.set(3, (List)iIngredients.getOutputs(VanillaTypes.ITEM).get(1));
    }

    public void draw(CentrifugeRecipe recipe, @NotNull MatrixStack matrix, double mouseX, double mouseY) {
        this.arrow.draw(matrix, 31, 14);
        float beeOutput = ((Float)recipe.itemOutputs.get(0).getRight()).floatValue();
        float beeswax = ((Float)recipe.itemOutputs.get(1).getRight()).floatValue();
        float honeyBottle = recipe.itemOutputs.size() < 3 ? ((Float)recipe.fluidOutput.get(1).getRight()).floatValue() : ((Float)recipe.itemOutputs.get(2).getRight()).floatValue();
        float fluid = ((Float)recipe.fluidOutput.get(0).getRight()).floatValue();
        DecimalFormat decimalFormat = new DecimalFormat("##%");
        String honeyBottleString = decimalFormat.format(honeyBottle);
        String beeOutputString = decimalFormat.format(beeOutput);
        String beeswaxString = decimalFormat.format(beeswax);
        String fluidString = decimalFormat.format(fluid);
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontRenderer = minecraft.field_71466_p;
        int honeyBottleOffset = fontRenderer.func_78256_a(honeyBottleString) / 2;
        int beeOutputOffset = fontRenderer.func_78256_a(beeOutputString) / 2;
        int beeswaxOffset = fontRenderer.func_78256_a(beeswaxString) / 2;
        int fluidOffset = fontRenderer.func_78256_a(fluidString) / 2;
        if ((double)beeOutput < 1.0) {
            fontRenderer.func_238421_b_(matrix, beeOutputString, 95.0f - (float)beeOutputOffset, 10.0f, -8355712);
        }
        if ((double)beeswax < 1.0) {
            fontRenderer.func_238421_b_(matrix, beeswaxString, 95.0f - (float)beeswaxOffset, 30.0f, -8355712);
        }
        if (!(!((double)fluid < 1.0) || recipe.hasFluidOutput && ((ItemStack)recipe.itemOutputs.get(0).getLeft()).func_190926_b())) {
            fontRenderer.func_238421_b_(matrix, fluidString, 95.0f - (float)fluidOffset, 46.0f, -8355712);
        }
        if ((double)honeyBottle < 1.0) {
            fontRenderer.func_238421_b_(matrix, honeyBottleString, 45.0f - (float)honeyBottleOffset, 49.0f, -8355712);
        }
        if (recipe.multiblock) {
            this.multiblock.draw(matrix, 10, 45);
        }
        if (!recipe.hasFluidOutput || recipe.hasFluidOutput && ((ItemStack)recipe.itemOutputs.get(0).getLeft()).func_190926_b()) {
            this.fluidHider.draw(matrix, 108, 41);
        }
    }

    @NotNull
    public List<ITextComponent> getTooltipStrings(@NotNull CentrifugeRecipe recipe, double mouseX, double mouseY) {
        if (mouseX >= 10.0 && mouseX <= 26.0 && mouseY >= 45.0 && mouseY <= 61.0) {
            return Collections.singletonList(new StringTextComponent("Multiblock only recipe."));
        }
        return super.getTooltipStrings((Object)recipe, mouseX, mouseY);
    }
}

