/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.compat.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.api.IBeeRegistry;
import com.resourcefulbees.resourcefulbees.api.beedata.MutationData;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.outputs.ItemOutput;
import com.resourcefulbees.resourcefulbees.compat.jei.BaseCategory;
import com.resourcefulbees.resourcefulbees.compat.jei.JEICompat;
import com.resourcefulbees.resourcefulbees.compat.jei.RecipeUtils;
import com.resourcefulbees.resourcefulbees.compat.jei.ingredients.EntityIngredient;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.utils.RandomCollection;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockToItem
extends BaseCategory<Recipe> {
    public static final ResourceLocation GUI_BACK = new ResourceLocation("resourcefulbees", "textures/gui/jei/beemutation.png");
    public static final ResourceLocation ID = new ResourceLocation("resourcefulbees", "block_to_item_mutation");
    private static final IBeeRegistry BEE_REGISTRY = BeeRegistry.getRegistry();

    public BlockToItem(IGuiHelper guiHelper) {
        super(guiHelper, ID, I18n.func_135052_a((String)"gui.resourcefulbees.jei.category.block_to_item_mutation", (Object[])new Object[0]), (IDrawable)guiHelper.drawableBuilder(GUI_BACK, -12, 0, 99, 75).addPadding(0, 0, 0, 0).build(), (IDrawable)guiHelper.createDrawable(ICONS, 0, 0, 16, 16), Recipe.class);
    }

    public static List<Recipe> getMutationRecipes() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        BEE_REGISTRY.getBees().forEach((s, beeData) -> {
            MutationData mutationData = beeData.getMutationData();
            if (mutationData.hasMutation()) {
                if (mutationData.hasJeiBlockTagItemMutations()) {
                    mutationData.getJeiBlockTagItemMutations().forEach((iTag, doubleRandomCollectionPair) -> ((RandomCollection)doubleRandomCollectionPair.getRight()).forEach(itemOutput -> recipes.add(new Recipe(null, (ITag<?>)iTag, (ItemOutput)itemOutput, (Double)doubleRandomCollectionPair.getLeft(), RecipeUtils.getEffectiveWeight((RandomCollection)doubleRandomCollectionPair.getRight(), itemOutput.getWeight()), (String)s))));
                }
                if (mutationData.hasJeiItemMutations()) {
                    mutationData.getJeiItemMutations().forEach((block, doubleRandomCollectionPair) -> ((RandomCollection)doubleRandomCollectionPair.getRight()).forEach(itemOutput -> recipes.add(new Recipe((Block)block, null, (ItemOutput)itemOutput, (Double)doubleRandomCollectionPair.getLeft(), RecipeUtils.getEffectiveWeight((RandomCollection)doubleRandomCollectionPair.getRight(), itemOutput.getWeight()), (String)s))));
                }
            }
        });
        return recipes;
    }

    @Override
    public void setIngredients(Recipe recipe, @NotNull IIngredients ingredients) {
        if (recipe.tagInput != null && recipe.tagInput.func_230236_b_().get(0) instanceof Fluid) {
            RecipeUtils.setFluidInput(ingredients, recipe.tagInput, recipe.blockInput);
        } else {
            RecipeUtils.setBlockInput(ingredients, recipe.tagInput, recipe.blockInput);
        }
        ItemStack itemStack = new ItemStack((IItemProvider)recipe.itemOutput.getItem());
        if (!recipe.itemOutput.getCompoundNBT().isEmpty()) {
            itemStack.func_77982_d(recipe.itemOutput.getCompoundNBT());
        }
        ingredients.setOutput(VanillaTypes.ITEM, (Object)itemStack);
        ingredients.setInput(JEICompat.ENTITY_INGREDIENT, (Object)new EntityIngredient(recipe.beeType, -45.0f));
    }

    @NotNull
    public List<ITextComponent> getTooltipStrings(Recipe recipe, double mouseX, double mouseY) {
        List list = RecipeUtils.getTooltipStrings(mouseX, mouseY, recipe.chance);
        return list.isEmpty() ? super.getTooltipStrings((Object)recipe, mouseX, mouseY) : list;
    }

    @Override
    public void setRecipe(@NotNull IRecipeLayout iRecipeLayout, @NotNull Recipe recipe, @NotNull IIngredients ingredients) {
        RecipeUtils.setGuiItemStacksGroup(iRecipeLayout, ingredients);
        IGuiIngredientGroup ingredientStacks = iRecipeLayout.getIngredientsGroup(JEICompat.ENTITY_INGREDIENT);
        ingredientStacks.init(0, true, 16, 10);
        ingredientStacks.set(0, (List)ingredients.getInputs(JEICompat.ENTITY_INGREDIENT).get(0));
    }

    public void draw(Recipe recipe, @NotNull MatrixStack stack, double mouseX, double mouseY) {
        RecipeUtils.drawMutationScreen(stack, this.beeHive, this.info, recipe.weight, recipe.chance);
    }

    protected static class Recipe {
        @Nullable
        private final Block blockInput;
        @Nullable
        private final ITag<?> tagInput;
        @NotNull
        private final ItemOutput itemOutput;
        private final double chance;
        private final double weight;
        @NotNull
        private final String beeType;

        public Recipe(@Nullable Block blockInput, @Nullable ITag<?> tagInput, @NotNull ItemOutput itemOutput, double chance, double weight, @NotNull String beeType) {
            this.blockInput = blockInput;
            this.tagInput = tagInput;
            this.itemOutput = itemOutput;
            this.chance = chance;
            this.weight = weight;
            this.beeType = beeType;
        }
    }
}

