/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.compat.jei;

import com.google.common.base.Splitter;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.registry.BiomeDictionary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.text.WordUtils;

public class BiomeParser {
    private BiomeParser() {
        throw new IllegalStateException("Utility Class");
    }

    public static String parseBiomes(CustomBeeData bee) {
        if (!bee.getSpawnData().getBiomeWhitelist().isEmpty()) {
            HashSet<ResourceLocation> whitelist = new HashSet<ResourceLocation>(BiomeParser.getBiomeSet(bee.getSpawnData().getBiomeWhitelist()));
            Set<ResourceLocation> blacklist = new HashSet<ResourceLocation>();
            if (!bee.getSpawnData().getBiomeBlacklist().isEmpty()) {
                blacklist = BiomeParser.getBiomeSet(bee.getSpawnData().getBiomeBlacklist());
            }
            return BiomeParser.buildReturnString(whitelist, blacklist);
        }
        return "null";
    }

    public static List<ResourceLocation> getBiomes(CustomBeeData beeData) {
        Set<ResourceLocation> biomes = BiomeParser.getBiomeSet(beeData.getSpawnData().getBiomeWhitelist());
        Set<ResourceLocation> blackListBiomes = BiomeParser.getBiomeSet(beeData.getSpawnData().getBiomeBlacklist());
        biomes.removeAll(blackListBiomes);
        return new ArrayList<ResourceLocation>(biomes);
    }

    private static Set<ResourceLocation> getBiomeSet(String list) {
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        if (list.contains("tag:")) {
            set.addAll(BiomeParser.parseBiomeListFromTag(list));
        } else {
            set.addAll(BiomeParser.parseBiomeList(list));
        }
        return set;
    }

    private static Set<ResourceLocation> parseBiomeListFromTag(String list) {
        HashSet<ResourceLocation> biomeSet = new HashSet<ResourceLocation>();
        Splitter.on((String)",").trimResults().split((CharSequence)list.replace("tag:", "")).forEach(s -> {
            if (((Boolean)Config.USE_FORGE_DICTIONARIES.get()).booleanValue()) {
                BiomeDictionary.Type type = BiomeParser.getForgeType(s);
                if (type != null) {
                    biomeSet.addAll(BiomeParser.getForgeBiomeLocations(type));
                }
            } else if (BiomeDictionary.getTypes().containsKey(s)) {
                biomeSet.addAll((Collection)BiomeDictionary.getTypes().get(s));
            }
        });
        return biomeSet;
    }

    private static Set<ResourceLocation> parseBiomeList(String list) {
        HashSet<ResourceLocation> biomeSet = new HashSet<ResourceLocation>();
        Splitter.on((char)',').trimResults().split((CharSequence)list).forEach(s -> biomeSet.add(new ResourceLocation(s)));
        return biomeSet;
    }

    private static String buildReturnString(Set<ResourceLocation> whitelist, Set<ResourceLocation> blacklist) {
        StringJoiner returnList = new StringJoiner(", ");
        whitelist.stream().filter(resourceLocation -> !blacklist.contains(resourceLocation)).forEach(resourceLocation -> returnList.add(WordUtils.capitalize((String)resourceLocation.func_110623_a().replace("_", " "))));
        return returnList.toString();
    }

    private static List<ResourceLocation> getBiomesFromList(List<String> whitelistStrings) {
        ArrayList<ResourceLocation> biomes = new ArrayList<ResourceLocation>();
        for (String whitelistString : whitelistStrings) {
            if (whitelistString.startsWith("tag:")) {
                biomes.addAll(BiomeParser.getBiomesFromTag(whitelistString.replace("tag:", "")));
                continue;
            }
            biomes.add(BiomeParser.getBiomeFromString(whitelistString));
        }
        return biomes;
    }

    private static ResourceLocation getBiomeFromString(String whitelistString) {
        return new ResourceLocation(whitelistString);
    }

    private static List<ResourceLocation> getBiomesFromTag(String s) {
        if (((Boolean)Config.USE_FORGE_DICTIONARIES.get()).booleanValue()) {
            return new ArrayList<ResourceLocation>(BiomeParser.getForgeBiomeLocations(BiomeParser.getForgeType(s)));
        }
        if (BiomeDictionary.getTypes().containsKey(s)) {
            return new ArrayList<ResourceLocation>((Collection)BiomeDictionary.getTypes().get(s));
        }
        return new ArrayList<ResourceLocation>();
    }

    private static Set<RegistryKey<Biome>> getForgeBiomes(BiomeDictionary.Type type) {
        return net.minecraftforge.common.BiomeDictionary.getBiomes((BiomeDictionary.Type)type);
    }

    private static Collection<? extends ResourceLocation> getForgeBiomeLocations(BiomeDictionary.Type type) {
        return BiomeParser.getForgeBiomes(type).stream().map(RegistryKey::func_240901_a_).collect(Collectors.toList());
    }

    private static BiomeDictionary.Type getForgeType(String s) {
        Collection forgeDict = BiomeDictionary.Type.getAll();
        for (BiomeDictionary.Type type : forgeDict) {
            if (!type.getName().equalsIgnoreCase(s)) continue;
            return type;
        }
        return null;
    }
}

