/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.compat.jei;

import com.resourcefulbees.resourcefulbees.compat.jei.BaseCategory;
import com.resourcefulbees.resourcefulbees.compat.jei.JEICompat;
import com.resourcefulbees.resourcefulbees.compat.jei.ingredients.EntityIngredient;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.lib.ApiaryOutput;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ApiaryCategory
extends BaseCategory<Recipe> {
    public static final ResourceLocation GUI_BACK = new ResourceLocation("resourcefulbees", "textures/gui/jei/beehive.png");
    public static final ResourceLocation ID = new ResourceLocation("resourcefulbees", "apiary");

    public ApiaryCategory(IGuiHelper guiHelper) {
        super(guiHelper, ID, I18n.func_135052_a((String)"gui.resourcefulbees.jei.category.apiary", (Object[])new Object[0]), (IDrawable)guiHelper.drawableBuilder(GUI_BACK, 0, 0, 160, 26).addPadding(0, 0, 0, 0).build(), guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModItems.T1_APIARY_ITEM.get())), Recipe.class);
    }

    public static List<Recipe> getHoneycombRecipes() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        int[] outputQuantities = new int[]{(Integer)Config.T1_APIARY_QUANTITY.get(), (Integer)Config.T2_APIARY_QUANTITY.get(), (Integer)Config.T3_APIARY_QUANTITY.get(), (Integer)Config.T4_APIARY_QUANTITY.get()};
        ArrayList<Item> apiaryTiers = new ArrayList<Item>(Arrays.asList((Item)ModItems.T1_APIARY_ITEM.get(), (Item)ModItems.T2_APIARY_ITEM.get(), (Item)ModItems.T3_APIARY_ITEM.get(), (Item)ModItems.T4_APIARY_ITEM.get()));
        BeeRegistry.getRegistry().getBees().forEach((s, customBeeData) -> {
            ApiaryOutput[] outputs = customBeeData.getApiaryOutputsTypes();
            int[] customAmounts = customBeeData.getApiaryOutputAmounts();
            if (customBeeData.hasHoneycomb()) {
                for (int i = 0; i < 4; ++i) {
                    Item outputItem = outputs[i].equals((Object)ApiaryOutput.COMB) ? (Item)customBeeData.getCombRegistryObject().get() : (Item)customBeeData.getCombBlockItemRegistryObject().get();
                    ItemStack outputStack = new ItemStack((IItemProvider)outputItem, customAmounts != null && customAmounts[i] > 0 ? customAmounts[i] : outputQuantities[i]);
                    recipes.add(new Recipe(outputStack, customBeeData.getName(), new ItemStack((IItemProvider)apiaryTiers.get(i))));
                }
            }
        });
        return recipes;
    }

    @Override
    public void setIngredients(@NotNull Recipe recipe, @NotNull IIngredients ingredients) {
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getComb());
        ingredients.setInput(VanillaTypes.ITEM, (Object)recipe.apiary);
        ingredients.setInput(JEICompat.ENTITY_INGREDIENT, (Object)new EntityIngredient(recipe.beeType, -45.0f));
    }

    @Override
    public void setRecipe(@NotNull IRecipeLayout iRecipeLayout, @NotNull Recipe recipe, @NotNull IIngredients ingredients) {
        IGuiIngredientGroup ingredientStacks = iRecipeLayout.getIngredientsGroup(JEICompat.ENTITY_INGREDIENT);
        ingredientStacks.init(0, true, 10, 2);
        ingredientStacks.set(0, (List)ingredients.getInputs(JEICompat.ENTITY_INGREDIENT).get(0));
        IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
        itemStacks.init(0, false, 138, 4);
        itemStacks.init(1, true, 62, 4);
        itemStacks.set(ingredients);
    }

    public static class Recipe {
        private final ItemStack comb;
        private final String beeType;
        private final ItemStack apiary;

        public Recipe(ItemStack comb, String beeType, ItemStack apiary) {
            this.comb = comb;
            this.beeType = beeType;
            this.apiary = apiary;
        }

        public ItemStack getComb() {
            return this.comb;
        }

        public String getBeeType() {
            return this.beeType;
        }

        public ItemStack getApiary() {
            return this.apiary;
        }
    }
}

