/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.resourcefulbees.resourcefulbees.api.IBeepediaData;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.capabilities.BeepediaData;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class BeepediaCommand {
    private static final DynamicCommandExceptionType BEE_NOT_FOUND = new DynamicCommandExceptionType(input -> new TranslationTextComponent("argument.resourcefulbees.beepedia.bee_not_found"));
    private static final String PLAYER = "player";
    private static final String BEE = "bee";
    protected static final Set<ResourceLocation> VALID_BEES = BeeRegistry.getRegistry().getBees().values().stream().map(CustomBeeData::getEntityTypeRegistryID).collect(Collectors.toCollection(LinkedHashSet::new));

    private BeepediaCommand() {
        throw new IllegalStateException("Utility Class");
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"beepedia").requires(cs -> cs.func_197034_c(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)PLAYER, (ArgumentType)EntityArgument.func_197094_d()).then(DiscoverCommand.register())).then(ForgetCommand.register())).then(ResetCommand.register())).then(CompleteCommand.register())));
    }

    private static String getBee(CommandContext<CommandSource> context) {
        ResourceLocation bee = BeeArgument.getBee(context, BEE);
        return bee.toString().replaceFirst(String.format("^%s:", "resourcefulbees"), "").replaceAll("_bee$", "");
    }

    private static void sendMessageToPlayer(PlayerEntity playerEntity, MessageTypes messageTypes, String bee) {
        switch (messageTypes) {
            case LOCK: 
            case UNLOCK: {
                String translation = messageTypes.equals((Object)MessageTypes.UNLOCK) ? "command.resourcefulbees.beepedia.bee_discovered" : "command.resourcefulbees.beepedia.bee_forgotten";
                TranslationTextComponent beeName = BeeRegistry.getRegistry().getBeeData(bee).getTranslation();
                playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent(translation, new Object[]{beeName}), false);
                break;
            }
            case COMPLETE: {
                playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("command.resourcefulbees.beepedia.complete"), false);
                break;
            }
            case RESET: {
                playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("command.resourcefulbees.beepedia.reset"), false);
                break;
            }
        }
    }

    public static class BeeArgument
    implements ArgumentType<ResourceLocation> {
        public static BeeArgument bees() {
            return new BeeArgument();
        }

        public static ResourceLocation getBee(CommandContext<?> context, String bee) {
            return (ResourceLocation)context.getArgument(bee, ResourceLocation.class);
        }

        public ResourceLocation parse(StringReader reader) throws CommandSyntaxException {
            int cursor = reader.getCursor();
            ResourceLocation id = ResourceLocation.func_195826_a((StringReader)reader);
            if (!VALID_BEES.contains(id)) {
                reader.setCursor(cursor);
                throw BEE_NOT_FOUND.createWithContext((ImmutableStringReader)reader, (Object)id.toString());
            }
            return id;
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            VALID_BEES.forEach(b -> builder.suggest(b.toString()));
            return builder.buildFuture();
        }

        public Collection<String> getExamples() {
            return VALID_BEES.stream().map(ResourceLocation::toString).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        public static BeeArgument beeArgument() {
            return new BeeArgument();
        }
    }

    private static class CompleteCommand {
        private CompleteCommand() {
        }

        public static ArgumentBuilder<CommandSource, ?> register() {
            return Commands.func_197057_a((String)"complete").executes(context -> {
                CompleteCommand.addAllBees((CommandContext<CommandSource>)context);
                return 1;
            });
        }

        private static void addAllBees(CommandContext<CommandSource> context) throws CommandSyntaxException {
            Collection playerEntities = EntityArgument.func_197090_e(context, (String)BeepediaCommand.PLAYER);
            for (ServerPlayerEntity playerEntity : playerEntities) {
                IBeepediaData data = (IBeepediaData)playerEntity.getCapability(BeepediaData.Provider.BEEPEDIA_DATA).orElse((Object)new BeepediaData());
                data.getBeeList().addAll(BeeRegistry.getRegistry().getBees().values().stream().map(CustomBeeData::getName).collect(Collectors.toCollection(LinkedHashSet::new)));
                BeepediaData.sync(playerEntity, data);
                BeepediaCommand.sendMessageToPlayer((PlayerEntity)playerEntity, MessageTypes.COMPLETE, "");
            }
        }
    }

    private static class ResetCommand {
        private ResetCommand() {
        }

        public static ArgumentBuilder<CommandSource, ?> register() {
            return Commands.func_197057_a((String)"reset").executes(context -> {
                ResetCommand.removeAllBees((CommandContext<CommandSource>)context);
                return 1;
            });
        }

        private static void removeAllBees(CommandContext<CommandSource> context) throws CommandSyntaxException {
            Collection playerEntities = EntityArgument.func_197090_e(context, (String)BeepediaCommand.PLAYER);
            for (ServerPlayerEntity playerEntity : playerEntities) {
                IBeepediaData data = (IBeepediaData)playerEntity.getCapability(BeepediaData.Provider.BEEPEDIA_DATA).orElse((Object)new BeepediaData());
                data.getBeeList().clear();
                BeepediaData.sync(playerEntity, data);
                BeepediaCommand.sendMessageToPlayer((PlayerEntity)playerEntity, MessageTypes.RESET, "");
            }
        }
    }

    private static class ForgetCommand {
        private ForgetCommand() {
        }

        public static ArgumentBuilder<CommandSource, ?> register() {
            return Commands.func_197057_a((String)"forget").then(Commands.func_197056_a((String)BeepediaCommand.BEE, (ArgumentType)BeeArgument.bees()).executes(context -> {
                String arg = BeepediaCommand.getBee((CommandContext<CommandSource>)context);
                Collection playerEntities = EntityArgument.func_197090_e((CommandContext)context, (String)BeepediaCommand.PLAYER);
                for (ServerPlayerEntity playerEntity : playerEntities) {
                    IBeepediaData data = (IBeepediaData)playerEntity.getCapability(BeepediaData.Provider.BEEPEDIA_DATA).orElse((Object)new BeepediaData());
                    data.getBeeList().remove(arg);
                    BeepediaData.sync(playerEntity, data);
                    BeepediaCommand.sendMessageToPlayer((PlayerEntity)playerEntity, MessageTypes.LOCK, arg);
                }
                return 1;
            }));
        }
    }

    private static class DiscoverCommand {
        private DiscoverCommand() {
        }

        public static ArgumentBuilder<CommandSource, ?> register() {
            return Commands.func_197057_a((String)"discover").then(Commands.func_197056_a((String)BeepediaCommand.BEE, (ArgumentType)BeeArgument.bees()).executes(context -> {
                String arg = BeepediaCommand.getBee((CommandContext<CommandSource>)context);
                Collection playerEntities = EntityArgument.func_197090_e((CommandContext)context, (String)BeepediaCommand.PLAYER);
                for (ServerPlayerEntity playerEntity : playerEntities) {
                    IBeepediaData data = (IBeepediaData)playerEntity.getCapability(BeepediaData.Provider.BEEPEDIA_DATA).orElse((Object)new BeepediaData());
                    data.getBeeList().add(arg);
                    BeepediaData.sync(playerEntity, data);
                    BeepediaCommand.sendMessageToPlayer((PlayerEntity)playerEntity, MessageTypes.UNLOCK, arg);
                }
                return 1;
            }));
        }
    }

    public static enum MessageTypes {
        UNLOCK,
        LOCK,
        COMPLETE,
        RESET;

    }
}

