/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.render.patreon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.resourcefulbees.resourcefulbees.client.render.patreon.LayerData;
import com.resourcefulbees.resourcefulbees.client.render.patreon.PetBeeModel;
import com.resourcefulbees.resourcefulbees.lib.ModelTypes;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class PetModelData
implements IAnimatable {
    public static final Codec<PetModelData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("version").orElse((Object)-1).forGetter(PetModelData::getVersion), (App)Codec.STRING.fieldOf("id").orElse((Object)"error").forGetter(PetModelData::getId), (App)ResourceLocation.field_240908_a_.fieldOf("model").orElse((Object)ModelTypes.DEFAULT.model).forGetter(PetModelData::getModelLocation), (App)ResourceLocation.field_240908_a_.fieldOf("texture").orElse((Object)new ResourceLocation("textures/entity/bee/bee.png")).forGetter(PetModelData::getTexture), (App)PetModelData.createLinkedSetCodec(LayerData.CODEC).fieldOf("layers").orElse(new LinkedHashSet()).forGetter(PetModelData::getLayers)).apply((Applicative)instance, PetModelData::new));
    private final PetBeeModel<PetModelData> model = new PetBeeModel();
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private final int version;
    private final String id;
    private final ResourceLocation modelLocation;
    private final ResourceLocation texture;
    private final Set<LayerData> layers;

    public static <A> Codec<Set<A>> createLinkedSetCodec(Codec<A> codec) {
        return codec.listOf().xmap(LinkedHashSet::new, LinkedList::new);
    }

    public PetModelData(int version, String id, ResourceLocation modelLocation, ResourceLocation texture, Set<LayerData> layers) {
        this.version = version;
        this.id = id;
        this.modelLocation = modelLocation;
        this.texture = texture;
        this.layers = layers;
    }

    public int getVersion() {
        return this.version;
    }

    public String getId() {
        return this.id;
    }

    public PetBeeModel getModel() {
        return this.model;
    }

    public ResourceLocation getModelLocation() {
        return this.modelLocation;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public Set<LayerData> getLayers() {
        return this.layers;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "bee_controller", 0.0f, event -> {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.bee.fly", Boolean.valueOf(true)).addAnimation("animation.bee.fly.bobbing", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static {
        AnimationController.addModelFetcher(object -> object instanceof PetModelData ? ((PetModelData)object).getModel() : null);
    }
}

