/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.render.patreon;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.resourcefulbees.resourcefulbees.client.render.patreon.PetInfo;
import com.resourcefulbees.resourcefulbees.client.render.patreon.PetModelData;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;

public class PetLoader {
    private static final Gson gson = new Gson();

    private PetLoader() {
        throw new IllegalStateException("Utility Class");
    }

    public static void loadAPI() {
        try {
            JsonElement defaultBee;
            JsonElement users;
            URL url = new URL("https://pets.resourcefulbees.com/pets");
            URLConnection connection = url.openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/4.76 (Resourceful Bees Mod)");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            String rep = IOUtils.toString((InputStream)new BufferedInputStream(connection.getInputStream()), (Charset)StandardCharsets.UTF_8);
            JsonObject json = (JsonObject)gson.fromJson(rep, JsonObject.class);
            JsonElement models = json.get("models");
            if (models instanceof JsonArray) {
                JsonArray modelData = models.getAsJsonArray();
                for (JsonElement model : modelData) {
                    Optional petData = PetModelData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)model).result();
                    petData.ifPresent(PetInfo::addModel);
                }
            }
            if ((users = json.get("users")) instanceof JsonObject) {
                JsonObject userObject = users.getAsJsonObject();
                for (Map.Entry user : userObject.entrySet()) {
                    if (!(user.getValue() instanceof JsonPrimitive)) continue;
                    PetInfo.addUser((String)user.getKey(), ((JsonElement)user.getValue()).getAsString());
                }
            }
            if ((defaultBee = json.get("default")) instanceof JsonPrimitive) {
                PetInfo.defaultModel = PetInfo.getModel(defaultBee.getAsString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

