/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.render.patreon;

import com.mojang.util.UUIDTypeAdapter;
import com.resourcefulbees.resourcefulbees.client.render.patreon.LayerData;
import com.resourcefulbees.resourcefulbees.client.render.patreon.PetModelData;
import com.resourcefulbees.resourcefulbees.lib.ModelTypes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PetInfo {
    private static final int VERSION = 1;
    private static final PetModelData FALLBACK_MODEL = new PetModelData(-1, "fallback", ModelTypes.DEFAULT.model, new ResourceLocation("textures/entity/bee/bee.png"), new HashSet<LayerData>());
    protected static PetModelData defaultModel = null;
    private static final Map<String, PetModelData> PET_MODELS = new HashMap<String, PetModelData>();
    private static final Map<UUID, String> USER_PETS = new HashMap<UUID, String>();

    private PetInfo() {
        throw new IllegalStateException("Utility Class");
    }

    protected static void addUser(String uuid, String model) {
        try {
            PetInfo.getUUID(uuid).ifPresent(uid -> USER_PETS.put((UUID)uid, model));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Optional<UUID> getUUID(String uuid) throws IllegalArgumentException {
        if (uuid.length() == 36 && uuid.contains("-")) {
            return Optional.of(UUIDTypeAdapter.fromString((String)uuid));
        }
        if (uuid.length() == 32) {
            return Optional.of(UUID.fromString(uuid));
        }
        return Optional.empty();
    }

    protected static void addModel(@NotNull PetModelData data) {
        if (data.getVersion() != -1 && data.getVersion() <= 1) {
            PET_MODELS.put(data.getId(), data);
        } else {
            PET_MODELS.put(data.getId(), FALLBACK_MODEL);
        }
    }

    public static boolean hasPet(UUID uuid) {
        return USER_PETS.containsKey(uuid) || defaultModel != null;
    }

    @Nullable
    public static PetModelData getModel(String id) {
        return PET_MODELS.get(id);
    }

    @Nullable
    public static PetModelData getPet(UUID uuid) {
        PetModelData data = PetInfo.getModel(USER_PETS.get(uuid));
        if (data != null) {
            return data;
        }
        if (defaultModel != null) {
            return defaultModel;
        }
        USER_PETS.remove(uuid);
        return null;
    }
}

