/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.render.patreon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.ResourceLocation;

public class LayerData {
    public static final Codec<LayerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("color").orElse((Object)"-1").forGetter(LayerData::getColor), (App)ResourceLocation.field_240908_a_.fieldOf("texture").orElse((Object)new ResourceLocation("textures/entity/bee/bee.png")).forGetter(LayerData::getBeeTexture), (App)Codec.BOOL.fieldOf("isGlowing").orElse((Object)false).forGetter(LayerData::isEmissive), (App)Codec.BOOL.fieldOf("isEnchanted").orElse((Object)false).forGetter(LayerData::isEnchanted), (App)Codec.BOOL.fieldOf("isPollen").orElse((Object)false).forGetter(LayerData::isEnchanted), (App)Codec.floatRange((float)5.0f, (float)100.0f).fieldOf("pulseFrequency").orElse((Object)Float.valueOf(0.0f)).forGetter(LayerData::getPulseFrequency)).apply((Applicative)instance, LayerData::new));
    private final String color;
    private final ResourceLocation beeTexture;
    private final boolean isEmissive;
    private final boolean isEnchanted;
    private final float pulseFrequency;
    private final boolean isPollen;

    private LayerData(String color, ResourceLocation beeTexture, boolean isEmissive, boolean isEnchanted, boolean isPollen, float pulseFrequency) {
        this.color = color;
        this.beeTexture = beeTexture;
        this.isEmissive = isEmissive;
        this.isEnchanted = isEnchanted;
        this.pulseFrequency = pulseFrequency;
        this.isPollen = isPollen;
    }

    public String getColor() {
        return this.color;
    }

    public ResourceLocation getBeeTexture() {
        return this.beeTexture;
    }

    public boolean isEmissive() {
        return this.isEmissive && !this.isEnchanted;
    }

    public boolean isEnchanted() {
        return this.isEnchanted;
    }

    public float getPulseFrequency() {
        return this.pulseFrequency;
    }

    public boolean isPollen() {
        return this.isPollen;
    }
}

