/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.render.patreon;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.resourcefulbees.resourcefulbees.client.render.patreon.LayerData;
import com.resourcefulbees.resourcefulbees.client.render.patreon.PetBeeModel;
import com.resourcefulbees.resourcefulbees.client.render.patreon.PetBeeRenderer;
import com.resourcefulbees.resourcefulbees.client.render.patreon.PetInfo;
import com.resourcefulbees.resourcefulbees.client.render.patreon.PetModelData;
import com.resourcefulbees.resourcefulbees.utils.color.Color;
import com.resourcefulbees.resourcefulbees.utils.color.RainbowColor;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.geo.render.built.GeoModel;

public class BeeRewardRender
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    private final PetBeeRenderer renderer = new PetBeeRenderer();

    public BeeRewardRender(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> entityRenderer) {
        super(entityRenderer);
    }

    public void render(@NotNull MatrixStack stack, @NotNull IRenderTypeBuffer buffer, int packedLightIn, @NotNull AbstractClientPlayerEntity playerEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!PetInfo.hasPet(playerEntity.func_110124_au()) || playerEntity.func_82150_aj()) {
            return;
        }
        PetModelData data = PetInfo.getPet(playerEntity.func_110124_au());
        if (data == null) {
            return;
        }
        stack.func_227860_a_();
        stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        stack.func_227862_a_(0.25f, 0.25f, 0.25f);
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(ageInTicks * 0.01f / 2.0f * 360.0f));
        stack.func_227861_a_(0.0, 1.5 * (double)MathHelper.func_76126_a((float)(ageInTicks / 10.0f - 30.0f)), 3.0);
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        RenderType cutoutNoCullRenderType = RenderType.func_228640_c_((ResourceLocation)data.getTexture());
        IVertexBuilder ivertexbuilder = buffer.getBuffer(cutoutNoCullRenderType);
        PetBeeModel modelProvider = data.getModel();
        GeoModel model = modelProvider.getModel(data);
        AnimationEvent event = new AnimationEvent((IAnimatable)data, 0.0f, 0.0f, Minecraft.func_71410_x().func_184121_ak(), false, Collections.emptyList());
        modelProvider.setLivingAnimations(data, this.renderer.getUniqueID(data), event);
        this.renderer.render(model, data, partialTicks, cutoutNoCullRenderType, stack, buffer, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        for (LayerData layer : data.getLayers()) {
            this.renderLayer(playerEntity, stack, buffer, layer, data, model, partialTicks, packedLightIn);
        }
        stack.func_227865_b_();
    }

    public void renderLayer(AbstractClientPlayerEntity playerEntity, MatrixStack stack, @NotNull IRenderTypeBuffer buffer, LayerData layerData, PetModelData data, GeoModel model, float partialTicks, int packedLightIn) {
        Color color;
        ResourceLocation texture = layerData.getBeeTexture();
        Color color2 = color = "rainbow".equals(layerData.getColor()) ? new Color(RainbowColor.getRGB()) : Color.tryParse(layerData.getColor(), -1);
        if (layerData.isEnchanted()) {
            RenderType renderType = RenderType.func_228655_k_();
            this.renderer.render(model, data, partialTicks, renderType, stack, buffer, buffer.getBuffer(renderType), packedLightIn, OverlayTexture.field_229196_a_, 0.0f, 0.0f, 0.0f, 0.0f);
        } else if (layerData.isEmissive()) {
            IVertexBuilder vertexConsumer = buffer.getBuffer(RenderType.func_228652_i_((ResourceLocation)texture));
            if (layerData.getPulseFrequency() == 0.0f || (float)playerEntity.field_70173_aa % layerData.getPulseFrequency() == 0.0f) {
                this.renderer.render(model, data, partialTicks, null, stack, null, vertexConsumer, 0xF00000, OverlayTexture.field_229196_a_, color.getR(), color.getG(), color.getB(), 1.0f);
            }
        } else {
            IVertexBuilder vertexConsumer = buffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)texture));
            this.renderer.render(model, data, partialTicks, null, stack, null, vertexConsumer, packedLightIn, OverlayTexture.func_229201_a_((int)OverlayTexture.func_229199_a_((float)0.0f), (int)OverlayTexture.func_229202_a_((boolean)false)), color.getR(), color.getG(), color.getB(), 1.0f);
        }
    }
}

