/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.resourcefulbees.resourcefulbees.api.beedata.ColorData;
import com.resourcefulbees.resourcefulbees.client.render.entity.GeckoBeeRenderer;
import com.resourcefulbees.resourcefulbees.entity.passive.CustomBeeEntity;
import com.resourcefulbees.resourcefulbees.lib.BeeConstants;
import com.resourcefulbees.resourcefulbees.utils.color.RainbowColor;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib3.renderers.geo.GeoLayerRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;

public class GeckoBeeLayer<E extends CustomBeeEntity>
extends GeoLayerRenderer<E> {
    private static final String PNG_SUFFIX = ".png";
    private static final String ANGRY_PNG_SUFFIX = "_angry.png";
    private final boolean isEmissive;
    private ResourceLocation layerTexture;
    private ResourceLocation angerLayerTexture;
    private final ColorData colorData;
    private float[] color;
    private final IGeoRenderer<E> renderer;

    public GeckoBeeLayer(IGeoRenderer<E> renderer, GeckoBeeRenderer.LayerType layerType, ColorData colorData) {
        super(renderer);
        this.colorData = colorData;
        this.renderer = renderer;
        switch (layerType) {
            case PRIMARY: {
                this.isEmissive = false;
                this.layerTexture = ResourceLocation.func_208304_a((String)("resourcefulbees:textures/entity/" + colorData.getPrimaryLayerTexture() + PNG_SUFFIX));
                this.angerLayerTexture = ResourceLocation.func_208304_a((String)("resourcefulbees:textures/entity/" + colorData.getPrimaryLayerTexture() + ANGRY_PNG_SUFFIX));
                this.color = colorData.isRainbowBee() ? RainbowColor.getColorFloats() : colorData.getPrimaryColorFloats();
                break;
            }
            case SECONDARY: {
                this.isEmissive = false;
                this.layerTexture = ResourceLocation.func_208304_a((String)("resourcefulbees:textures/entity/" + colorData.getSecondaryLayerTexture() + PNG_SUFFIX));
                this.angerLayerTexture = ResourceLocation.func_208304_a((String)("resourcefulbees:textures/entity/" + colorData.getSecondaryLayerTexture() + ANGRY_PNG_SUFFIX));
                this.color = colorData.isRainbowBee() ? RainbowColor.getColorFloats() : colorData.getSecondaryColorFloats();
                break;
            }
            case EMISSIVE: {
                this.isEmissive = true;
                this.layerTexture = ResourceLocation.func_208304_a((String)("resourcefulbees:textures/entity/" + colorData.getEmissiveLayerTexture() + PNG_SUFFIX));
                this.angerLayerTexture = ResourceLocation.func_208304_a((String)("resourcefulbees:textures/entity/" + colorData.getEmissiveLayerTexture() + ANGRY_PNG_SUFFIX));
                this.color = colorData.isRainbowBee() ? RainbowColor.getColorFloats() : colorData.getGlowColorFloats();
                break;
            }
            default: {
                throw new IllegalStateException("You dun screwed up, did you add a new layer?");
            }
        }
        if (GeckoBeeLayer.textureDoesNotExist(this.layerTexture)) {
            this.layerTexture = BeeConstants.MISSING_TEXTURE;
        }
        if (GeckoBeeLayer.textureDoesNotExist(this.angerLayerTexture)) {
            this.angerLayerTexture = this.layerTexture;
        }
    }

    public void render(MatrixStack stack, IRenderTypeBuffer buffer, int packedLight, E bee, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ResourceLocation texture;
        if (this.colorData.isRainbowBee()) {
            this.color = RainbowColor.getColorFloats();
        }
        ResourceLocation resourceLocation = texture = bee.func_233678_J__() ? this.angerLayerTexture : this.layerTexture;
        if (this.colorData.isEnchanted()) {
            this.renderer.render(this.getEntityModel().getModel(((CustomBeeEntity)bee).getBeeData().getColorData().getModeLocation()), bee, partialTicks, null, stack, null, buffer.getBuffer(RenderType.func_228655_k_()), packedLight, OverlayTexture.field_229196_a_, 0.0f, 0.0f, 0.0f, 0.0f);
        } else if (this.isEmissive) {
            IVertexBuilder vertexConsumer = buffer.getBuffer(RenderType.func_228652_i_((ResourceLocation)texture));
            if (this.colorData.getGlowingPulse() == 0 || (float)(((CustomBeeEntity)bee).field_70173_aa % this.colorData.getGlowingPulse()) == 0.0f) {
                this.renderer.render(this.getEntityModel().getModel(((CustomBeeEntity)bee).getBeeData().getColorData().getModeLocation()), bee, partialTicks, null, stack, null, vertexConsumer, 0xF00000, OverlayTexture.field_229196_a_, this.color[0], this.color[1], this.color[2], 1.0f);
            }
        } else {
            IVertexBuilder vertexConsumer = buffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)texture));
            this.renderer.render(this.getEntityModel().getModel(((CustomBeeEntity)bee).getBeeData().getColorData().getModeLocation()), bee, partialTicks, null, stack, null, vertexConsumer, packedLight, LivingRenderer.func_229117_c_(bee, (float)0.0f), this.color[0], this.color[1], this.color[2], 1.0f);
        }
    }

    public static boolean textureDoesNotExist(ResourceLocation texture) {
        try {
            Minecraft.func_71410_x().func_195551_G().func_199002_a(texture);
            return false;
        }
        catch (IOException e) {
            return true;
        }
    }
}

