/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.resourcefulbees.resourcefulbees.client.render.patreon.LayerData;
import com.resourcefulbees.resourcefulbees.client.render.patreon.PetBeeModel;
import com.resourcefulbees.resourcefulbees.client.render.patreon.PetModelData;
import com.resourcefulbees.resourcefulbees.utils.color.Color;
import com.resourcefulbees.resourcefulbees.utils.color.RainbowColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.provider.GeoModelProvider;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;

public class InterfaceBeeRenderer
implements IGeoRenderer<PetModelData> {
    private final PetBeeModel<PetModelData> instance = new PetBeeModel();

    public GeoModelProvider<PetModelData> getGeoModelProvider() {
        return this.instance;
    }

    public ResourceLocation getTextureLocation(PetModelData instance) {
        return instance.getTexture();
    }

    public void render(PetModelData bee, @NotNull MatrixStack stack, float partialTicks, int tickCount, int x, int y, float modelScale, float rotation) {
        this.instance.setLivingAnimations(bee, bee.hashCode());
        stack.func_227860_a_();
        stack.func_227861_a_((double)x, (double)y, (double)(10.0f * modelScale));
        stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        stack.func_227862_a_(-(20.0f * modelScale), 20.0f * modelScale, 20.0f * modelScale);
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-10.0f));
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        IVertexBuilder vertexConsumer = buffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)bee.getTexture()));
        GeoModel model = this.instance.getModel(bee);
        this.render(model, bee, partialTicks, null, stack, null, vertexConsumer, 200, OverlayTexture.func_229201_a_((int)OverlayTexture.func_229199_a_((float)0.0f), (int)OverlayTexture.func_229202_a_((boolean)false)), 1.0f, 1.0f, 1.0f, 1.0f);
        bee.getLayers().forEach(l -> this.renderLayer((LayerData)l, model, bee, partialTicks, stack, tickCount, (IRenderTypeBuffer)buffer));
        buffer.func_228461_a_();
        stack.func_227865_b_();
    }

    private void renderLayer(LayerData layer, GeoModel model, PetModelData bee, float partialTicks, @NotNull MatrixStack stack, int tickCount, IRenderTypeBuffer buffer) {
        Color color;
        Color color2 = color = "rainbow".equals(layer.getColor()) ? new Color(RainbowColor.getRGB()) : Color.tryParse(layer.getColor(), -1);
        if (layer.isEnchanted()) {
            RenderType renderType = RenderType.func_228655_k_();
            this.render(model, bee, partialTicks, renderType, stack, buffer, buffer.getBuffer(renderType), 100, OverlayTexture.field_229196_a_, 0.0f, 0.0f, 0.0f, 0.0f);
        } else if (layer.isEmissive()) {
            IVertexBuilder vertexConsumer = buffer.getBuffer(RenderType.func_228652_i_((ResourceLocation)layer.getBeeTexture()));
            if (layer.getPulseFrequency() == 0.0f || (float)tickCount % layer.getPulseFrequency() == 0.0f) {
                this.render(model, bee, partialTicks, null, stack, null, vertexConsumer, 0xF00000, OverlayTexture.field_229196_a_, color.getR(), color.getG(), color.getB(), 1.0f);
            }
        } else {
            IVertexBuilder vertexConsumer = buffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)layer.getBeeTexture()));
            this.render(model, bee, partialTicks, null, stack, null, vertexConsumer, 100, OverlayTexture.func_229201_a_((int)OverlayTexture.func_229199_a_((float)0.0f), (int)OverlayTexture.func_229202_a_((boolean)false)), color.getR(), color.getG(), color.getB(), 1.0f);
        }
    }
}

