/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.mutations;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.outputs.ItemOutput;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.BeepediaScreen;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.BeePage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.mutations.MutationsPage;
import com.resourcefulbees.resourcefulbees.item.BeeSpawnEggItem;
import com.resourcefulbees.resourcefulbees.lib.MutationTypes;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import com.resourcefulbees.resourcefulbees.utils.RandomCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Pair;

public class ItemMutationPage
extends MutationsPage {
    List<Block> inputs;
    List<Pair<Double, ItemOutput>> outputs = new ArrayList<Pair<Double, ItemOutput>>();
    private Double outputChance;

    public ItemMutationPage(EntityType<?> bee, List<Block> blocks, Pair<Double, RandomCollection<ItemOutput>> outputs, MutationTypes type, int mutationCount, BeepediaScreen beepedia) {
        super(bee, type, mutationCount, beepedia);
        this.inputs = blocks;
        this.initOutputs(outputs);
    }

    public ItemMutationPage(BeePage parent, ITag<?> blocks, Pair<Double, RandomCollection<ItemOutput>> outputs, MutationTypes type, int mutationCount, BeepediaScreen beepedia) {
        super(parent, type, mutationCount, beepedia);
        this.inputs = blocks.func_230236_b_();
        this.initOutputs(outputs);
    }

    public ItemMutationPage(BeePage parent, Block block, Pair<Double, RandomCollection<ItemOutput>> outputs, MutationTypes type, int mutationCount, BeepediaScreen beepedia) {
        super(parent, type, mutationCount, beepedia);
        this.inputs = new LinkedList<Block>(Collections.singleton(block));
        this.initOutputs(outputs);
    }

    private void initOutputs(Pair<Double, RandomCollection<ItemOutput>> outputs) {
        this.outputChance = (Double)outputs.getKey();
        RandomCollection collection = (RandomCollection)outputs.getRight();
        collection.getMap().forEach((b, m) -> this.outputs.add((Pair<Double, ItemOutput>)Pair.of((Object)collection.getAdjustedWeight(m.getWeight()), (Object)m)));
    }

    @Override
    public void tick(int ticksActive) {
        if (ticksActive % 20 == 0 && !BeeInfoUtils.isShiftPressed()) {
            ++this.inputCounter;
            ++this.outputCounter;
            if (this.inputCounter >= this.inputs.size()) {
                this.inputCounter = 0;
            }
            if (this.outputCounter >= this.outputs.size()) {
                this.outputCounter = 0;
            }
        }
    }

    @Override
    public void draw(MatrixStack matrix, int xPos, int yPos) {
        super.draw(matrix, xPos, yPos);
        this.beepedia.drawSlot(matrix, this.inputs.get(this.inputCounter), xPos + 32, yPos + 32);
        ItemOutput output = (ItemOutput)this.outputs.get(this.outputCounter).getRight();
        ItemStack item = new ItemStack((IItemProvider)output.getItem());
        if (!output.getCompoundNBT().isEmpty()) {
            item.func_77982_d(output.getCompoundNBT());
        }
        this.beepedia.drawSlot(matrix, item, xPos + 112, yPos + 32);
        this.drawWeight(matrix, (Double)this.outputs.get(this.outputCounter).getLeft(), xPos + 122, yPos + 54);
        if (this.outputChance < 1.0) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.infoIcon);
            this.beepedia.func_238474_b_(matrix, xPos + 84 - 20, yPos + 51, 16, 0, 9, 9);
            this.drawChance(matrix, this.outputChance, xPos + 84, yPos + 52);
        }
    }

    @Override
    public boolean mouseClick(int xPos, int yPos, int mouseX, int mouseY) {
        if (super.mouseClick(xPos, yPos, mouseX, mouseY)) {
            return true;
        }
        Item output = ((ItemOutput)this.outputs.get(this.outputCounter).getRight()).getItem();
        if (output instanceof BeeSpawnEggItem) {
            BeeSpawnEggItem beeEgg = (BeeSpawnEggItem)output;
            if (BeepediaScreen.mouseHovering((float)xPos + 112.0f, (float)yPos + 27.0f, 30, 30, mouseX, mouseY)) {
                if (BeepediaScreen.currScreenState.getPageID().equals(beeEgg.getBeeData().getName())) {
                    return false;
                }
                BeepediaScreen.saveScreenState();
                this.beepedia.setActive(BeepediaScreen.PageType.BEE, beeEgg.getBeeData().getName());
                return true;
            }
        }
        return false;
    }

    @Override
    public void drawTooltips(MatrixStack matrix, int xPos, int yPos, int mouseX, int mouseY) {
        super.drawTooltips(matrix, xPos, yPos, mouseX, mouseY);
        if (this.outputChance < 1.0 && BeepediaScreen.mouseHovering((float)xPos + 84.5f - 20.0f, (float)yPos + 51.0f, 8, 8, mouseX, mouseY)) {
            this.beepedia.func_238652_a_(matrix, (ITextComponent)new TranslationTextComponent("gui.resourcefulbees.jei.category.mutation_chance.info"), mouseX, mouseY);
        }
    }

    @Override
    public String getSearch() {
        String search = "";
        for (Block block : this.inputs) {
            search = String.format("%s %s", search, block.func_235333_g_().getString());
        }
        for (Pair pair : this.outputs) {
            search = String.format("%s %s", search, ((ItemOutput)pair.getRight()).getItem().func_200295_i(new ItemStack((IItemProvider)((ItemOutput)pair.getRight()).getItem())).getString());
        }
        return search;
    }
}

