/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.mutations;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.outputs.BlockOutput;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.BeepediaScreen;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.BeePage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.mutations.MutationsPage;
import com.resourcefulbees.resourcefulbees.lib.MutationTypes;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import com.resourcefulbees.resourcefulbees.utils.RandomCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.fluid.Fluid;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Pair;

public class BlockMutationPage
extends MutationsPage {
    List<Block> inputs;
    double outputChance;
    List<Pair<Double, BlockOutput>> outputs = new ArrayList<Pair<Double, BlockOutput>>();

    public BlockMutationPage(BeePage parent, ITag<?> blocks, Pair<Double, RandomCollection<BlockOutput>> outputs, MutationTypes type, int mutationCount, BeepediaScreen beepedia) {
        super(parent, type, mutationCount, beepedia);
        this.inputs = blocks.func_230236_b_().get(0) instanceof Fluid ? blocks.func_230236_b_().stream().map(f -> ((Fluid)f).func_207188_f().func_206883_i().func_177230_c()).distinct().collect(Collectors.toList()) : blocks.func_230236_b_();
        this.initOutputs(outputs);
    }

    public BlockMutationPage(BeePage parent, Block block, Pair<Double, RandomCollection<BlockOutput>> outputs, MutationTypes type, int mutationCount, BeepediaScreen beepedia) {
        super(parent, type, mutationCount, beepedia);
        this.inputs = new LinkedList<Block>(Collections.singleton(block));
        this.initOutputs(outputs);
    }

    private void initOutputs(Pair<Double, RandomCollection<BlockOutput>> outputs) {
        this.outputChance = (Double)outputs.getKey();
        RandomCollection collection = (RandomCollection)outputs.getRight();
        collection.getMap().forEach((b, m) -> this.outputs.add((Pair<Double, BlockOutput>)Pair.of((Object)collection.getAdjustedWeight(m.getWeight()), (Object)m)));
    }

    @Override
    public void tick(int ticksActive) {
        if (ticksActive % 20 == 0 && !BeeInfoUtils.isShiftPressed()) {
            ++this.inputCounter;
            ++this.outputCounter;
            if (this.inputCounter >= this.inputs.size()) {
                this.inputCounter = 0;
            }
            if (this.outputCounter >= this.outputs.size()) {
                this.outputCounter = 0;
            }
        }
    }

    @Override
    public void draw(MatrixStack matrix, int xPos, int yPos) {
        super.draw(matrix, xPos, yPos);
        this.beepedia.drawSlot(matrix, this.inputs.get(this.inputCounter), xPos + 32, yPos + 32);
        this.beepedia.drawSlotNoToolTip(matrix, (IItemProvider)((BlockOutput)this.outputs.get(this.outputCounter).getRight()).getBlock(), xPos + 112, yPos + 32);
        this.drawWeight(matrix, (Double)this.outputs.get(this.outputCounter).getLeft(), xPos + 122, yPos + 54);
        if (this.outputChance < 1.0) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.infoIcon);
            this.beepedia.func_238474_b_(matrix, xPos + 84 - 20, yPos + 51, 16, 0, 9, 9);
            this.drawChance(matrix, this.outputChance, xPos + 84, yPos + 52);
        }
    }

    @Override
    public boolean mouseClick(int xPos, int yPos, int mouseX, int mouseY) {
        return super.mouseClick(xPos, yPos, mouseX, mouseY);
    }

    @Override
    public void drawTooltips(MatrixStack matrix, int xPos, int yPos, int mouseX, int mouseY) {
        super.drawTooltips(matrix, xPos, yPos, mouseX, mouseY);
        if (BeepediaScreen.mouseHovering((float)xPos + 112.0f, (float)yPos + 32.0f, 20, 20, mouseX, mouseY)) {
            BlockOutput output = (BlockOutput)this.outputs.get(this.outputCounter).getRight();
            ArrayList<IFormattableTextComponent> tooltip = new ArrayList<IFormattableTextComponent>();
            IFormattableTextComponent name = output.getBlock().func_235333_g_();
            IFormattableTextComponent id = new StringTextComponent(output.getBlock().getRegistryName().toString()).func_240699_a_(TextFormatting.DARK_GRAY);
            tooltip.add(name);
            tooltip.add(id);
            if (!output.getCompoundNBT().isEmpty()) {
                if (BeeInfoUtils.isShiftPressed()) {
                    List<String> lore = BeeInfoUtils.getLoreLines(output.getCompoundNBT());
                    lore.forEach(l -> tooltip.add(new StringTextComponent(l).func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240745_a_((String)"dark_purple")))));
                } else {
                    tooltip.add(new TranslationTextComponent("gui.resourcefulbees.jei.tooltip.show_nbt").func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240745_a_((String)"dark_purple"))));
                }
            }
            this.beepedia.func_243308_b(matrix, tooltip, mouseX, mouseY);
        }
        if (this.outputChance < 1.0 && BeepediaScreen.mouseHovering((float)xPos + 84.5f - 20.0f, (float)yPos + 51.0f, 8, 8, mouseX, mouseY)) {
            this.beepedia.func_238652_a_(matrix, (ITextComponent)new TranslationTextComponent("gui.resourcefulbees.jei.category.mutation_chance.info"), mouseX, mouseY);
        }
    }

    @Override
    public String getSearch() {
        String search = "";
        for (Block block : this.inputs) {
            search = String.format("%s %s", search, block.func_235333_g_().getString());
        }
        for (Pair pair : this.outputs) {
            search = String.format("%s %s", search, ((BlockOutput)pair.getRight()).getBlock().func_235333_g_().getString());
        }
        return search;
    }
}

