/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.api.traitdata.BeeAura;
import com.resourcefulbees.resourcefulbees.api.traitdata.BeeTrait;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.BeepediaPage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.BeepediaScreen;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.BeePage;
import com.resourcefulbees.resourcefulbees.client.gui.widget.ListButton;
import com.resourcefulbees.resourcefulbees.client.gui.widget.SubButtonList;
import com.resourcefulbees.resourcefulbees.item.BeeJar;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class TraitPage
extends BeepediaPage {
    public final BeeTrait trait;
    private final ImageButton prevTab;
    private final ImageButton nextTab;
    String translation;
    private SubButtonList list;
    TranslationTextComponent name;
    private final List<TraitSection> traitSections = new LinkedList<TraitSection>();
    private static final int LIST_HEIGHT = 102;

    public TraitPage(BeepediaScreen beepedia, BeeTrait trait, String id, int left, int top) {
        super(beepedia, left, top, id);
        this.trait = trait;
        this.initTranslation();
        this.name = new TranslationTextComponent(trait.getTranslationKey());
        ItemStack stack = new ItemStack((IItemProvider)trait.getBeepediaItem());
        this.newListButton(stack, (ITextComponent)this.name);
        this.prevTab = new ImageButton(this.xPos + 84 - 48, this.yPos + 40, 8, 11, 0, 0, 11, this.arrowImage, 16, 33, button -> this.toggleTab());
        this.nextTab = new ImageButton(this.xPos + 84 + 40, this.yPos + 40, 8, 11, 8, 0, 11, this.arrowImage, 16, 33, button -> this.toggleTab());
        beepedia.func_230480_a_(this.nextTab);
        beepedia.func_230480_a_(this.prevTab);
        this.nextTab.field_230694_p_ = false;
        this.prevTab.field_230694_p_ = false;
        this.addSpecialAbilities();
        this.addDamageImmunities();
        this.addPotionImmunities();
        this.addPotionDamageEffects();
        this.addDamageTypes();
        this.addParticle();
        this.addAuras();
    }

    private void addAuras() {
        if (this.trait.hasBeeAuras()) {
            for (BeeAura aura : this.trait.getAuras()) {
                ItemStack item;
                TranslationTextComponent text;
                TranslationTextComponent title;
                switch (aura.auraType) {
                    case BURNING: {
                        title = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.traits.auras.burning");
                        text = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.traits.auras.burning_explanation");
                        item = new ItemStack((IItemProvider)Items.field_151059_bz);
                        break;
                    }
                    case EXPERIENCE: {
                        title = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.traits.auras.experience");
                        text = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.traits.auras.experience_explanation", new Object[]{aura.strength});
                        item = new ItemStack((IItemProvider)Items.field_151062_by);
                        break;
                    }
                    case EXPERIENCE_DRAIN: {
                        title = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.traits.auras.experience_drain");
                        text = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.traits.auras.experienced_drain_explanation", new Object[]{aura.strength});
                        item = new ItemStack((IItemProvider)Items.field_222105_pL);
                        break;
                    }
                    case DAMAGING: {
                        title = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.traits.auras.damaging");
                        text = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.traits.auras.damaging_explanation", new Object[]{aura.strength});
                        item = new ItemStack((IItemProvider)Items.field_151032_g);
                        break;
                    }
                    case HEALING: {
                        title = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.traits.auras.healing");
                        text = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.traits.auras.healing_explanation", new Object[]{aura.strength});
                        item = new ItemStack((IItemProvider)Items.field_151060_bw);
                        break;
                    }
                    case POTION: {
                        IFormattableTextComponent potion = aura.potionEffect.func_199286_c().func_230531_f_().func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent(String.format("enchantment.level.%d", aura.strength + 1)));
                        title = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.traits.auras.potion");
                        text = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.traits.auras.potion_explanation", new Object[]{potion.getString()});
                        item = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185156_bI), (Potion)Potions.field_185235_g);
                        break;
                    }
                    default: {
                        title = new StringTextComponent("gui.resourcefulbees.beepedia.tab.traits.auras.error");
                        text = new StringTextComponent("gui.resourcefulbees.beepedia.tab.traits.auras.error_explanation");
                        item = new ItemStack((IItemProvider)Items.field_221803_eL);
                    }
                }
                if (!aura.calmingDisabled) {
                    text.func_230529_a_((ITextComponent)(aura.isBeneficial() ? new TranslationTextComponent("gui.resourcefulbees.tab.traits.aura.not_calming_disabled.helpful") : new TranslationTextComponent("gui.resourcefulbees.tab.traits.aura.not_calming_disabled.dangerous")));
                } else {
                    text.func_230529_a_((ITextComponent)new TranslationTextComponent("gui.resourcefulbees.tab.traits.aura.calming_disabled"));
                }
                this.traitSections.add(new TraitSection((ITextComponent)title, item, (ITextComponent)text));
            }
        }
    }

    private void addParticle() {
        if (this.trait.hasParticleEffect()) {
            TranslationTextComponent title = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.traits.particle");
            StringTextComponent text = new StringTextComponent(this.trait.getParticleEffect().func_197555_a());
            this.traitSections.add(new TraitSection((ITextComponent)title, new ItemStack((IItemProvider)Items.field_196152_dE), (ITextComponent)text));
        }
    }

    private void addDamageTypes() {
        if (this.trait.hasDamageTypes()) {
            TranslationTextComponent title = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.traits.damageTypes");
            StringTextComponent text = new StringTextComponent("");
            for (int i = 0; i < this.trait.getDamageTypes().size(); ++i) {
                Pair<String, Integer> damage = this.trait.getDamageTypes().get(i);
                text.func_240702_b_((String)damage.getKey() + " ");
                text.func_230529_a_((ITextComponent)new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.traits.amplifier"));
                text.func_240702_b_(((Integer)damage.getRight()).toString());
                if (i == this.trait.getPotionDamageEffects().size() - 1) continue;
                text.func_240702_b_(", ");
            }
            this.traitSections.add(new TraitSection((ITextComponent)title, new ItemStack((IItemProvider)Items.field_151040_l), (ITextComponent)text));
        }
    }

    private void addPotionDamageEffects() {
        if (this.trait.hasDamagePotionEffects()) {
            TranslationTextComponent title = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.traits.potion_damage_effects");
            StringTextComponent text = new StringTextComponent("");
            for (int i = 0; i < this.trait.getPotionDamageEffects().size(); ++i) {
                Pair<Effect, Integer> effect = this.trait.getPotionDamageEffects().get(i);
                text.func_230529_a_(((Effect)effect.getKey()).func_199286_c());
                text.func_240702_b_(" ");
                text.func_230529_a_((ITextComponent)new TranslationTextComponent(String.format("enchantment.level.%d", (Integer)effect.getRight() + 1)));
                if (i == this.trait.getPotionDamageEffects().size() - 1) continue;
                text.func_240702_b_(", ");
            }
            this.traitSections.add(new TraitSection((ITextComponent)title, PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185252_x), (ITextComponent)text));
        }
    }

    private void addDamageImmunities() {
        if (this.trait.hasDamageImmunities()) {
            TranslationTextComponent title = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.traits.damage_immunities");
            String typeList = String.join((CharSequence)", ", this.trait.getDamageImmunities());
            this.traitSections.add(new TraitSection((ITextComponent)title, new ItemStack((IItemProvider)Items.field_151030_Z), (ITextComponent)new StringTextComponent(typeList)));
        }
    }

    private void addPotionImmunities() {
        if (this.trait.hasPotionImmunities()) {
            TranslationTextComponent title = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.traits.potion_immunities");
            List effectNames = this.trait.getPotionImmunities().stream().map(Effect::func_199286_c).collect(Collectors.toList());
            StringTextComponent text = new StringTextComponent("");
            for (int i = 0; i < effectNames.size(); ++i) {
                text.func_230529_a_((ITextComponent)effectNames.get(i));
                if (i == effectNames.size() - 1) continue;
                text.func_240702_b_(", ");
            }
            this.traitSections.add(new TraitSection((ITextComponent)title, new ItemStack((IItemProvider)Items.field_151117_aB), (ITextComponent)text));
        }
    }

    private void addSpecialAbilities() {
        if (this.trait.hasSpecialAbilities()) {
            this.trait.getSpecialAbilities().forEach(s -> {
                ItemStack item;
                TranslationTextComponent title = new TranslationTextComponent(String.format("trait.%s.%s", "resourcefulbees", s));
                TranslationTextComponent text = new TranslationTextComponent(String.format("trait.%s.special.%s", "resourcefulbees", s));
                switch (s) {
                    case "flammable": {
                        item = new ItemStack((IItemProvider)Items.field_151059_bz);
                        break;
                    }
                    case "slimy": {
                        item = new ItemStack((IItemProvider)Items.field_151123_aH);
                        break;
                    }
                    case "angry": {
                        item = new ItemStack((IItemProvider)Items.field_151065_br);
                        break;
                    }
                    case "teleport": {
                        item = new ItemStack((IItemProvider)Items.field_151079_bi);
                        break;
                    }
                    case "spider": {
                        item = new ItemStack((IItemProvider)Items.field_221672_ax);
                        break;
                    }
                    case "clingy": {
                        item = new ItemStack((IItemProvider)Items.field_151058_ca);
                        break;
                    }
                    default: {
                        item = new ItemStack((IItemProvider)Items.field_221803_eL);
                    }
                }
                this.traitSections.add(new TraitSection((ITextComponent)title, item, (ITextComponent)text));
            });
        }
    }

    private void toggleTab() {
        BeepediaScreen.currScreenState.setTraitsEffectsActive(!BeepediaScreen.currScreenState.isTraitsEffectsActive());
        this.list.setActive(!BeepediaScreen.currScreenState.isTraitsEffectsActive());
    }

    private void initTranslation() {
        this.translation = "";
        this.translation = this.translation + String.join((CharSequence)" ", this.trait.getDamageImmunities());
        this.translation = this.translation + String.join((CharSequence)" ", this.trait.getSpecialAbilities());
        this.translation = this.translation + this.trait.getPotionImmunities().stream().map(effect -> effect.func_199286_c().getString()).collect(Collectors.joining(" "));
        this.translation = this.translation + this.trait.getDamageTypes().stream().map(Pair::getLeft).collect(Collectors.joining(" "));
        this.translation = this.translation + this.trait.getPotionDamageEffects().stream().map(pair -> ((Effect)pair.getLeft()).func_199286_c().getString()).collect(Collectors.joining(" "));
    }

    @Override
    public void renderBackground(MatrixStack matrix, float partialTick, int mouseX, int mouseY) {
        if (this.list == null) {
            return;
        }
        this.list.updateList();
        this.beepedia.drawSlotNoToolTip(matrix, (IItemProvider)this.trait.getBeepediaItem(), this.xPos, this.yPos + 10);
        this.beepedia.getMinecraft().field_71446_o.func_110577_a(this.splitterImage);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)this.xPos, (int)(this.yPos - 14), (float)0.0f, (float)0.0f, (int)165, (int)100, (int)165, (int)100);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        StringTextComponent key = new StringTextComponent(this.id);
        font.func_243248_b(matrix, (ITextComponent)this.name.func_240699_a_(TextFormatting.WHITE), (float)this.xPos + 24.0f, (float)this.yPos + 12.0f, -1);
        font.func_243248_b(matrix, (ITextComponent)key.func_240699_a_(TextFormatting.DARK_GRAY), (float)this.xPos + 24.0f, (float)this.yPos + 22.0f, -1);
        if (BeepediaScreen.currScreenState.isTraitsEffectsActive()) {
            this.drawEffectsList(matrix, this.xPos, this.yPos + 34);
        } else {
            this.drawBeesList(matrix, this.xPos, this.yPos + 34);
        }
    }

    private void drawBeesList(MatrixStack matrix, int xPos, int yPos) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        TranslationTextComponent title = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.traits.bees_list");
        int padding = font.func_238414_a_((ITextProperties)title) / 2;
        font.func_243248_b(matrix, (ITextComponent)title.func_240699_a_(TextFormatting.WHITE), (float)xPos + 84.5f - (float)padding, (float)yPos + 8.0f, -1);
    }

    private void drawEffectsList(MatrixStack matrix, int xPos, int yPos) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        TranslationTextComponent title = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.traits.effects_list");
        int padding = font.func_238414_a_((ITextProperties)title) / 2;
        font.func_243248_b(matrix, (ITextComponent)title.func_240699_a_(TextFormatting.WHITE), (float)xPos + 84.5f - (float)padding, (float)yPos + 8.0f, -1);
        GL11.glEnable((int)3089);
        double scale = this.beepedia.getMinecraft().func_228018_at_().func_198100_s();
        int scissorY = (int)((double)this.beepedia.getMinecraft().func_228018_at_().func_198091_l() - (double)(this.yPos + 156) * scale);
        GL11.glScissor((int)((int)((double)this.xPos * scale)), (int)scissorY, (int)((int)(169.0 * scale)), (int)((int)(102.0 * scale)));
        int sectionPos = yPos + 20;
        for (int i = 0; i < this.traitSections.size(); ++i) {
            if (i > 0) {
                sectionPos += this.traitSections.get(i - 1).getHeight();
            }
            this.traitSections.get(i).draw(matrix, xPos, sectionPos, BeepediaScreen.currScreenState.getTraitEffectsListPos());
        }
        GL11.glDisable((int)3089);
    }

    private void initList() {
        Map<String, BeePage> beePages = this.beepedia.getBees(this.id);
        TreeMap<String, ListButton> buttons = new TreeMap<String, ListButton>();
        for (Map.Entry<String, BeePage> e : beePages.entrySet()) {
            ItemStack stack = new ItemStack((IItemProvider)ModItems.BEE_JAR.get());
            BeeJar.fillJar(stack, e.getValue().beeData);
            Button.IPressable onPress = button -> {
                BeepediaScreen.saveScreenState();
                this.beepedia.setActive(BeepediaScreen.PageType.BEE, (String)e.getKey());
            };
            ListButton button2 = new ListButton(0, 0, 100, 20, 0, 0, 20, this.listImage, stack, 2, 2, (ITextComponent)e.getValue().beeData.getTranslation(), 22, 6, onPress);
            this.beepedia.func_230480_a_(button2);
            button2.field_230694_p_ = false;
            buttons.put(e.getKey(), button2);
        }
        this.list = new SubButtonList(this.xPos, this.yPos + 54, 169, 102, 21, null, (SortedMap<String, ListButton>)buttons);
        this.list.setActive(false);
    }

    @Override
    public String getSearch() {
        return this.translation;
    }

    @Override
    public void openPage() {
        super.openPage();
        if (this.list == null) {
            this.initList();
        }
        this.list.setActive(!BeepediaScreen.currScreenState.isTraitsEffectsActive());
        this.list.setScrollPos(BeepediaScreen.currScreenState.getTraitBeeListPos());
        this.nextTab.field_230694_p_ = true;
        this.prevTab.field_230694_p_ = true;
        int effectsHeight = this.traitSections.stream().mapToInt(TraitSection::getHeight).sum();
        if (effectsHeight < 102) {
            BeepediaScreen.currScreenState.setTraitEffectsListPos(0);
        } else if (BeepediaScreen.currScreenState.getTraitEffectsListPos() > effectsHeight - 102) {
            BeepediaScreen.currScreenState.setTraitEffectsListPos(effectsHeight - 102);
        }
    }

    @Override
    public void closePage() {
        super.closePage();
        this.list.setActive(false);
        this.nextTab.field_230694_p_ = false;
        this.prevTab.field_230694_p_ = false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollAmount) {
        int startPos = 54;
        if (mouseX >= (double)this.xPos && mouseY >= (double)(this.yPos + startPos) && mouseX <= (double)(this.xPos + 169) && mouseY <= (double)(this.yPos + startPos + 102)) {
            if (BeepediaScreen.currScreenState.isTraitsEffectsActive()) {
                return this.addScrollPos(scrollAmount * 8.0);
            }
            this.list.updatePos((int)(scrollAmount * 8.0));
            BeepediaScreen.currScreenState.setTraitBeeListPos(this.list.getScrollPos());
            return true;
        }
        return false;
    }

    private boolean addScrollPos(double v) {
        int scrollPos = BeepediaScreen.currScreenState.getTraitEffectsListPos();
        int effectsHeight = this.traitSections.stream().mapToInt(TraitSection::getHeight).sum();
        if (effectsHeight < 102) {
            return false;
        }
        if ((scrollPos = (int)((double)scrollPos + v)) > 0) {
            scrollPos = 0;
        } else if (scrollPos < -(effectsHeight - 102)) {
            scrollPos = -(effectsHeight - 102);
        }
        BeepediaScreen.currScreenState.setTraitEffectsListPos(scrollPos);
        return true;
    }

    private class TraitSection {
        FontRenderer font;
        ITextComponent title;
        ItemStack displaySlot;
        ITextComponent text;
        int width = 169;

        public TraitSection(ITextComponent title, ItemStack displaySlot, ITextComponent text) {
            this.title = new StringTextComponent(title.getString()).func_240699_a_(TextFormatting.WHITE);
            this.displaySlot = displaySlot;
            this.text = new StringTextComponent(text.getString()).func_240699_a_(TextFormatting.GRAY);
            this.font = Minecraft.func_71410_x().field_71466_p;
        }

        public void draw(MatrixStack matrix, int xPos, int yPos, int scrollPos) {
            TraitPage.this.beepedia.drawSlotNoToolTip(matrix, this.displaySlot, xPos, yPos + scrollPos);
            this.font.func_243248_b(matrix, this.title, (float)xPos + 24.0f, (float)yPos + 6.0f + (float)scrollPos, -1);
            List lines = this.font.func_238425_b_((ITextProperties)this.text, this.width);
            for (int i = 0; i < lines.size(); ++i) {
                IReorderingProcessor line = (IReorderingProcessor)lines.get(i);
                float f = xPos;
                float f2 = (float)yPos + 24.0f;
                this.font.getClass();
                this.font.func_238422_b_(matrix, line, f, f2 + (float)(i * 9) + (float)scrollPos, -1);
            }
        }

        public int getHeight() {
            return this.font.func_78267_b(this.text.getString(), this.width) + 30;
        }
    }
}

