/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.BeepediaScreen;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.BeeDataPage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.BeePage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.TraitPage;
import com.resourcefulbees.resourcefulbees.client.gui.widget.ListButton;
import com.resourcefulbees.resourcefulbees.client.gui.widget.SubButtonList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class TraitListPage
extends BeeDataPage {
    private SubButtonList list = null;

    public TraitListPage(BeepediaScreen beepedia, CustomBeeData beeData, int xPos, int yPos, BeePage parent) {
        super(beepedia, beeData, xPos, yPos, parent);
    }

    @Override
    public void renderBackground(MatrixStack matrix, float partialTick, int mouseX, int mouseY) {
        if (this.list == null) {
            return;
        }
        TranslationTextComponent title = new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.traits");
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        font.func_243248_b(matrix, (ITextComponent)title.func_240699_a_(TextFormatting.WHITE), (float)this.xPos, (float)this.yPos + 8.0f, -1);
        this.list.updateList();
    }

    @Override
    public String getSearch() {
        return String.join((CharSequence)" ", this.beeData.getTraitNames());
    }

    private void initList() {
        Map<String, TraitPage> traitPages = this.beepedia.getTraits(this.beeData);
        TreeMap<String, ListButton> buttons = new TreeMap<String, ListButton>();
        for (Map.Entry<String, TraitPage> e : traitPages.entrySet()) {
            ItemStack stack = new ItemStack((IItemProvider)e.getValue().trait.getBeepediaItem());
            TranslationTextComponent text = new TranslationTextComponent(e.getValue().trait.getTranslationKey());
            Button.IPressable onPress = button -> {
                BeepediaScreen.saveScreenState();
                this.beepedia.setActive(BeepediaScreen.PageType.TRAIT, (String)e.getKey());
            };
            ListButton button2 = new ListButton(0, 0, 100, 20, 0, 0, 20, this.listImage, stack, 2, 2, (ITextComponent)text, 22, 6, onPress);
            this.beepedia.func_230480_a_(button2);
            button2.field_230694_p_ = false;
            buttons.put(e.getKey(), button2);
        }
        this.list = new SubButtonList(this.xPos, this.yPos + 22, 169, 84, 21, null, (SortedMap<String, ListButton>)buttons);
        this.list.setActive(false);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollAmount) {
        if (mouseX >= (double)this.xPos && mouseY >= (double)(this.yPos + 22) && mouseX <= (double)(this.xPos + 169) && mouseY <= (double)(this.yPos + 106)) {
            this.list.updatePos((int)(scrollAmount * 8.0));
            BeepediaScreen.currScreenState.setTraitsScroll(this.list.getScrollPos());
            return true;
        }
        return false;
    }

    @Override
    public void openPage() {
        super.openPage();
        if (this.list == null) {
            this.initList();
        }
        this.list.setActive(true);
        this.list.setScrollPos(BeepediaScreen.currScreenState.getTraitsScroll());
    }

    @Override
    public void closePage() {
        super.closePage();
        if (this.list != null) {
            this.list.setActive(false);
        }
    }
}

