/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.outputs.BlockOutput;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.outputs.EntityOutput;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.outputs.ItemOutput;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.BeepediaScreen;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.BeeDataPage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.BeePage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.mutations.BlockMutationPage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.mutations.EntityMutationPage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.mutations.ItemMutationPage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.mutations.MutationsPage;
import com.resourcefulbees.resourcefulbees.lib.MutationTypes;
import com.resourcefulbees.resourcefulbees.utils.RandomCollection;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.EntityType;
import net.minecraft.tags.ITag;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Pair;

public class MutationListPage
extends BeeDataPage {
    List<Pair<MutationTypes, List<MutationsPage>>> mutations = new ArrayList<Pair<MutationTypes, List<MutationsPage>>>();
    private List<MutationsPage> activeList = null;
    int tab;
    private int page;
    private MutationsPage activePage = null;
    Button prevTab;
    Button nextTab;
    Button leftArrow;
    Button rightArrow;

    public MutationListPage(BeepediaScreen beepedia, CustomBeeData beeData, int xPos, int yPos, BeePage parent) {
        super(beepedia, beeData, xPos, yPos, parent);
        this.prevTab = new ImageButton(xPos + 84 - 48, yPos + 6, 8, 11, 0, 0, 11, this.arrowImage, 16, 33, button -> this.prevTab());
        this.nextTab = new ImageButton(xPos + 84 + 40, yPos + 6, 8, 11, 8, 0, 11, this.arrowImage, 16, 33, button -> this.nextTab());
        this.leftArrow = new ImageButton(xPos + 84 - 28, yPos + 106 - 16, 8, 11, 0, 0, 11, this.arrowImage, 16, 33, button -> this.prevPage());
        this.rightArrow = new ImageButton(xPos + 84 + 20, yPos + 106 - 16, 8, 11, 8, 0, 11, this.arrowImage, 16, 33, button -> this.nextPage());
        beepedia.func_230480_a_(this.prevTab);
        beepedia.func_230480_a_(this.nextTab);
        beepedia.func_230480_a_(this.leftArrow);
        beepedia.func_230480_a_(this.rightArrow);
        this.prevTab.field_230694_p_ = false;
        this.nextTab.field_230694_p_ = false;
        this.leftArrow.field_230694_p_ = false;
        this.rightArrow.field_230694_p_ = false;
        ArrayList blockMutations = new ArrayList();
        ArrayList itemMutations = new ArrayList();
        ArrayList entityMutations = new ArrayList();
        if (beeData.getMutationData().hasBlockMutations()) {
            beeData.getMutationData().getJeiBlockMutations().forEach((b, m) -> blockMutations.add(new BlockMutationPage(parent, (Block)b, (Pair<Double, RandomCollection<BlockOutput>>)m, MutationTypes.BLOCK, beeData.getMutationData().getMutationCount(), beepedia)));
            beeData.getMutationData().getJeiBlockTagMutations().forEach((b, m) -> blockMutations.add(new BlockMutationPage(parent, (ITag<?>)b, (Pair<Double, RandomCollection<BlockOutput>>)m, MutationTypes.BLOCK, beeData.getMutationData().getMutationCount(), beepedia)));
        }
        if (beeData.getMutationData().hasItemMutations()) {
            beeData.getMutationData().getJeiItemMutations().forEach((b, m) -> itemMutations.add(new ItemMutationPage(parent, (Block)b, (Pair<Double, RandomCollection<ItemOutput>>)m, MutationTypes.ITEM, beeData.getMutationData().getMutationCount(), beepedia)));
            beeData.getMutationData().getJeiBlockTagItemMutations().forEach((b, m) -> itemMutations.add(new ItemMutationPage(parent, (ITag<?>)b, (Pair<Double, RandomCollection<ItemOutput>>)m, MutationTypes.ITEM, beeData.getMutationData().getMutationCount(), beepedia)));
        }
        if (beeData.getMutationData().hasEntityMutations()) {
            beeData.getMutationData().getEntityMutations().forEach((b, m) -> entityMutations.add(new EntityMutationPage(parent, (EntityType<?>)b, (Pair<Double, RandomCollection<EntityOutput>>)m, MutationTypes.ENTITY, beeData.getMutationData().getMutationCount(), beepedia)));
        }
        if (!blockMutations.isEmpty()) {
            this.mutations.add((Pair<MutationTypes, List<MutationsPage>>)Pair.of((Object)((Object)MutationTypes.BLOCK), blockMutations));
        }
        if (!itemMutations.isEmpty()) {
            this.mutations.add((Pair<MutationTypes, List<MutationsPage>>)Pair.of((Object)((Object)MutationTypes.ITEM), itemMutations));
        }
        if (!entityMutations.isEmpty()) {
            this.mutations.add((Pair<MutationTypes, List<MutationsPage>>)Pair.of((Object)((Object)MutationTypes.ENTITY), entityMutations));
        }
    }

    private void nextPage() {
        if (this.activeList == null) {
            return;
        }
        ++this.page;
        if (this.page >= this.activeList.size()) {
            this.page = 0;
        }
        this.activePage = this.activeList.get(this.page);
        BeepediaScreen.currScreenState.setMutationsPage(this.page);
    }

    private void prevPage() {
        if (this.activeList == null) {
            return;
        }
        --this.page;
        if (this.page < 0) {
            this.page = this.activeList.size() - 1;
        }
        this.activePage = this.activeList.get(this.page);
        BeepediaScreen.currScreenState.setMutationsPage(this.page);
    }

    private void nextTab() {
        ++this.tab;
        if (this.tab >= this.mutations.size()) {
            this.tab = 0;
        }
        BeepediaScreen.currScreenState.setCurrentMutationTab(this.tab);
        this.activeList = (List)this.mutations.get(this.tab).getRight();
        this.selectPage(this.activeList);
    }

    private void prevTab() {
        --this.tab;
        if (this.tab < 0) {
            this.tab = this.mutations.size() - 1;
        }
        BeepediaScreen.currScreenState.setCurrentMutationTab(this.tab);
        this.activeList = (List)this.mutations.get(this.tab).getRight();
        this.selectPage(this.activeList);
    }

    @Override
    public void renderBackground(MatrixStack matrix, float partialTick, int mouseX, int mouseY) {
        TranslationTextComponent title;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        switch ((MutationTypes)((Object)this.mutations.get(BeepediaScreen.currScreenState.getCurrentMutationTab()).getLeft())) {
            case BLOCK: {
                title = new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.mutations.block");
                break;
            }
            case ENTITY: {
                title = new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.mutations.entity");
                break;
            }
            case ITEM: {
                title = new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.mutations.item");
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("found a legacy mutation. %s", BeepediaScreen.currScreenState.getCurrentMutationTab()));
            }
        }
        if (this.activePage != null) {
            int padding = font.func_238414_a_((ITextProperties)title) / 2;
            font.func_243248_b(matrix, (ITextComponent)title.func_240699_a_(TextFormatting.WHITE), (float)this.xPos + 84.5f - (float)padding, (float)this.yPos + 8.0f, -1);
            this.activePage.draw(matrix, this.xPos, this.yPos + 22);
            if (this.activeList.size() > 1) {
                StringTextComponent pageInfo = new StringTextComponent(String.format("%d / %d", this.page + 1, this.activeList.size()));
                padding = font.func_238414_a_((ITextProperties)pageInfo) / 2;
                font.func_243248_b(matrix, (ITextComponent)pageInfo.func_240699_a_(TextFormatting.WHITE), (float)this.xPos + 84.5f - (float)padding, (float)this.yPos + 106.0f - 14.0f, -1);
            }
        }
    }

    @Override
    public String getSearch() {
        String search = "";
        for (Pair<MutationTypes, List<MutationsPage>> mutation : this.mutations) {
            search = String.format("%s %s", search, mutation.getLeft());
            for (MutationsPage mutationsPage : (List)mutation.getRight()) {
                search = String.format("%s %s", search, mutationsPage.getSearch());
            }
        }
        return search;
    }

    @Override
    public void openPage() {
        super.openPage();
        this.tab = BeepediaScreen.currScreenState.getCurrentMutationTab();
        if (this.tab >= this.mutations.size()) {
            this.tab = 0;
        }
        BeepediaScreen.currScreenState.setCurrentMutationTab(this.tab);
        this.activeList = (List)this.mutations.get(this.tab).getRight();
        this.selectPage(this.activeList);
        this.prevTab.field_230694_p_ = this.mutations.size() > 1;
        this.nextTab.field_230694_p_ = this.mutations.size() > 1;
    }

    private void selectPage(List<MutationsPage> activeList) {
        if (activeList != null) {
            this.page = BeepediaScreen.currScreenState.getMutationsPage();
            if (this.page >= activeList.size()) {
                this.page = 0;
            }
            this.activePage = activeList.isEmpty() ? null : activeList.get(this.page);
            BeepediaScreen.currScreenState.setMutationsPage(this.page);
            this.leftArrow.field_230694_p_ = activeList.size() > 1;
            this.rightArrow.field_230694_p_ = activeList.size() > 1;
        }
    }

    @Override
    public void closePage() {
        super.closePage();
        this.prevTab.field_230694_p_ = false;
        this.nextTab.field_230694_p_ = false;
        this.leftArrow.field_230694_p_ = false;
        this.rightArrow.field_230694_p_ = false;
    }

    @Override
    public void tick(int ticksActive) {
        if (this.activePage != null) {
            this.activePage.tick(ticksActive);
        }
    }

    @Override
    public void drawTooltips(MatrixStack matrix, int mouseX, int mouseY) {
        if (this.activePage != null) {
            this.activePage.drawTooltips(matrix, this.xPos, this.yPos + 22, mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.activePage != null) {
            return this.activePage.mouseClick(this.xPos, this.yPos + 22, (int)mouseX, (int)mouseY);
        }
        return false;
    }
}

