/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.BeepediaScreen;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.BeeDataPage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.BeePage;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.fluids.HoneyFlowingFluid;
import com.resourcefulbees.resourcefulbees.item.CustomHoneyBottleItem;
import com.resourcefulbees.resourcefulbees.lib.ApiaryOutput;
import com.resourcefulbees.resourcefulbees.recipe.CentrifugeRecipe;
import com.resourcefulbees.resourcefulbees.registry.ModFluids;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class HoneycombPage
extends BeeDataPage {
    Button prevTab;
    Button nextTab;
    private int counter;
    private final int max;
    private final ItemStack hiveOutput;
    private final ItemStack apiary1Output;
    private final ItemStack apiary2Output;
    private final ItemStack apiary3Output;
    private final ItemStack apiary4Output;
    List<RecipeObject> recipes = new ArrayList<RecipeObject>();
    List<Item> hives = BeeInfoUtils.getItemTag("minecraft:beehives").func_230236_b_();
    ItemStack apiary1 = new ItemStack((IItemProvider)ModItems.T1_APIARY_ITEM.get());
    ItemStack apiary2 = new ItemStack((IItemProvider)ModItems.T2_APIARY_ITEM.get());
    ItemStack apiary3 = new ItemStack((IItemProvider)ModItems.T3_APIARY_ITEM.get());
    ItemStack apiary4 = new ItemStack((IItemProvider)ModItems.T4_APIARY_ITEM.get());
    public static final ResourceLocation HONEYCOMBS_IMAGE = new ResourceLocation("resourcefulbees", "textures/gui/beepedia/honeycombs.png");
    public static final ResourceLocation CENTRIFUGE_IMAGE = new ResourceLocation("resourcefulbees", "textures/gui/beepedia/centrifuge.png");
    public static final ResourceLocation MULTIBLOCK_ONLY_IMAGE = new ResourceLocation("resourcefulbees", "textures/gui/beepedia/multiblock_only.png");
    Button leftArrow;
    Button rightArrow;
    int activePage = 0;

    public HoneycombPage(BeepediaScreen beepedia, CustomBeeData beeData, int xPos, int yPos, BeePage parent) {
        super(beepedia, beeData, xPos, yPos, parent);
        this.prevTab = new ImageButton(xPos + 84 - 48, yPos + 6, 8, 11, 0, 0, 11, this.arrowImage, 16, 33, button -> this.toggleTab());
        this.nextTab = new ImageButton(xPos + 84 + 40, yPos + 6, 8, 11, 8, 0, 11, this.arrowImage, 16, 33, button -> this.toggleTab());
        beepedia.func_230480_a_(this.nextTab);
        beepedia.func_230480_a_(this.prevTab);
        this.nextTab.field_230694_p_ = false;
        this.prevTab.field_230694_p_ = false;
        this.counter = 0;
        this.max = this.hives.size();
        int[] apiaryAmounts = beeData.getApiaryOutputAmounts();
        if (apiaryAmounts == null) {
            apiaryAmounts = new int[]{(Integer)Config.T1_APIARY_QUANTITY.get(), (Integer)Config.T2_APIARY_QUANTITY.get(), (Integer)Config.T3_APIARY_QUANTITY.get(), (Integer)Config.T4_APIARY_QUANTITY.get()};
        }
        this.hiveOutput = new ItemStack((IItemProvider)beeData.getCombRegistryObject().get(), 1);
        this.apiary1Output = new ItemStack(beeData.getApiaryOutputsTypes()[0] == ApiaryOutput.COMB ? (IItemProvider)beeData.getCombRegistryObject().get() : (IItemProvider)beeData.getCombBlockItemRegistryObject().get(), apiaryAmounts[0]);
        this.apiary2Output = new ItemStack(beeData.getApiaryOutputsTypes()[1] == ApiaryOutput.COMB ? (IItemProvider)beeData.getCombRegistryObject().get() : (IItemProvider)beeData.getCombBlockItemRegistryObject().get(), apiaryAmounts[1]);
        this.apiary3Output = new ItemStack(beeData.getApiaryOutputsTypes()[2] == ApiaryOutput.COMB ? (IItemProvider)beeData.getCombRegistryObject().get() : (IItemProvider)beeData.getCombBlockItemRegistryObject().get(), apiaryAmounts[2]);
        this.apiary4Output = new ItemStack(beeData.getApiaryOutputsTypes()[3] == ApiaryOutput.COMB ? (IItemProvider)beeData.getCombRegistryObject().get() : (IItemProvider)beeData.getCombBlockItemRegistryObject().get(), apiaryAmounts[3]);
        ClientWorld world = beepedia.getMinecraft().field_71441_e;
        this.recipes.add(new RecipeObject(false, true, beeData, world, beepedia));
        this.recipes.add(new RecipeObject(false, false, beeData, world, beepedia));
        this.recipes.add(new RecipeObject(true, true, beeData, world, beepedia));
        this.recipes.add(new RecipeObject(true, false, beeData, world, beepedia));
        this.recipes.removeIf(b -> b.recipe == null);
        this.leftArrow = new ImageButton(xPos + 84 - 28, yPos + 106 - 16, 8, 11, 0, 0, 11, this.arrowImage, 16, 33, button -> this.prevPage());
        this.rightArrow = new ImageButton(xPos + 84 + 20, yPos + 106 - 16, 8, 11, 8, 0, 11, this.arrowImage, 16, 33, button -> this.nextPage());
        beepedia.func_230480_a_(this.leftArrow);
        beepedia.func_230480_a_(this.rightArrow);
        this.leftArrow.field_230694_p_ = false;
        this.rightArrow.field_230694_p_ = false;
    }

    private void toggleTab() {
        BeepediaScreen.currScreenState.setCentrifugeOpen(!BeepediaScreen.currScreenState.isCentrifugeOpen());
        this.updateButtonVisibility();
    }

    private void nextPage() {
        ++this.activePage;
        if (this.activePage >= this.recipes.size()) {
            this.activePage = 0;
        }
        BeepediaScreen.currScreenState.setCentrifugePage(this.activePage);
    }

    private void prevPage() {
        --this.activePage;
        if (this.activePage < 0) {
            this.activePage = this.recipes.size() - 1;
        }
        BeepediaScreen.currScreenState.setCentrifugePage(this.activePage);
    }

    @Override
    public void openPage() {
        super.openPage();
        this.updateButtonVisibility();
        this.activePage = BeepediaScreen.currScreenState.getCentrifugePage();
        if (this.activePage >= this.recipes.size()) {
            this.activePage = 0;
        }
        BeepediaScreen.currScreenState.setBreedingPage(this.activePage);
    }

    private void updateButtonVisibility() {
        this.nextTab.field_230694_p_ = !this.recipes.isEmpty();
        this.prevTab.field_230694_p_ = !this.recipes.isEmpty();
        this.rightArrow.field_230694_p_ = BeepediaScreen.currScreenState.isCentrifugeOpen() && !this.recipes.isEmpty();
        this.leftArrow.field_230694_p_ = BeepediaScreen.currScreenState.isCentrifugeOpen() && !this.recipes.isEmpty();
    }

    @Override
    public void closePage() {
        super.closePage();
        this.nextTab.field_230694_p_ = false;
        this.prevTab.field_230694_p_ = false;
        this.rightArrow.field_230694_p_ = false;
        this.leftArrow.field_230694_p_ = false;
    }

    @Override
    public void renderBackground(MatrixStack matrix, float partialTick, int mouseX, int mouseY) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        TextureManager manager = Minecraft.func_71410_x().func_110434_K();
        TranslationTextComponent title = new TranslationTextComponent(BeepediaScreen.currScreenState.isCentrifugeOpen() ? "gui.resourcefulbees.beepedia.bee_subtab.centrifuge" : "gui.resourcefulbees.beepedia.bee_subtab.honeycombs");
        int padding = font.func_238414_a_((ITextProperties)title) / 2;
        font.func_243248_b(matrix, (ITextComponent)title.func_240699_a_(TextFormatting.WHITE), (float)this.xPos + 84.5f - (float)padding, (float)this.yPos + 8.0f, -1);
        if (BeepediaScreen.currScreenState.isCentrifugeOpen() && !this.recipes.isEmpty()) {
            this.recipes.get(this.activePage).draw(matrix, this.xPos, this.yPos + 22, mouseX, mouseY);
            if (this.recipes.size() > 1) {
                StringTextComponent page = new StringTextComponent(String.format("%d / %d", this.activePage + 1, this.recipes.size()));
                padding = font.func_238414_a_((ITextProperties)page) / 2;
                font.func_243248_b(matrix, (ITextComponent)page.func_240699_a_(TextFormatting.WHITE), (float)this.xPos + 84.5f - (float)padding, (float)this.yPos + 106.0f - 14.0f, -1);
            }
        } else {
            manager.func_110577_a(HONEYCOMBS_IMAGE);
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)this.xPos, (int)(this.yPos + 22), (float)0.0f, (float)0.0f, (int)169, (int)84, (int)169, (int)84);
            this.beepedia.drawSlot(matrix, (IItemProvider)this.hives.get(this.counter), this.xPos + 14, this.yPos + 23);
            this.beepedia.drawSlot(matrix, this.apiary1, this.xPos + 43, this.yPos + 23);
            this.beepedia.drawSlot(matrix, this.apiary2, this.xPos + 72, this.yPos + 23);
            this.beepedia.drawSlot(matrix, this.apiary3, this.xPos + 101, this.yPos + 23);
            this.beepedia.drawSlot(matrix, this.apiary4, this.xPos + 130, this.yPos + 23);
            this.beepedia.drawSlot(matrix, this.hiveOutput, this.xPos + 14, this.yPos + 82);
            this.beepedia.drawSlot(matrix, this.apiary1Output, this.xPos + 43, this.yPos + 82);
            this.beepedia.drawSlot(matrix, this.apiary2Output, this.xPos + 72, this.yPos + 82);
            this.beepedia.drawSlot(matrix, this.apiary3Output, this.xPos + 101, this.yPos + 82);
            this.beepedia.drawSlot(matrix, this.apiary4Output, this.xPos + 130, this.yPos + 82);
        }
    }

    @Override
    public String getSearch() {
        String search = "";
        for (RecipeObject recipe : this.recipes) {
            for (Pair<FluidStack, Float> pair : recipe.outputFluids) {
                search = String.format("%s %s", search, ((FluidStack)pair.getLeft()).getDisplayName().getString());
            }
            for (Pair<FluidStack, Float> pair : recipe.outputItems) {
                search = String.format("%s %s", search, ((ItemStack)pair.getLeft()).func_151000_E().getString());
            }
        }
        return search;
    }

    @Override
    public void tick(int ticksActive) {
        if (ticksActive % 20 == 0 && !BeeInfoUtils.isShiftPressed()) {
            ++this.counter;
            if (this.counter >= this.max) {
                this.counter = 0;
            }
        }
    }

    @Override
    public void drawTooltips(MatrixStack matrix, int mouseX, int mouseY) {
        if (!this.recipes.isEmpty()) {
            this.recipes.get(this.activePage).drawTooltip(matrix, this.xPos, this.yPos, mouseX, mouseY);
        }
    }

    public static class RecipeObject {
        public boolean isBlock;
        public boolean hasBottle;
        public ItemStack inputItem;
        public ItemStack bottleItem = ItemStack.field_190927_a;
        public List<Pair<ItemStack, Float>> outputItems;
        public List<Pair<FluidStack, Float>> outputFluids;
        public CentrifugeRecipe recipe;
        public CustomBeeData beeData;
        public BeepediaScreen beepedia;

        public RecipeObject(boolean isBlock, boolean hasBottle, CustomBeeData beeData, ClientWorld world, BeepediaScreen beepedia) {
            this.isBlock = isBlock;
            this.hasBottle = hasBottle;
            this.beeData = beeData;
            this.beepedia = beepedia;
            this.setBottles();
            this.inputItem = isBlock ? beeData.getCombBlockItemStack() : beeData.getCombStack();
            Inventory inventory = new Inventory(new ItemStack[]{this.inputItem, this.bottleItem});
            this.recipe = world.func_199532_z().func_215371_a(CentrifugeRecipe.CENTRIFUGE_RECIPE_TYPE, (IInventory)inventory, (World)world).orElse(null);
            if (this.recipe != null) {
                this.outputItems = this.recipe.itemOutputs;
                this.outputFluids = this.recipe.fluidOutput;
            }
        }

        public RecipeObject(CentrifugeRecipe recipe, BeepediaScreen beepedia) {
            this.beepedia = beepedia;
            this.recipe = recipe;
            this.inputItem = recipe.ingredient.func_193365_a()[0];
            this.outputItems = recipe.itemOutputs;
            this.outputFluids = recipe.fluidOutput;
            this.isBlock = recipe.multiblock;
            this.hasBottle = !recipe.noBottleInput;
            this.setBottles();
        }

        private void setBottles() {
            if (this.hasBottle) {
                this.bottleItem = this.isBlock ? new ItemStack((IItemProvider)Items.field_151069_bo, 9) : new ItemStack((IItemProvider)Items.field_151069_bo);
            }
        }

        public void draw(MatrixStack matrix, int xPos, int yPos, int mouseX, int mouseY) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(CENTRIFUGE_IMAGE);
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)xPos, (int)yPos, (float)0.0f, (float)0.0f, (int)169, (int)84, (int)169, (int)84);
            this.beepedia.drawSlot(matrix, this.inputItem, xPos + 25, yPos + 3);
            if (this.bottleItem.func_190926_b()) {
                this.beepedia.drawEmptySlot(matrix, xPos + 25, yPos + 23);
            } else {
                this.beepedia.drawSlot(matrix, this.bottleItem, xPos + 25, yPos + 23);
            }
            if (this.recipe.hasFluidOutput) {
                if (((ItemStack)this.outputItems.get(0).getLeft()).func_190926_b()) {
                    this.beepedia.drawFluidSlot(matrix, (FluidStack)this.outputFluids.get(0).getLeft(), xPos + 124, yPos + 3);
                    this.drawWeight(matrix, (Float)this.outputFluids.get(0).getRight(), xPos + 112, yPos + 9);
                } else {
                    this.beepedia.drawFluidSlot(matrix, (FluidStack)this.outputFluids.get(0).getLeft(), xPos + 124, yPos + 43);
                    this.drawWeight(matrix, (Float)this.outputFluids.get(0).getRight(), xPos + 112, yPos + 49);
                    this.beepedia.drawSlot(matrix, (ItemStack)this.outputItems.get(0).getLeft(), xPos + 124, yPos + 3);
                    this.drawWeight(matrix, (Float)this.outputItems.get(0).getRight(), xPos + 112, yPos + 9);
                }
            } else {
                this.beepedia.drawSlot(matrix, (ItemStack)this.outputItems.get(0).getLeft(), xPos + 124, yPos + 3);
                this.drawWeight(matrix, (Float)this.outputItems.get(0).getRight(), xPos + 112, yPos + 9);
            }
            this.beepedia.drawSlot(matrix, (ItemStack)this.outputItems.get(1).getLeft(), xPos + 124, yPos + 23);
            this.drawWeight(matrix, (Float)this.outputItems.get(1).getRight(), xPos + 112, yPos + 30);
            if (this.isBlock || ((Boolean)Config.MULTIBLOCK_RECIPES_ONLY.get()).booleanValue()) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(MULTIBLOCK_ONLY_IMAGE);
                AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(xPos + 28), (int)(yPos + 45), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            }
            if (this.hasBottle) {
                this.drawHoneyBottle(matrix, xPos, yPos, mouseX, mouseY);
            } else {
                this.drawHoneyFluid(matrix, xPos, yPos, mouseX, mouseY);
            }
        }

        private void drawHoneyBottle(MatrixStack matrix, int xPos, int yPos, int mouseX, int mouseY) {
            Item bottle = ((ItemStack)this.outputItems.get(2).getLeft()).func_77973_b();
            String pageID = null;
            if (bottle == Items.field_226638_pX_) {
                pageID = "honey";
            } else if (bottle instanceof CustomHoneyBottleItem) {
                pageID = ((CustomHoneyBottleItem)bottle).honeyBottleData.getName();
            }
            if (pageID != null) {
                String finalPageID = pageID;
                Supplier<Boolean> supplier = () -> {
                    BeepediaScreen.saveScreenState();
                    this.beepedia.setActive(BeepediaScreen.PageType.HONEY, finalPageID);
                    return true;
                };
                this.beepedia.drawInteractiveSlot(matrix, (ItemStack)this.outputItems.get(2).getLeft(), xPos + 75, yPos + 43, mouseX, mouseY, supplier);
            } else {
                this.beepedia.drawSlot(matrix, (ItemStack)this.outputItems.get(2).getLeft(), xPos + 75, yPos + 43);
            }
            this.drawWeight(matrix, (Float)this.outputItems.get(2).getRight(), xPos + 64, yPos + 49);
        }

        private void drawHoneyFluid(MatrixStack matrix, int xPos, int yPos, int mouseX, int mouseY) {
            FluidStack fluidStack = (FluidStack)this.outputFluids.get(1).getLeft();
            String pageID = null;
            if (fluidStack.getFluid() == ModFluids.HONEY_STILL.get()) {
                pageID = "honey";
            } else if (fluidStack.getFluid() instanceof HoneyFlowingFluid) {
                HoneyFlowingFluid fluid = (HoneyFlowingFluid)fluidStack.getFluid();
                pageID = fluid.getHoneyData().getName();
            }
            if (pageID != null) {
                String finalPageID = pageID;
                Supplier<Boolean> supplier = () -> {
                    BeepediaScreen.saveScreenState();
                    this.beepedia.setActive(BeepediaScreen.PageType.HONEY, finalPageID);
                    return true;
                };
                this.beepedia.drawInteractiveFluidSlot(matrix, (FluidStack)this.outputFluids.get(1).getLeft(), xPos + 75, yPos + 43, mouseX, mouseY, supplier);
            } else {
                this.beepedia.drawFluidSlot(matrix, (FluidStack)this.outputFluids.get(1).getLeft(), xPos + 75, yPos + 43);
            }
            this.drawWeight(matrix, (Float)this.outputFluids.get(1).getRight(), xPos + 64, yPos + 49);
        }

        private void drawWeight(MatrixStack matrix, Float right, int xPos, int yPos) {
            if (right.floatValue() == 1.0f) {
                return;
            }
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            DecimalFormat decimalFormat = new DecimalFormat("##%");
            StringTextComponent text = new StringTextComponent(decimalFormat.format(right));
            int padding = font.func_238414_a_((ITextProperties)text) / 2;
            font.func_243248_b(matrix, (ITextComponent)text.func_240699_a_(TextFormatting.GRAY), (float)xPos - (float)padding, (float)yPos, -1);
        }

        public void drawTooltip(MatrixStack matrix, int xPos, int yPos, int mouseX, int mouseY) {
            if (BeepediaScreen.mouseHovering((float)xPos + 28.0f, (float)yPos + 67.0f, 20, 20, mouseX, mouseY)) {
                this.beepedia.func_238652_a_(matrix, (ITextComponent)new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.centrifuge.requires_multiblock"), mouseX, mouseY);
            }
        }

        public boolean mouseClick(int xPos, int i, int mouseX, int mouseY) {
            return false;
        }

        public void tick(int ticksActive) {
        }
    }
}

