/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.BeepediaScreen;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.BeeDataPage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.BeePage;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import com.resourcefulbees.resourcefulbees.utils.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class BeeInfoPage
extends BeeDataPage {
    private Entity entityFlower = null;
    List<Block> flowers;
    int counter;
    int size;

    public BeeInfoPage(BeepediaScreen beepedia, CustomBeeData beeData, int xPos, int yPos, BeePage parent) {
        super(beepedia, beeData, xPos, yPos, parent);
        this.flowers = beeData.hasBlockFlowers() ? new ArrayList<Block>(beeData.getBlockFlowers()) : new ArrayList();
        this.counter = 0;
        this.size = this.flowers.size();
    }

    @Override
    public void renderBackground(MatrixStack matrix, float partialTick, int mouseX, int mouseY) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        IFormattableTextComponent title = new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.info").func_240699_a_(TextFormatting.WHITE);
        IFormattableTextComponent sizeName = new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.info.size").func_240699_a_(titleStyle);
        IFormattableTextComponent healthName = new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.info.health").func_240699_a_(titleStyle);
        IFormattableTextComponent damageName = new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.info.damage").func_240699_a_(titleStyle);
        IFormattableTextComponent stingerName = new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.info.stinger").func_240699_a_(titleStyle);
        IFormattableTextComponent passiveName = new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.info.passive").func_240699_a_(titleStyle);
        IFormattableTextComponent poisonName = new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.info.poison").func_240699_a_(titleStyle);
        IFormattableTextComponent timeName = new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.info.time").func_240699_a_(titleStyle);
        IFormattableTextComponent auraRangeName = new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.info.aura_range").func_240699_a_(titleStyle);
        sizeName.func_230529_a_((ITextComponent)BeeInfoUtils.getSizeName(this.beeData.getSizeModifier()).func_240703_c_(subStyle));
        damageName.func_230529_a_((ITextComponent)new StringTextComponent("" + (int)this.beeData.getCombatData().getAttackDamage()).func_240703_c_(subStyle));
        healthName.func_230529_a_((ITextComponent)new StringTextComponent("" + (int)this.beeData.getCombatData().getBaseHealth()).func_240703_c_(subStyle));
        stingerName.func_230529_a_((ITextComponent)BeeInfoUtils.getYesNo(this.beeData.getCombatData().removeStingerOnAttack()).func_240703_c_(subStyle));
        passiveName.func_230529_a_((ITextComponent)BeeInfoUtils.getYesNo(this.beeData.getCombatData().isPassive()).func_240703_c_(subStyle));
        poisonName.func_230529_a_((ITextComponent)BeeInfoUtils.getYesNo(this.beeData.getCombatData().inflictsPoison()).func_240703_c_(subStyle));
        auraRangeName.func_230529_a_((ITextComponent)new StringTextComponent("" + this.beeData.getAuraRange()).func_240703_c_(subStyle));
        timeName.func_230529_a_((ITextComponent)new StringTextComponent("" + this.beeData.getMaxTimeInHive() / 20 + "s").func_240703_c_(subStyle));
        font.func_243248_b(matrix, (ITextComponent)title, (float)this.xPos, (float)this.yPos + 8.0f, -1);
        font.func_243248_b(matrix, (ITextComponent)sizeName, (float)this.xPos, (float)this.yPos + 22.0f, -1);
        font.func_243248_b(matrix, (ITextComponent)timeName, (float)this.xPos + 76.0f, (float)this.yPos + 22.0f, -1);
        font.func_243248_b(matrix, (ITextComponent)healthName, (float)this.xPos, (float)this.yPos + 34.0f, -1);
        font.func_243248_b(matrix, (ITextComponent)damageName, (float)this.xPos + 76.0f, (float)this.yPos + 34.0f, -1);
        font.func_243248_b(matrix, (ITextComponent)passiveName, (float)this.xPos, (float)this.yPos + 46.0f, -1);
        font.func_243248_b(matrix, (ITextComponent)poisonName, (float)this.xPos + 76.0f, (float)this.yPos + 46.0f, -1);
        font.func_243248_b(matrix, (ITextComponent)stingerName, (float)this.xPos, (float)this.yPos + 58.0f, -1);
        if (this.beeData.getTraitData().hasBeeAuras()) {
            font.func_243248_b(matrix, (ITextComponent)auraRangeName, (float)this.xPos + 76.0f, (float)this.yPos + 70.0f, -1);
        }
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        TranslationTextComponent flowerName = new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.info.flower");
        if (this.beeData.hasBlockFlowers()) {
            if (!this.flowers.isEmpty()) {
                font.func_243248_b(matrix, (ITextComponent)flowerName.func_240699_a_(TextFormatting.GRAY), (float)this.xPos, (float)this.yPos + 75.0f, -1);
                this.beepedia.drawSlot(matrix, this.flowers.get(this.counter), this.xPos + 36, this.yPos + 70);
            }
        } else if (this.beeData.hasEntityFlower()) {
            if (this.entityFlower == null) {
                EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(this.beeData.getEntityFlower());
                if (entityType.equals(EntityType.field_200784_X) && !this.beeData.getEntityFlower().equals((Object)new ResourceLocation("minecraft:pig"))) {
                    return;
                }
                this.entityFlower = entityType.func_200721_a((World)this.beepedia.getMinecraft().field_71441_e);
            }
            font.func_243248_b(matrix, (ITextComponent)flowerName.func_240699_a_(TextFormatting.GRAY), (float)this.xPos, (float)this.yPos + 80.0f, -1);
            RenderUtils.renderEntity(matrix, this.entityFlower, (World)this.beepedia.getMinecraft().field_71441_e, (float)this.xPos + 45.0f, (float)this.yPos + 75.0f, -45.0f, 1.25f);
        }
    }

    @Override
    public String getSearch() {
        return String.format("%s %s %s %s %s", BeeInfoUtils.getSizeName(this.beeData.getSizeModifier()).getString(), this.beeData.getFlower(), this.beeData.getCombatData().isPassive() ? "passive" : "", this.beeData.getCombatData().inflictsPoison() ? "poison" : "", this.beeData.getCombatData().removeStingerOnAttack() ? "stinger" : "");
    }

    @Override
    public void tick(int ticksActive) {
        if (BeeInfoUtils.isShiftPressed()) {
            return;
        }
        if (ticksActive % 20 == 0) {
            ++this.counter;
            if (this.counter >= this.size) {
                this.counter = 0;
            }
        }
    }
}

