/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.api.honeydata.HoneyBottleData;
import com.resourcefulbees.resourcefulbees.api.traitdata.BeeTrait;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.BeepediaPage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.BeepediaScreenState;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.BeePage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.HomePage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.HoneyPage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.TraitPage;
import com.resourcefulbees.resourcefulbees.client.gui.widget.ButtonList;
import com.resourcefulbees.resourcefulbees.client.gui.widget.ModImageButton;
import com.resourcefulbees.resourcefulbees.client.gui.widget.TabImageButton;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.entity.passive.CustomBeeEntity;
import com.resourcefulbees.resourcefulbees.entity.passive.KittenBee;
import com.resourcefulbees.resourcefulbees.lib.BeeConstants;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.registry.TraitRegistry;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import com.resourcefulbees.resourcefulbees.utils.RenderUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class BeepediaScreen
extends Screen {
    private static int beesScroll = 0;
    private static int honeyScroll = 0;
    private static int traitScroll = 0;
    private static boolean searchVisible = false;
    private static String search = null;
    private static String lastSearch = null;
    protected static final LinkedList<BeepediaScreenState> pastStates = new LinkedList();
    public static BeepediaScreenState currScreenState = new BeepediaScreenState();
    public final List<String> itemBees;
    public final boolean complete;
    TextFieldWidget searchBox;
    protected int xSize;
    protected int ySize;
    protected int guiLeft;
    protected int guiTop;
    protected int ticksOpen = 0;
    public Map<String, BeePage> bees = new TreeMap<String, BeePage>();
    protected Map<String, TraitPage> traits = new TreeMap<String, TraitPage>();
    protected Map<String, HoneyPage> honey = new TreeMap<String, HoneyPage>();
    ButtonList beesList;
    ButtonList traitsList;
    ButtonList honeyList;
    BeepediaPage home;
    BeepediaPage activePage;
    PageType activeListType = PageType.BEE;
    ButtonList activeList = null;
    ResourceLocation background = new ResourceLocation("resourcefulbees", "textures/gui/beepedia/screen.png");
    ResourceLocation buttonImage = new ResourceLocation("resourcefulbees", "textures/gui/beepedia/button.png");
    ResourceLocation slotImage = new ResourceLocation("resourcefulbees", "textures/gui/beepedia/slot.png");
    private Button backButton;
    private final ResourceLocation homeButtons = new ResourceLocation("resourcefulbees", "textures/gui/beepedia/home_buttons.png");
    private final List<ItemTooltip> itemTooltips = new LinkedList<ItemTooltip>();
    private final List<FluidTooltip> fluidTooltips = new LinkedList<FluidTooltip>();
    private final List<Interaction> interactions = new LinkedList<Interaction>();
    private ModImageButton homeButton;

    @OnlyIn(value=Dist.CLIENT)
    public BeepediaScreen(String pageID, Set<String> bees, boolean complete) {
        super((ITextComponent)new TranslationTextComponent("gui.resourcefulbees.beepedia"));
        if (pageID != null) {
            currScreenState.setPageType(PageType.BEE);
            currScreenState.setPageID(pageID);
            currScreenState.setBeeSubPage(BeePage.SubPageType.INFO);
        }
        this.itemBees = new LinkedList<String>(bees);
        this.complete = complete;
        this.xSize = 286;
        this.ySize = 182;
    }

    public static boolean listChanged() {
        return currScreenState.getLastType() == null || !currScreenState.getLastType().equals((Object)currScreenState.getPageType());
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        this.guiLeft = (this.field_230708_k_ - this.xSize) / 2;
        this.guiTop = (this.field_230709_l_ - this.ySize) / 2;
        int x = this.guiLeft;
        int y = this.guiTop;
        int subX = x + 112;
        BeeRegistry.getRegistry().getBees().forEach((s, b) -> this.bees.put((String)s, new BeePage(this, (CustomBeeData)b, (String)s, subX, y)));
        TraitRegistry.getRegistry().getTraits().forEach((s, b) -> this.traits.put((String)s, new TraitPage(this, (BeeTrait)b, (String)s, subX, y)));
        this.honey.put("honey", new HoneyPage(this, BeeConstants.defaultHoney, "honey", subX, y));
        this.honey.put("catnip", new HoneyPage(this, KittenBee.getHoneyBottleData(), "catnip", subX, y));
        BeeRegistry.getRegistry().getHoneyBottles().forEach((s, h) -> this.honey.put((String)s, new HoneyPage(this, (HoneyBottleData)h, (String)s, subX, y)));
        this.home = new HomePage(this, subX, y);
        this.homeButton = new ModImageButton(x + this.xSize / 2 - 10, y + this.ySize - 25, 20, 20, 20, 0, 20, this.homeButtons, 60, 60, onPress -> this.selectPage(this.home));
        this.backButton = new ModImageButton(x + this.xSize / 2 + 20, y + this.ySize - 25, 20, 20, 40, 0, 20, this.homeButtons, 60, 60, onPress -> {
            if (!pastStates.isEmpty()) {
                BeepediaScreen.goBackState();
                this.returnState(true);
            }
        });
        this.func_230480_a_(this.homeButton);
        this.func_230480_a_(new ModImageButton(x + this.xSize / 2 - 40, y + this.ySize - 25, 20, 20, 0, 0, 20, this.homeButtons, 60, 60, onPress -> {
            this.searchBox.field_230694_p_ = !this.searchBox.field_230694_p_;
            BeepediaScreen.setSearchVisible(this.searchBox.field_230694_p_);
            this.updateSearch(this.beesList, true);
            this.updateSearch(this.traitsList, true);
            this.updateSearch(this.honeyList, true);
        }));
        this.backButton.field_230693_o_ = false;
        this.func_230480_a_(this.backButton);
        this.bees.forEach((s, b) -> this.func_230480_a_(b.listButton));
        this.traits.forEach((s, b) -> this.func_230480_a_(b.listButton));
        this.honey.forEach((s, b) -> this.func_230480_a_(b.listButton));
        this.searchBox = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, x + 10, y + 143, 98, 10, (ITextComponent)new TranslationTextComponent("gui.resourcefulbees.beepedia.search"));
        this.searchBox.field_230694_p_ = false;
        this.func_230481_d_((IGuiEventListener)this.searchBox);
        this.initSidebar();
        this.returnState(false);
    }

    private static void goBackState() {
        currScreenState = pastStates.pop();
    }

    private void returnState(boolean goingBack) {
        this.setActive(currScreenState.getPageType(), currScreenState.getPageID(), goingBack);
        this.searchBox.field_230694_p_ = BeepediaScreen.isSearchVisible();
        this.searchBox.func_146180_a(BeepediaScreen.getSearch() != null ? BeepediaScreen.getSearch() : "");
        if (beesScroll != 0) {
            this.beesList.setScrollPos(beesScroll);
        }
        if (honeyScroll != 0) {
            this.honeyList.setScrollPos(honeyScroll);
        }
        if (traitScroll != 0) {
            this.traitsList.setScrollPos(traitScroll);
        }
    }

    public void selectPage(BeepediaPage activePage) {
        if (activePage instanceof HomePage) {
            this.setActive(null, null);
        } else if (activePage instanceof BeePage) {
            this.setActive(PageType.BEE, activePage.id);
        } else if (activePage instanceof TraitPage) {
            this.setActive(PageType.TRAIT, activePage.id);
        } else if (activePage instanceof HoneyPage) {
            this.setActive(PageType.HONEY, activePage.id);
        }
    }

    public void setActive(PageType pageType, String pageID) {
        this.setActive(pageType, pageID, false);
    }

    public void setActive(PageType pageType, String pageID, boolean goingBack) {
        if (pageType == null || pageID == null) {
            this.activatePage(PageType.BEE, this.home, this.beesList, goingBack);
            return;
        }
        BeepediaPage page = null;
        ButtonList list = null;
        switch (pageType) {
            case BEE: {
                page = this.bees.get(pageID);
                list = this.beesList;
                break;
            }
            case HONEY: {
                page = this.honey.get(pageID);
                list = this.honeyList;
                break;
            }
            case TRAIT: {
                page = this.traits.get(pageID);
                list = this.traitsList;
            }
        }
        if (page == null) {
            page = this.bees.get(pageID);
            list = this.beesList;
        }
        if (page == null) {
            page = this.honey.get(pageID);
            list = this.honeyList;
        }
        if (page == null) {
            page = this.traits.get(pageID);
            list = this.traitsList;
        }
        this.activatePage(pageType, page, list, goingBack);
    }

    private void activatePage(PageType type, BeepediaPage page, ButtonList list, boolean goingBack) {
        boolean forceUpdate;
        if (list == null) {
            throw new IllegalStateException("IF THIS SOMEHOW HAPPENS YOU BROKE THE GAME");
        }
        if (this.activePage != null) {
            if (!(this.activePage.getClass().equals(this.activePage.getClass()) || this.activePage instanceof HomePage || goingBack)) {
                BeepediaScreen.saveScreenState();
            }
            this.activePage.closePage();
        }
        if (page == null) {
            page = this.home;
        }
        if (currScreenState.getPageType() == null) {
            currScreenState.setPageType(type);
        }
        currScreenState.setPageID(page.id);
        boolean bl = forceUpdate = this.activeList == null;
        if (currScreenState.pageChanged() || goingBack || forceUpdate) {
            if (this.activeList != null) {
                this.activeList.setActive(false, goingBack);
            }
            this.activeList = list;
            this.activeList.setActive(true, goingBack || forceUpdate);
            this.activeListType = type;
            if (searchVisible && goingBack) {
                this.activeList.updateReducedList(BeepediaScreen.getSearch(), true);
            }
        }
        this.activePage = page;
        this.activePage.openPage();
    }

    public static void saveScreenState() {
        pastStates.push(currScreenState);
        currScreenState = new BeepediaScreenState();
    }

    private void setActiveList(ButtonList buttonList, PageType type) {
        currScreenState.setPageType(type);
        this.activeListType = type;
        if (this.activeList != null) {
            this.activeList.setActive(false, true);
        }
        this.activeList = buttonList;
        this.activeList.setActive(true, true);
    }

    public void initSidebar() {
        ItemStack beeItem = new ItemStack((IItemProvider)Items.field_226637_pW_);
        ItemStack traitItem = new ItemStack((IItemProvider)Items.field_151065_br);
        ItemStack honeyItem = new ItemStack((IItemProvider)Items.field_226638_pX_);
        int x = this.guiLeft;
        int y = this.guiTop;
        TabImageButton beesButton = new TabImageButton(x + 45, y + 8, 20, 20, 0, 0, 20, this.buttonImage, beeItem, 2, 2, onPress -> this.setActiveList(this.beesList, PageType.BEE), this.getTooltipProvider((ITextComponent)new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.bees")));
        TabImageButton traitsButton = new TabImageButton(x + 66, y + 8, 20, 20, 0, 0, 20, this.buttonImage, traitItem, 2, 2, onPress -> this.setActiveList(this.traitsList, PageType.TRAIT), this.getTooltipProvider((ITextComponent)new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.traits")));
        TabImageButton honeyButton = new TabImageButton(x + 87, y + 8, 20, 20, 0, 0, 20, this.buttonImage, honeyItem, 2, 2, onPress -> this.setActiveList(this.honeyList, PageType.HONEY), this.getTooltipProvider((ITextComponent)new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.honey")));
        this.func_230480_a_(beesButton);
        this.func_230480_a_(traitsButton);
        this.func_230480_a_(honeyButton);
        this.beesList = new ButtonList(x + 8, y + 31, 100, 123, 21, beesButton, this.bees);
        this.traitsList = new ButtonList(x + 8, y + 31, 100, 123, 21, traitsButton, this.traits);
        this.honeyList = new ButtonList(x + 8, y + 31, 100, 123, 21, honeyButton, this.honey);
    }

    public void func_230430_a_(@NotNull MatrixStack matrixStack, int mouseX, int mouseY, float partialTick) {
        this.func_238651_a_(matrixStack, 0);
        this.itemTooltips.clear();
        this.fluidTooltips.clear();
        this.interactions.clear();
        this.drawBackground(matrixStack, partialTick, mouseX, mouseY);
        this.updateSearch();
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTick);
        this.searchBox.func_230430_a_(matrixStack, mouseX, mouseY, partialTick);
        this.drawForeground(matrixStack, mouseX, mouseY);
        this.drawTooltips(matrixStack, mouseX, mouseY);
    }

    protected void drawBackground(MatrixStack matrix, float partialTick, int mouseX, int mouseY) {
        Minecraft client = this.field_230706_i_;
        this.homeButton.field_230693_o_ = this.activePage != this.home;
        boolean bl = this.backButton.field_230693_o_ = !pastStates.isEmpty();
        if (client != null) {
            client.func_110434_K().func_110577_a(this.background);
            int x = this.guiLeft;
            int y = this.guiTop;
            BeepediaScreen.func_238463_a_((MatrixStack)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (int)286, (int)182);
        }
        this.activePage.renderBackground(matrix, partialTick, mouseX, mouseY);
        this.activeList.updateList();
        if (this.searchBox.field_230694_p_) {
            this.activeList.setSearchHeight();
        } else {
            this.activeList.resetHeight();
        }
    }

    private void updateSearch() {
        if (this.searchBox.field_230694_p_) {
            this.func_231035_a_((IGuiEventListener)this.searchBox);
            this.searchBox.func_146195_b(true);
        }
        if (this.searchBox.func_230999_j_()) {
            String text = this.searchBox.func_146179_b();
            if (text.isEmpty()) {
                BeepediaScreen.setSearch(null);
            } else {
                BeepediaScreen.setSearch(text);
            }
        }
        this.updateSearch(this.beesList, false);
        this.updateSearch(this.honeyList, false);
        this.updateSearch(this.traitsList, false);
    }

    private void updateSearch(ButtonList list, boolean isSearchToggled) {
        if (!BeepediaScreen.searchUpdated() && !isSearchToggled) {
            return;
        }
        if (BeepediaScreen.isSearchVisible()) {
            if (BeepediaScreen.getSearch() != null) {
                list.updateReducedList(this.searchBox.func_146179_b(), true);
            } else {
                list.updateReducedList(null, true);
            }
        } else {
            list.updateReducedList(null, true);
        }
    }

    public static boolean searchUpdated() {
        if (lastSearch == null) {
            return search != null;
        }
        return !lastSearch.equals(search);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        ++this.ticksOpen;
        this.activePage.tick(this.ticksOpen);
    }

    protected void drawForeground(MatrixStack matrixStack, int mouseX, int mouseY) {
        TranslationTextComponent title;
        this.field_230712_o_.func_243248_b(matrixStack, this.field_230704_d_, (float)this.guiLeft + 10.0f, (float)this.guiTop + (float)this.ySize - 20.0f, 0x555555);
        this.activePage.renderForeground(matrixStack, mouseX, mouseY);
        switch (this.activeListType) {
            case TRAIT: {
                title = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.traits");
                break;
            }
            case HONEY: {
                title = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.honey");
                break;
            }
            default: {
                title = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.bees");
            }
        }
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)title.func_240699_a_(TextFormatting.WHITE), (float)this.guiLeft + 10.0f, (float)this.guiTop + 20.0f, -1);
    }

    private void drawTooltips(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.activePage.drawTooltips(matrixStack, mouseX, mouseY);
        this.beesList.button.func_230443_a_(matrixStack, mouseX, mouseY);
        this.traitsList.button.func_230443_a_(matrixStack, mouseX, mouseY);
        this.honeyList.button.func_230443_a_(matrixStack, mouseX, mouseY);
        this.itemTooltips.forEach(t -> t.draw(matrixStack, mouseX, mouseY));
        this.fluidTooltips.forEach(t -> t.draw(matrixStack, mouseX, mouseY));
    }

    public Map<String, TraitPage> getTraits(CustomBeeData beeData) {
        HashMap<String, TraitPage> pages = new HashMap<String, TraitPage>();
        if (beeData.getTraitNames() == null || beeData.getTraitNames().length == 0) {
            return pages;
        }
        for (String traitName : beeData.getTraitNames()) {
            if (traitName == null) continue;
            pages.put(traitName, this.traits.get(traitName));
        }
        return pages;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scrollAmount) {
        boolean subScrolled = this.activePage.mouseScrolled(mouseX, mouseY, scrollAmount);
        if (subScrolled) {
            return true;
        }
        if (this.activeList != null) {
            this.activeList.updatePos((int)(scrollAmount * 8.0));
        }
        BeepediaScreen.updateScrollPos(this.beesList, this.traitsList, this.honeyList);
        return super.func_231043_a_(mouseX, mouseY, scrollAmount);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.activePage.mouseClicked(mouseX, mouseY, mouseButton)) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return true;
        }
        this.interactions.forEach(b -> {
            if (b.onMouseClick((int)mouseX, (int)mouseY)) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            }
        });
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public static void updateScrollPos(ButtonList beesList, ButtonList traitsList, ButtonList honeyList) {
        beesScroll = beesList.getScrollPos();
        traitScroll = traitsList.getScrollPos();
        honeyScroll = honeyList.getScrollPos();
    }

    public static void setSearch(String search) {
        lastSearch = BeepediaScreen.search;
        BeepediaScreen.search = search;
    }

    public static String getSearch() {
        return search;
    }

    public static void setSearchVisible(boolean visible) {
        searchVisible = visible;
    }

    public static boolean isSearchVisible() {
        return searchVisible;
    }

    public boolean func_231177_au__() {
        return false;
    }

    public static boolean mouseHovering(float x, float y, int width, int height, int mouseX, int mouseY) {
        return (float)mouseX > x && (float)mouseY > y && (float)mouseX < x + (float)width && (float)mouseY < y + (float)height;
    }

    public void drawSlot(MatrixStack matrix, IItemProvider item, int amount, int xPos, int yPos, boolean showFluidAmount) {
        if (item instanceof FlowingFluidBlock) {
            this.drawFluidSlot(matrix, new FluidStack(((FlowingFluidBlock)item).getFluid().func_210198_f(), amount), xPos, yPos, showFluidAmount);
        } else {
            this.drawSlot(matrix, new ItemStack(item, amount), xPos, yPos);
        }
    }

    public void drawSlot(MatrixStack matrix, IItemProvider item, int amount, int xPos, int yPos) {
        this.drawSlot(matrix, item, amount, xPos, yPos, true);
    }

    public void drawSlot(MatrixStack matrix, Block item, int xPos, int yPos) {
        this.drawSlot(matrix, (IItemProvider)item, 1, xPos, yPos, false);
    }

    public void drawSlot(MatrixStack matrix, IItemProvider item, int xPos, int yPos) {
        if (item instanceof FlowingFluidBlock) {
            this.drawFluidSlot(matrix, new FluidStack(((FlowingFluidBlock)item).getFluid().func_210198_f(), 1000), xPos, yPos, false);
        } else {
            this.drawSlot(matrix, new ItemStack(item), xPos, yPos);
        }
    }

    public void drawFluidSlot(MatrixStack matrix, FluidStack fluidStack, int xPos, int yPos) {
        this.drawFluidSlot(matrix, fluidStack, xPos, yPos, true);
    }

    public void drawFluidSlot(MatrixStack matrix, FluidStack fluidStack, int xPos, int yPos, boolean showAmount) {
        if (fluidStack.isEmpty()) {
            return;
        }
        this.drawFluidSlotNoToolTip(matrix, fluidStack, xPos, yPos);
        this.registerFluidTooltip(fluidStack, xPos, yPos, showAmount);
    }

    public void drawFluidSlotNoToolTip(MatrixStack matrix, FluidStack fluidStack, int xPos, int yPos) {
        if (fluidStack.isEmpty()) {
            return;
        }
        this.getMinecraft().func_110434_K().func_110577_a(this.slotImage);
        BeepediaScreen.func_238463_a_((MatrixStack)matrix, (int)xPos, (int)yPos, (float)0.0f, (float)0.0f, (int)20, (int)20, (int)20, (int)20);
        RenderUtils.renderFluid(matrix, fluidStack, xPos + 2, yPos + 2, this.func_230927_p_());
    }

    public void drawSlot(MatrixStack matrix, ItemStack item, int xPos, int yPos) {
        this.drawSlotNoToolTip(matrix, item, xPos, yPos);
        this.registerItemTooltip(item, xPos, yPos);
    }

    public void drawSlotNoToolTip(MatrixStack matrix, IItemProvider item, int xPos, int yPos) {
        if (item instanceof FlowingFluidBlock) {
            this.drawFluidSlotNoToolTip(matrix, new FluidStack(((FlowingFluidBlock)item).getFluid().func_210198_f(), 1000), xPos, yPos);
        } else {
            this.drawSlotNoToolTip(matrix, new ItemStack(item), xPos, yPos);
        }
    }

    public void drawSlotNoToolTip(MatrixStack matrix, ItemStack item, int xPos, int yPos) {
        if (item.func_190926_b()) {
            return;
        }
        this.getMinecraft().func_110434_K().func_110577_a(this.slotImage);
        BeepediaScreen.func_238463_a_((MatrixStack)matrix, (int)xPos, (int)yPos, (float)0.0f, (float)0.0f, (int)20, (int)20, (int)20, (int)20);
        this.getMinecraft().func_175599_af().func_175042_a(item, xPos + 2, yPos + 2);
        this.getMinecraft().func_175599_af().func_175030_a(this.field_230712_o_, item, xPos + 2, yPos + 2);
    }

    public void drawEmptySlot(MatrixStack matrix, int xPos, int yPos) {
        this.getMinecraft().func_110434_K().func_110577_a(this.slotImage);
        BeepediaScreen.func_238463_a_((MatrixStack)matrix, (int)xPos, (int)yPos, (float)0.0f, (float)0.0f, (int)20, (int)20, (int)20, (int)20);
    }

    private void renderFluidTooltip(MatrixStack matrix, FluidStack fluidStack, int mouseX, int mouseY, boolean showAmount) {
        ArrayList<Object> tooltip = new ArrayList<Object>();
        tooltip.add(fluidStack.getDisplayName());
        if (showAmount) {
            DecimalFormat decimalFormat = new DecimalFormat("##0.0");
            String amount = fluidStack.getAmount() < 500 || BeeInfoUtils.isShiftPressed() ? String.format("%,d", fluidStack.getAmount()) + " mb" : decimalFormat.format((float)fluidStack.getAmount() / 1000.0f) + " B";
            tooltip.add(new StringTextComponent(amount));
        }
        tooltip.add(new StringTextComponent(fluidStack.getFluid().getRegistryName().toString()).func_240699_a_(TextFormatting.DARK_GRAY));
        this.func_243308_b(matrix, tooltip, mouseX, mouseY);
    }

    private void registerItemTooltip(ItemStack item, int xPos, int yPos) {
        this.itemTooltips.add(new ItemTooltip(item, xPos, yPos));
    }

    private void registerFluidTooltip(FluidStack fluid, int xPos, int yPos, boolean drawAmount) {
        this.fluidTooltips.add(new FluidTooltip(fluid, xPos, yPos, drawAmount));
    }

    private void registerInteraction(int xPos, int yPos, Supplier<Boolean> supplier) {
        this.interactions.add(new Interaction(xPos, yPos, supplier));
    }

    @NotNull
    public <T extends Widget> T func_230480_a_(@NotNull T widget) {
        return (T)super.func_230480_a_(widget);
    }

    public Entity initEntity(ResourceLocation entityTypeRegistryID) {
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(entityTypeRegistryID);
        if (entityType == null) {
            return null;
        }
        return entityType.func_200721_a((World)this.getMinecraft().field_71441_e);
    }

    public Button.ITooltip getTooltipProvider(ITextComponent textComponent) {
        return (button, matrix, mouseX, mouseY) -> this.func_238652_a_(matrix, textComponent, mouseX, mouseY);
    }

    public void drawInteractiveFluidSlot(MatrixStack matrix, FluidStack fluidStack, int xPos, int yPos, int mouseX, int mouseY, Supplier<Boolean> supplier) {
        this.drawInteractiveFluidSlot(matrix, fluidStack, xPos, yPos, mouseX, mouseY, true, supplier);
    }

    public void drawInteractiveFluidSlot(MatrixStack matrix, FluidStack fluidStack, int xPos, int yPos, int mouseX, int mouseY, boolean showAmount, Supplier<Boolean> supplier) {
        if (fluidStack.isEmpty()) {
            return;
        }
        this.registerInteraction(xPos, yPos, supplier);
        this.getMinecraft().func_110434_K().func_110577_a(this.buttonImage);
        if (BeepediaScreen.mouseHovering(xPos, yPos, 20, 20, mouseX, mouseY)) {
            BeepediaScreen.func_238463_a_((MatrixStack)matrix, (int)xPos, (int)yPos, (float)0.0f, (float)20.0f, (int)20, (int)20, (int)20, (int)60);
        } else {
            BeepediaScreen.func_238463_a_((MatrixStack)matrix, (int)xPos, (int)yPos, (float)0.0f, (float)0.0f, (int)20, (int)20, (int)20, (int)60);
        }
        RenderUtils.renderFluid(matrix, fluidStack, xPos + 2, yPos + 2, this.func_230927_p_());
        this.registerFluidTooltip(fluidStack, xPos, yPos, showAmount);
    }

    public void drawInteractiveSlot(MatrixStack matrix, ItemStack item, int xPos, int yPos, int mouseX, int mouseY, Supplier<Boolean> supplier) {
        if (item.func_190926_b()) {
            return;
        }
        this.registerInteraction(xPos, yPos, supplier);
        this.getMinecraft().func_110434_K().func_110577_a(this.buttonImage);
        if (BeepediaScreen.mouseHovering(xPos, yPos, 20, 20, mouseX, mouseY)) {
            BeepediaScreen.func_238463_a_((MatrixStack)matrix, (int)xPos, (int)yPos, (float)0.0f, (float)20.0f, (int)20, (int)20, (int)20, (int)60);
        } else {
            BeepediaScreen.func_238463_a_((MatrixStack)matrix, (int)xPos, (int)yPos, (float)0.0f, (float)0.0f, (int)20, (int)20, (int)20, (int)60);
        }
        this.getMinecraft().func_175599_af().func_175042_a(item, xPos + 2, yPos + 2);
        this.getMinecraft().func_175599_af().func_175030_a(this.field_230712_o_, item, xPos + 2, yPos + 2);
        this.registerItemTooltip(item, xPos, yPos);
    }

    public Map<String, BeePage> getBees(ItemStack bottleData) {
        return this.bees.entrySet().stream().filter(entrySet -> this.mapContainsBottle((BeePage)entrySet.getValue(), bottleData) && ((Boolean)Config.BEEPEDIA_HIDE_LOCKED.get() == false || ((BeePage)entrySet.getValue()).beeUnlocked)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private boolean mapContainsBottle(BeePage page, ItemStack bottleData) {
        Item beeBottle = BeeInfoUtils.getItem(page.beeData.getCentrifugeData().getBottleOutput());
        return beeBottle == bottleData.func_77973_b();
    }

    public Map<String, BeePage> getBees(String traitName) {
        return this.bees.entrySet().stream().filter(entrySet -> this.mapContainsTraitName((BeePage)entrySet.getValue(), traitName) && ((Boolean)Config.BEEPEDIA_HIDE_LOCKED.get() == false || ((BeePage)entrySet.getValue()).beeUnlocked)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private boolean mapContainsTraitName(BeePage page, String traitName) {
        return page.beeData.hasTraitNames() && Arrays.asList(page.beeData.getTraitNames()).contains(traitName);
    }

    public void drawEntityTooltip(MatrixStack matrixStack, Entity entity, int mouseX, int mouseY) {
        ArrayList<Object> tooltip = new ArrayList<Object>();
        tooltip.add(entity.func_145748_c_());
        if (entity instanceof CustomBeeEntity) {
            tooltip.addAll(BeeInfoUtils.getBeeLore(((CustomBeeEntity)entity).getBeeData()));
        }
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            tooltip.add(new StringTextComponent(entity.func_200600_R().getRegistryName().toString()).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        this.func_243308_b(matrixStack, tooltip, mouseX, mouseY);
    }

    public void drawEntityTooltip(MatrixStack matrixStack, CustomBeeData beeData, int mouseX, int mouseY) {
        ArrayList<Object> tooltip = new ArrayList<Object>();
        tooltip.add(beeData.getTranslation());
        tooltip.addAll(BeeInfoUtils.getBeeLore(beeData));
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            tooltip.add(new StringTextComponent(beeData.getEntityTypeRegistryID().toString()).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        this.func_243308_b(matrixStack, tooltip, mouseX, mouseY);
    }

    public void drawEntityLore(MatrixStack matrixStack, CustomBeeData beeData, int mouseX, int mouseY) {
        List<ITextComponent> tooltip = BeeInfoUtils.getBeeLore(beeData);
        this.func_243308_b(matrixStack, tooltip, mouseX, mouseY);
    }

    private static class Interaction {
        int xPos;
        int yPos;
        Supplier<Boolean> supplier;

        public Interaction(int xPos, int yPos, Supplier<Boolean> supplier) {
            this.xPos = xPos;
            this.yPos = yPos;
            this.supplier = supplier;
        }

        public boolean onMouseClick(int mouseX, int mouseY) {
            if (mouseX >= this.xPos && mouseY >= this.yPos && mouseX <= this.xPos + 20 && mouseY <= this.yPos + 20) {
                return this.supplier.get();
            }
            return false;
        }
    }

    private class FluidTooltip {
        private final FluidStack fluid;
        private final int xPos;
        private final int yPos;
        private final boolean showAmount;

        public FluidTooltip(FluidStack fluid, int xPos, int yPos, boolean showAmount) {
            this.fluid = fluid;
            this.xPos = xPos;
            this.yPos = yPos;
            this.showAmount = showAmount;
        }

        public void draw(MatrixStack matrix, int mouseX, int mouseY) {
            if (mouseX >= this.xPos && mouseY >= this.yPos && mouseX <= this.xPos + 20 && mouseY <= this.yPos + 20) {
                BeepediaScreen.this.renderFluidTooltip(matrix, this.fluid, mouseX, mouseY, this.showAmount);
            }
        }
    }

    private class ItemTooltip {
        private final ItemStack item;
        private final int xPos;
        private final int yPos;

        public ItemTooltip(ItemStack item, int xPos, int yPos) {
            this.item = item;
            this.xPos = xPos;
            this.yPos = yPos;
        }

        public void draw(MatrixStack matrix, int mouseX, int mouseY) {
            if (mouseX >= this.xPos && mouseY >= this.yPos && mouseX <= this.xPos + 20 && mouseY <= this.yPos + 20) {
                BeepediaScreen.this.func_230457_a_(matrix, this.item, mouseX, mouseY);
            }
        }
    }

    public static enum PageType {
        BEE,
        HONEY,
        TRAIT;

    }
}

