/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.client.gui.widget.TabImageButton;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.container.ValidatedApiaryContainer;
import com.resourcefulbees.resourcefulbees.lib.ApiaryTabs;
import com.resourcefulbees.resourcefulbees.network.NetPacketHandler;
import com.resourcefulbees.resourcefulbees.network.packets.ApiaryTabMessage;
import com.resourcefulbees.resourcefulbees.network.packets.ExportBeeMessage;
import com.resourcefulbees.resourcefulbees.network.packets.ImportBeeMessage;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import com.resourcefulbees.resourcefulbees.tileentity.multiblocks.apiary.ApiaryTileEntity;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.jetbrains.annotations.NotNull;

public class ValidatedApiaryScreen
extends ContainerScreen<ValidatedApiaryContainer> {
    private static final ResourceLocation VALIDATED_TEXTURE = new ResourceLocation("resourcefulbees", "textures/gui/apiary/validated.png");
    private static final ResourceLocation TABS_BG = new ResourceLocation("resourcefulbees", "textures/gui/apiary/apiary_gui_tabs.png");
    private int beeIndexOffset;
    private float sliderProgress;
    private boolean clickedOnScroll;
    private ApiaryTileEntity apiaryTileEntity;
    private Button importButton;
    private Button exportButton;
    private TabImageButton breedTabButton;
    private TabImageButton storageTabButton;

    public ValidatedApiaryScreen(ValidatedApiaryContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.field_146999_f = 250;
        this.field_147000_g = 152;
        this.apiaryTileEntity = ((ValidatedApiaryContainer)this.field_147002_h).getApiaryTileEntity();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.importButton = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + 73, this.field_147009_r + 10, 40, 20, (ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"gui.resourcefulbees.apiary.button.import", (Object[])new Object[0])), onPress -> this.importBee()));
        this.exportButton = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + 159, this.field_147009_r + 10, 40, 20, (ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"gui.resourcefulbees.apiary.button.export", (Object[])new Object[0])), onPress -> this.exportSelectedBee()));
        this.addTabButtons();
    }

    private void addTabButtons() {
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        int t = i + this.field_146999_f - 25;
        (this.func_230480_a_((Widget)new TabImageButton((int)(t + 1), (int)(j + 17), (int)18, (int)18, (int)110, (int)0, (int)18, (ResourceLocation)ValidatedApiaryScreen.TABS_BG, (ItemStack)new ItemStack((IItemProvider)((IItemProvider)ModItems.BEE_JAR.get())), (int)1, (int)1, (Button.IPressable)(Button.IPressable)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/widget/button/Button;)V, lambda$addTabButtons$2(net.minecraft.client.gui.widget.button.Button ), (Lnet/minecraft/client/gui/widget/button/Button;)V)((ValidatedApiaryScreen)this), (int)128, (int)128){

            @Override
            public void func_230443_a_(@NotNull MatrixStack matrix, int mouseX, int mouseY) {
                StringTextComponent s = new StringTextComponent(I18n.func_135052_a((String)"gui.resourcefulbees.apiary.button.main_screen", (Object[])new Object[0]));
                ValidatedApiaryScreen.this.func_238652_a_(matrix, (ITextComponent)s, mouseX, mouseY);
            }
        })).field_230693_o_ = false;
        this.storageTabButton = (TabImageButton)this.func_230480_a_((Widget)new TabImageButton(t + 1, j + 37, 18, 18, 110, 0, 18, TABS_BG, new ItemStack((IItemProvider)Items.field_226635_pU_), 2, 1, onPress -> this.changeScreen(ApiaryTabs.STORAGE), 128, 128){

            @Override
            public void func_230443_a_(@NotNull MatrixStack matrix, int mouseX, int mouseY) {
                StringTextComponent s = new StringTextComponent(I18n.func_135052_a((String)"gui.resourcefulbees.apiary.button.storage_screen", (Object[])new Object[0]));
                ValidatedApiaryScreen.this.func_238652_a_(matrix, (ITextComponent)s, mouseX, mouseY);
            }
        });
        this.breedTabButton = (TabImageButton)this.func_230480_a_((Widget)new TabImageButton(t + 1, j + 57, 18, 18, 110, 0, 18, TABS_BG, new ItemStack((IItemProvider)ModItems.GOLD_FLOWER_ITEM.get()), 1, 1, onPress -> this.changeScreen(ApiaryTabs.BREED), 128, 128){

            @Override
            public void func_230443_a_(@NotNull MatrixStack matrix, int mouseX, int mouseY) {
                StringTextComponent s = new StringTextComponent(I18n.func_135052_a((String)"gui.resourcefulbees.apiary.button.breed_screen", (Object[])new Object[0]));
                ValidatedApiaryScreen.this.func_238652_a_(matrix, (ITextComponent)s, mouseX, mouseY);
            }
        });
    }

    private void changeScreen(ApiaryTabs tab) {
        switch (tab) {
            case BREED: {
                if (!this.breedTabButton.field_230693_o_) break;
                NetPacketHandler.sendToServer(new ApiaryTabMessage(this.apiaryTileEntity.func_174877_v(), ApiaryTabs.BREED));
                break;
            }
            case STORAGE: {
                if (!this.storageTabButton.field_230693_o_) break;
                NetPacketHandler.sendToServer(new ApiaryTabMessage(this.apiaryTileEntity.func_174877_v(), ApiaryTabs.STORAGE));
                break;
            }
        }
    }

    private void exportSelectedBee() {
        if (this.apiaryTileEntity.getBeeCount() != 0) {
            NetPacketHandler.sendToServer(new ExportBeeMessage(((ValidatedApiaryContainer)this.field_147002_h).getPos(), ((ValidatedApiaryContainer)this.field_147002_h).getBeeList()[((ValidatedApiaryContainer)this.field_147002_h).getSelectedBee()]));
        }
    }

    private void importBee() {
        NetPacketHandler.sendToServer(new ImportBeeMessage(((ValidatedApiaryContainer)this.field_147002_h).getPos()));
    }

    public void func_230430_a_(@NotNull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.apiaryTileEntity != null) {
            this.func_230446_a_(matrix);
            super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
            this.func_230459_a_(matrix, mouseX, mouseY);
            int l = this.field_147003_i + 5;
            int i1 = this.field_147009_r + 18;
            int j1 = this.beeIndexOffset + 7;
            this.renderBeeToolTip(matrix, mouseX, mouseY, l, i1, j1);
        }
    }

    protected void func_230450_a_(@NotNull MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        Minecraft client = this.field_230706_i_;
        if (client != null && this.apiaryTileEntity != null) {
            if (((ValidatedApiaryContainer)this.field_147002_h).getSelectedBee() > this.apiaryTileEntity.getBeeCount() - 1) {
                ((ValidatedApiaryContainer)this.field_147002_h).selectBee(this.apiaryTileEntity.getBeeCount() - 1);
            }
            if (((ValidatedApiaryContainer)this.field_147002_h).getSelectedBee() == -1 && this.apiaryTileEntity.getBeeCount() > 0) {
                ((ValidatedApiaryContainer)this.field_147002_h).selectBee(0);
            }
            this.exportButton.field_230693_o_ = ((ValidatedApiaryContainer)this.field_147002_h).getSelectedBee() != -1;
            this.importButton.field_230693_o_ = this.apiaryTileEntity.getBeeCount() < (Integer)Config.APIARY_MAX_BEES.get();
            this.breedTabButton.field_230693_o_ = this.apiaryTileEntity.getApiaryBreeder() != null;
            this.storageTabButton.field_230693_o_ = this.apiaryTileEntity.getApiaryStorage() != null;
            ((ValidatedApiaryContainer)this.field_147002_h).setBeeList((String[])Arrays.copyOf(this.apiaryTileEntity.bees.keySet().toArray(), this.apiaryTileEntity.getBeeCount(), String[].class));
            this.field_230706_i_.func_110434_K().func_110577_a(VALIDATED_TEXTURE);
            int i = this.field_147003_i;
            int j = this.field_147009_r;
            this.func_238474_b_(matrix, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
            if (!this.canScroll()) {
                this.sliderProgress = 0.0f;
            }
            int k = (int)(99.0f * this.sliderProgress);
            this.func_238474_b_(matrix, i + 44, j + 18 + k, 54 + (this.canScroll() ? 0 : 6), 152, 6, 27);
            int l = this.field_147003_i + 5;
            int i1 = this.field_147009_r + 18;
            int j1 = this.beeIndexOffset + 7;
            this.drawRecipesBackground(matrix, mouseX, mouseY, l, i1, j1);
            this.drawBees(l, i1, j1);
            int t = i + this.field_146999_f - 25;
            this.field_230706_i_.func_110434_K().func_110577_a(TABS_BG);
            ValidatedApiaryScreen.func_238463_a_((MatrixStack)matrix, (int)(t - 1), (int)(j + 12), (float)0.0f, (float)0.0f, (int)25, (int)68, (int)128, (int)128);
        }
    }

    protected void func_230451_b_(@NotNull MatrixStack matrix, int mouseX, int mouseY) {
        String s = String.format("(%1$s/%2$s) Bees", this.apiaryTileEntity.getBeeCount(), Config.APIARY_MAX_BEES.get());
        this.field_230712_o_.func_238421_b_(matrix, s, 4.0f, 7.0f, 0x404040);
        for (Widget widget : this.field_230710_m_) {
            if (!widget.func_230449_g_()) continue;
            widget.func_230443_a_(matrix, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            break;
        }
    }

    private void renderBeeToolTip(@NotNull MatrixStack matrix, int mouseX, int mouseY, int left, int top, int beeIndexOffsetMax) {
        for (int i = this.beeIndexOffset; i < beeIndexOffsetMax && i < this.apiaryTileEntity.getBeeCount(); ++i) {
            int j = i - this.beeIndexOffset;
            int i1 = top + j * 18;
            if (mouseX < left || mouseY < i1 || mouseX >= left + 16 || mouseY >= i1 + 18) continue;
            ArrayList<Object> beeInfo = new ArrayList<Object>();
            ApiaryTileEntity.ApiaryBee apiaryBee = ((ValidatedApiaryContainer)this.field_147002_h).getApiaryBee(i);
            int ticksInHive = apiaryBee.getTicksInHive();
            int minTicks = apiaryBee.minOccupationTicks;
            int ticksLeft = Math.max(minTicks - ticksInHive, 0);
            beeInfo.add(apiaryBee.displayName);
            beeInfo.add(new StringTextComponent(I18n.func_135052_a((String)"gui.resourcefulbees.apiary.bee.ticks_in_hive", (Object[])new Object[0]) + ": " + ticksInHive));
            beeInfo.add(new StringTextComponent(I18n.func_135052_a((String)"gui.resourcefulbees.apiary.bee.ticks_left", (Object[])new Object[0]) + ": " + ticksLeft));
            this.func_243308_b(matrix, beeInfo, mouseX, mouseY);
        }
    }

    private void drawRecipesBackground(@NotNull MatrixStack matrix, int mouseX, int mouseY, int left, int top, int beeIndexOffsetMax) {
        for (int i = this.beeIndexOffset; i < beeIndexOffsetMax && i < this.apiaryTileEntity.getBeeCount(); ++i) {
            int j = i - this.beeIndexOffset;
            int k = left;
            int i1 = top + j * 18;
            int j1 = this.field_147000_g;
            if (i == ((ValidatedApiaryContainer)this.field_147002_h).getSelectedBee()) {
                j1 += 18;
            } else if (mouseX >= k && mouseY >= i1 && mouseX < k + 16 && mouseY < i1 + 18) {
                j1 += 36;
            }
            this.func_238474_b_(matrix, k, i1, 0, j1, 18, 18);
            int l1 = 18;
            k += 18;
            j1 = this.field_147000_g;
            if (((ValidatedApiaryContainer)this.field_147002_h).getApiaryBee(i).isLocked()) {
                l1 += 18;
            }
            if (mouseX >= k && mouseY >= i1 && mouseX < k + 16 && mouseY < i1 + 18) {
                j1 += 18;
            }
            this.func_238474_b_(matrix, k, i1, l1, j1, 18, 18);
        }
    }

    private void drawBees(int left, int top, int beeIndexOffsetMax) {
        for (int i = this.beeIndexOffset; i < beeIndexOffsetMax && i < this.apiaryTileEntity.getBeeCount(); ++i) {
            int j = i - this.beeIndexOffset;
            int i1 = top + j * 18 + 2;
            ItemStack beeJar = new ItemStack((IItemProvider)ModItems.BEE_JAR.get());
            CompoundNBT data = new CompoundNBT();
            CompoundNBT tag = ((ValidatedApiaryContainer)this.field_147002_h).getApiaryBee((int)i).entityData;
            String entityID = tag.func_74779_i("id");
            data.func_74778_a("Entity", entityID);
            data.func_74778_a("Color", ((ValidatedApiaryContainer)this.field_147002_h).getApiaryBee((int)i).beeColor);
            beeJar.func_77982_d(data);
            if (this.field_230706_i_ == null) continue;
            this.field_230706_i_.func_175599_af().func_180450_b(beeJar, left, i1);
        }
    }

    private boolean canScroll() {
        return this.apiaryTileEntity.getBeeCount() > 7;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scrollAmount) {
        if (this.canScroll()) {
            int i = this.getHiddenRows();
            this.sliderProgress = (float)((double)this.sliderProgress - scrollAmount / (double)i);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.beeIndexOffset = (int)((double)(this.sliderProgress * (float)i) + 0.5);
        }
        return true;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int pMouseDragged5, double pMouseDragged6, double pMouseDragged8) {
        if (this.clickedOnScroll && this.canScroll()) {
            int i = this.field_147009_r + 14;
            int j = i + 101;
            this.sliderProgress = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.beeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5);
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, pMouseDragged5, pMouseDragged6, pMouseDragged8);
    }

    private int getHiddenRows() {
        return this.apiaryTileEntity.getBeeCount() - 7;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int pMouseClicked5) {
        this.clickedOnScroll = false;
        if (this.apiaryTileEntity.getBeeCount() > 0) {
            int i = this.field_147003_i + 5;
            int j = this.field_147009_r + 18;
            int k = this.beeIndexOffset + 7;
            for (int l = this.beeIndexOffset; l < k; ++l) {
                int i1 = l - this.beeIndexOffset;
                double d0 = mouseX - (double)i;
                double d1 = mouseY - (double)(j + i1 * 18);
                if (d0 >= 0.0 && d1 >= 0.0 && d0 < 17.0 && d1 < 17.0 && ((ValidatedApiaryContainer)this.field_147002_h).selectBee(l)) {
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                    return true;
                }
                if (!(d0 >= 18.0) || !(d1 >= 0.0) || !(d0 < 35.0) || !(d1 < 17.0) || !((ValidatedApiaryContainer)this.field_147002_h).lockOrUnlockBee(l)) continue;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                return true;
            }
            i = this.field_147003_i + 44;
            j = this.field_147009_r + 18;
            if (mouseX >= (double)i && mouseX < (double)(i + 6) && mouseY >= (double)j && mouseY < (double)(j + 101)) {
                this.clickedOnScroll = true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, pMouseClicked5);
    }

    private /* synthetic */ void lambda$addTabButtons$2(Button onPress) {
        this.changeScreen(ApiaryTabs.MAIN);
    }
}

